// $Id: HFChangeGround.cpp,v 1.8 2003/02/27 23:43:40 zongo Exp $

#include <iostream>

#include "HFChangeGround.h"
#include "HeightFieldCommand.h"


HFChangeGround 
HFChangeGround::s_CurrentGround = HFChangeGround(0, 1, 1);

HFChangeGround* 
HFChangeGround::CreateNewTool(World* world)
{
  // A bit dirty, but I have no other idea for the moment
  int type = s_CurrentGround.m_GroundType;
  int size = s_CurrentGround.m_BrushSize;

  return new HFChangeGround(world, type, size);
}


HFChangeGround::HFChangeGround(World* world, int type, int size) :
  HeightFieldChange( world ),
  m_GroundType( type ),
  m_BrushSize( size )
{
}


/// Create a command with a correct state.
Command* 
HFChangeGround::CreateCommand()
{
    if (!m_State) return 0;

    const unsigned int size = m_World->m_SizeX * m_World->m_SizeZ;
    HeightFieldCommand* command = new HFCGCommand(m_World, "Ground change");

    for (unsigned int i=0 ; i<size ; ++i)
    {
	const short state = m_State[i];
	if (0 <= state)
	{
	    command->AddState(i, state);
	}
    }

    return command;
}


void 
HFChangeGround::Apply(int gx, int gz) 
{
    // initialize with -1 (not touched value)
    InitState( -1 );

    const int brush = m_BrushSize;
    const int radius2 = brush * brush;

    ClampCoord(gx, gz);

    int bx = gx - brush - 1;
    int bz = gz - brush - 1;
    ClampCoord(bx, bz);

    int ex = gx + brush;
    int ez = gz + brush;
    ClampCoord(ex, ez);

    for (int z = bz; z <= ez; ++z)
    {
	const int dz = gz - z;
	const int part2 = dz * dz;      

	for (int x = bx; x <= ex; ++x)
	{
	    const int dx = gx - x;
	    const int dist2 = part2 + dx * dx;

	    if (dist2 < radius2)
	    {
		uchar& ground = m_World->GetGround(x, z);
		
		// Save the state if not already saved
		short& state = GetState(x, z);
		if (state < 0)
		    state = ground;

		// Change the ground
		ground = (uchar) m_GroundType;
	    }

	}
    }

  m_World->Invalidate ((float)bx, (float)bz, (float)ex, (float)ez);
}



