/*
 *	Xenophilia GTK+ Theme Engine
 *
 *	xeno_theme_images.c:
 *		Images, remapping data and shadows
 *
 *	Copyright  1999-2001 Johan Hanson <johan@tiq.com>.
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Library General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Library General Public License for more details.
 *
 *	You should have received a copy of the GNU Library General Public
 *	License along with this library; if not, write to the
 *	Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *	Boston, MA  02111-1307  USA.
 */

#include "xeno_theme_images.h"

/*	Radio button
	"radio_selected_xpm" for selected button, NORMAL and SELECTED states
	"radio_normal_xpm" otherwise
	
	radio_normal_remap:		normal/prelight state
	radio_down_remap: 		normal/prelight + button down
	radio_selected_remap:	selected
*/
const static char * radio_normal_xpm[] = {
"13 13 61 1",
". c #000000",
"P c #000000",
"A c #000000",
"C c #000000",
"E c #000000",
"F c #000000",
"G c #000000",
"H c #000000",
"I c #000000",
"J c #000000",
"K c #000000",
"M c #000000",
"N c #000000",
"O c #000000",
"Q c #000000",
"z c #000000",
"! c #000000",
"% c #000000",
"& c #000000",
"i c #000000",
"j c #000000",
"8 c #000000",
"9 c #000000",
"W c #000000",
"B c #000000",
"L c #000000",
"D c #000000",
"0 c #000000",
"1 c #000000",
"2 c #000000",
"3 c #000000",
"4 c #000000",
"5 c #000000",
"6 c #000000",
"7 c #000000",
"a c #000000",
"b c #000000",
"c c #000000",
"d c #000000",
"e c #000000",
"f c #000000",
"g c #000000",
"h c #000000",
"k c #000000",
"l c #000000",
"m c #000000",
"n c #000000",
"o c #000000",
"p c #000000",
"q c #000000",
"r c #000000",
"s c #000000",
"t c #000000",
"u c #000000",
"v c #000000",
"w c #000000",
"x c #000000",
"y c #000000",
"# c #000000",
"$ c #000000",
"  None",
"   210Wklm   ",
"  3654Lstun  ",	/*	A94		236		P5	255		*/
" 37P98Ez!#vo ",	/*	C8L		218		Qf	0		*/
"26PACEFGH.$wp",	/*	Es		200					*/
"159CEFGH.I%xq",	/*	Fzt		182					*/
"048EFGH.IJ&yr",	/*	G!u		163					*/
"WLEFGH.IJKMDB",	/*	H#		145					*/
"kszGH.IJKMiea",	/*	I$		109					*/
"lt!H.IJKMNjfb",	/*	J%w		91					*/
"mu#.IJKMNOQgc",	/*	K&x		72					*/
" nv$%&MijQhd ",	/*	My		54					*/
"  owxyDefgd  ",	/*	NiD		36					*/
"   pqrBabc   "		/*	Oje		18					*/
};

const static char * radio_selected_xpm[] = {
"13 13 51 1",
". c #000000",
"S c #000000",
"? c #000000",
"= c #000000",
"* c #000000",
"z c #000000",
"! c #000000",
"% c #000000",
"& c #000000",
"i c #000000",
"j c #000000",
"8 c #000000",
"9 c #000000",
"W c #000000",
"B c #000000",
"L c #000000",
"D c #000000",
"0 c #000000",
"1 c #000000",
"2 c #000000",
"3 c #000000",
"4 c #000000",
"5 c #000000",
"6 c #000000",
"7 c #000000",
"a c #000000",
"b c #000000",
"c c #000000",
"d c #000000",
"e c #000000",
"f c #000000",
"g c #000000",
"h c #000000",
"k c #000000",
"l c #000000",
"m c #000000",
"n c #000000",
"o c #000000",
"p c #000000",
"q c #000000",
"r c #000000",
"s c #000000",
"t c #000000",
"u c #000000",
"v c #000000",
"w c #000000",
"x c #000000",
"y c #000000",
"# c #000000",
"$ c #000000",
"  None",
"   210Wklm   ",
"  3654Lstun  ",
" 37L98.z!#vo ",
"26L..*?*..$wp",
"159.=SSS=.%xq",
"048*SSSSS*&yr",
"WL.?SSSSS?.DB",
"ksz*SSSSS*iea",
"lt!.=SSS=.jfb",
"mu#..*?*..Dgc",
" nv$%&.ijDhd ",
"  owxyDefgd  ",
"   pqrBabc   "
};

const static guchar radio_normal_remap[] = {
	'.', XENO_BG,XENO_CURRENT,
	
	'P', XENO_THIN, XENO_GRADIENT_BG,XENO_CURRENT,255,	XENO_TOP,1,
	'A', XENO_GRADIENT_BG,XENO_CURRENT,236,
	'C', XENO_GRADIENT_BG,XENO_CURRENT,218,
	'E', XENO_GRADIENT_BG,XENO_CURRENT,200,
	'F', XENO_GRADIENT_BG,XENO_CURRENT,182,
	'G', XENO_GRADIENT_BG,XENO_CURRENT,163,
	'H', XENO_GRADIENT_BG,XENO_CURRENT,145,
	
	'I', XENO_GRADIENT_BG,XENO_CURRENT,109,
	'J', XENO_GRADIENT_BG,XENO_CURRENT,91,
	'K', XENO_GRADIENT_BG,XENO_CURRENT,72,
	'M', XENO_GRADIENT_BG,XENO_CURRENT,54,
	'N', XENO_GRADIENT_BG,XENO_CURRENT,36,
	'O', XENO_GRADIENT_BG,XENO_CURRENT,18,
	'Q', XENO_THIN, XENO_GRADIENT_BG,XENO_CURRENT,0,	XENO_BOT,1,
	
	'z', XENO_THIN, XENO_GRADIENT_BG,XENO_CURRENT,182,	XENO_TRI, 40,230,	XENO_TOP,1,	XENO_BOT,1,	XENO_GRADIENT_BG,XENO_CURRENT,182,
	'!', XENO_THIN, XENO_GRADIENT_BG,XENO_CURRENT,163,	XENO_TRI, 75,153,	XENO_TOP,1,	XENO_BOT,1,	XENO_GRADIENT_BG,XENO_CURRENT,163,
	'%', XENO_THIN, XENO_GRADIENT_BG,XENO_CURRENT,91,	XENO_TRI, 75,153,	XENO_BOT,1,	XENO_TOP,1,	XENO_GRADIENT_BG,XENO_CURRENT,91,
	'&', XENO_THIN, XENO_GRADIENT_BG,XENO_CURRENT,72,	XENO_TRI, 40,230,	XENO_BOT,1,	XENO_TOP,1,	XENO_GRADIENT_BG,XENO_CURRENT,72,
	
	'i', XENO_THIN, XENO_GRADIENT_BG,XENO_CURRENT,36,	XENO_BI, 230,	XENO_BOT,1,	XENO_GRADIENT_BG,XENO_CURRENT,36,
	'j', XENO_THIN, XENO_GRADIENT_BG,XENO_CURRENT,18,	XENO_BI, 153,	XENO_BOT,1,	XENO_GRADIENT_BG,XENO_CURRENT,18,
	'8', XENO_THIN, XENO_GRADIENT_BG,XENO_CURRENT,218,	XENO_BI, 230,	XENO_TOP,1,	XENO_GRADIENT_BG,XENO_CURRENT,218,
	'9', XENO_THIN, XENO_GRADIENT_BG,XENO_CURRENT,236,	XENO_BI, 153,	XENO_TOP,1,	XENO_GRADIENT_BG,XENO_CURRENT,236,
	
	'W', XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'B', XENO_THIN, XENO_BOT,1, XENO_BOT,0,
	'L', XENO_THIN, XENO_GRADIENT_BG,XENO_CURRENT,218,	XENO_TOP,1,
	'D', XENO_THIN, XENO_GRADIENT_BG,XENO_CURRENT,36,	XENO_BOT,1,
	
	'0', XENO_BI, 234,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'1', XENO_BI, 170,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'2', XENO_BI, 51,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'3', XENO_BI, 127,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'4', XENO_BI, 21,	XENO_THIN, XENO_GRADIENT_BG,XENO_CURRENT,236,XENO_TOP,1,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'5', XENO_BI, 85,	XENO_THIN, XENO_GRADIENT_BG,XENO_CURRENT,255,XENO_TOP,1,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'6', XENO_BI, 204,	XENO_THIN, XENO_GRADIENT_BG,XENO_CURRENT,255,XENO_TOP,1,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'7', XENO_BI, 128,	XENO_THIN, XENO_GRADIENT_BG,XENO_CURRENT,255,XENO_TOP,1,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	
	'a', XENO_BI, 234,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'b', XENO_BI, 170,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'c', XENO_BI, 51,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'd', XENO_BI, 127,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	
	'e', XENO_BI, 21,	XENO_THIN,XENO_GRADIENT_BG,XENO_CURRENT,18,XENO_BOT,1,		XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'f', XENO_BI, 85,	XENO_THIN,XENO_GRADIENT_BG,XENO_CURRENT,0,XENO_BOT,1,		XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'g', XENO_BI, 204,	XENO_THIN,XENO_GRADIENT_BG,XENO_CURRENT,255,XENO_BOT,1,		XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'h', XENO_BI, 128,	XENO_THIN,XENO_GRADIENT_BG,XENO_CURRENT,255,XENO_BOT,1,		XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	
	'k', XENO_TRI, 27,		21,		XENO_THIN,XENO_TOP,1,XENO_TOP,0,XENO_THIN,XENO_BOT,1,XENO_BOT,0,	XENO_BG,XENO_PARENT|XENO_NORMAL,
	'l', XENO_TRI, 52,		85,		XENO_THIN,XENO_TOP,1,XENO_TOP,0,XENO_THIN,XENO_BOT,1,XENO_BOT,0,	XENO_BG,XENO_PARENT|XENO_NORMAL,
	'm', XENO_TRI, 75,		204,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,XENO_THIN,XENO_BOT,1,XENO_BOT,0,	XENO_BG,XENO_PARENT|XENO_NORMAL,
	'n', XENO_TRI, 110,		127,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,XENO_THIN,XENO_BOT,1,XENO_BOT,0,	XENO_BG,XENO_PARENT|XENO_NORMAL,
	'o', XENO_TRI, 110,		127,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,XENO_THIN,XENO_TOP,1,XENO_TOP,0,	XENO_BG,XENO_PARENT|XENO_NORMAL,
	'p', XENO_TRI, 75,		204,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,XENO_THIN,XENO_TOP,1,XENO_TOP,0,	XENO_BG,XENO_PARENT|XENO_NORMAL,
	'q', XENO_TRI, 52,		85,		XENO_THIN,XENO_BOT,1,XENO_BOT,0,XENO_THIN,XENO_TOP,1,XENO_TOP,0,	XENO_BG,XENO_PARENT|XENO_NORMAL,
	'r', XENO_TRI, 27,		21,		XENO_THIN,XENO_BOT,1,XENO_BOT,0,XENO_THIN,XENO_TOP,1,XENO_TOP,0,	XENO_BG,XENO_PARENT|XENO_NORMAL,
	
	's', XENO_QUAD, 21,		32,		XENO_THIN,XENO_GRADIENT_BG,XENO_CURRENT,200,XENO_TOP,1,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,		XENO_THIN,XENO_GRADIENT_BG,XENO_CURRENT,200,XENO_BOT,1,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	't', XENO_QUAD, 85,		62,		XENO_THIN,XENO_GRADIENT_BG,XENO_CURRENT,182,XENO_TOP,1,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,		XENO_THIN,XENO_GRADIENT_BG,XENO_CURRENT,182,XENO_BOT,1,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'u', XENO_QUAD, 204,	88,		XENO_THIN,XENO_GRADIENT_BG,XENO_CURRENT,163,XENO_TOP,1,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,		XENO_THIN,XENO_GRADIENT_BG,XENO_CURRENT,163,XENO_BOT,1,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'v', XENO_QUAD, 128,	127,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_TOP,1,				XENO_THIN,XENO_TOP,1,XENO_TOP,0,		XENO_THIN,XENO_BG,XENO_CURRENT,							XENO_BOT,1,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'w', XENO_QUAD, 204,	88,		XENO_THIN,XENO_GRADIENT_BG,XENO_CURRENT,91,XENO_BOT,1,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,		XENO_THIN,XENO_GRADIENT_BG,XENO_CURRENT,91,XENO_TOP,1,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,
	'x', XENO_QUAD, 85,		62,		XENO_THIN,XENO_GRADIENT_BG,XENO_CURRENT,72,XENO_BOT,1,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,		XENO_THIN,XENO_GRADIENT_BG,XENO_CURRENT,72,XENO_TOP,1,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,
	'y', XENO_QUAD, 21,		32,		XENO_THIN,XENO_GRADIENT_BG,XENO_CURRENT,54,XENO_BOT,1,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,		XENO_THIN,XENO_GRADIENT_BG,XENO_CURRENT,54,XENO_TOP,1,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,
	
	'#', XENO_BI, 116,	XENO_THIN,XENO_GRADIENT_BG,XENO_CURRENT,145,XENO_TOP,1,	XENO_THIN,XENO_GRADIENT_BG,XENO_CURRENT,145,XENO_BOT,1,
	'$', XENO_BI, 116,	XENO_THIN,XENO_GRADIENT_BG,XENO_CURRENT,109,XENO_BOT,1,	XENO_THIN,XENO_GRADIENT_BG,XENO_CURRENT,109,XENO_TOP,1,
	0
};

const static guchar radio_down_insensitive_remap[] = {
	'.', XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	
	'P', XENO_THIN, XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,	XENO_TOP,1,
	'A', XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'C', XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'E', XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'F', XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'G', XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'H', XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	
	'I', XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'J', XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'K', XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'M', XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'N', XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'O', XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'Q', XENO_THIN, XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,	XENO_BOT,1,
	
	'z', XENO_THIN, XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,	XENO_TRI, 40,230,	XENO_TOP,1,	XENO_BOT,1,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'!', XENO_THIN, XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,	XENO_TRI, 75,153,	XENO_TOP,1,	XENO_BOT,1,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'%', XENO_THIN, XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,	XENO_TRI, 75,153,	XENO_BOT,1,	XENO_TOP,1,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'&', XENO_THIN, XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,	XENO_TRI, 40,230,	XENO_BOT,1,	XENO_TOP,1,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	
	'i', XENO_THIN, XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,	XENO_BI, 230,	XENO_BOT,1,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'j', XENO_THIN, XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,	XENO_BI, 153,	XENO_BOT,1,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'8', XENO_THIN, XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,	XENO_BI, 230,	XENO_TOP,1,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'9', XENO_THIN, XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,	XENO_BI, 153,	XENO_TOP,1,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	
	'W', XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'B', XENO_THIN, XENO_BOT,1, XENO_BOT,0,
	'L', XENO_THIN, XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,	XENO_TOP,1,
	'D', XENO_THIN, XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,	XENO_BOT,1,
	
	'0', XENO_BI, 234,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'1', XENO_BI, 170,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'2', XENO_BI, 51,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'3', XENO_BI, 127,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'4', XENO_BI, 21,	XENO_THIN, XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_TOP,1,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'5', XENO_BI, 85,	XENO_THIN, XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_TOP,1,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'6', XENO_BI, 204,	XENO_THIN, XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_TOP,1,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'7', XENO_BI, 128,	XENO_THIN, XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_TOP,1,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	
	'a', XENO_BI, 234,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'b', XENO_BI, 170,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'c', XENO_BI, 51,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'd', XENO_BI, 127,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	
	'e', XENO_BI, 21,	XENO_THIN,XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_BOT,1,		XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'f', XENO_BI, 85,	XENO_THIN,XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_BOT,1,		XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'g', XENO_BI, 204,	XENO_THIN,XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_BOT,1,		XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'h', XENO_BI, 128,	XENO_THIN,XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_BOT,1,		XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	
	'k', XENO_TRI, 27,		21,		XENO_THIN,XENO_TOP,1,XENO_TOP,0,XENO_THIN,XENO_BOT,1,XENO_BOT,0,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'l', XENO_TRI, 52,		85,		XENO_THIN,XENO_TOP,1,XENO_TOP,0,XENO_THIN,XENO_BOT,1,XENO_BOT,0,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'm', XENO_TRI, 75,		204,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,XENO_THIN,XENO_BOT,1,XENO_BOT,0,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'n', XENO_TRI, 110,		127,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,XENO_THIN,XENO_BOT,1,XENO_BOT,0,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'o', XENO_TRI, 110,		127,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,XENO_THIN,XENO_TOP,1,XENO_TOP,0,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'p', XENO_TRI, 75,		204,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,XENO_THIN,XENO_TOP,1,XENO_TOP,0,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'q', XENO_TRI, 52,		85,		XENO_THIN,XENO_BOT,1,XENO_BOT,0,XENO_THIN,XENO_TOP,1,XENO_TOP,0,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	'r', XENO_TRI, 27,		21,		XENO_THIN,XENO_BOT,1,XENO_BOT,0,XENO_THIN,XENO_TOP,1,XENO_TOP,0,	XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,
	
	's', XENO_QUAD, 21,		32,		XENO_THIN,XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_TOP,1,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,		XENO_THIN,XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_BOT,1,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	't', XENO_QUAD, 85,		62,		XENO_THIN,XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_TOP,1,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,		XENO_THIN,XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_BOT,1,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'u', XENO_QUAD, 204,	88,		XENO_THIN,XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_TOP,1,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,		XENO_THIN,XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_BOT,1,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'v', XENO_QUAD, 128,	127,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_TOP,1,				XENO_THIN,XENO_TOP,1,XENO_TOP,0,		XENO_THIN,XENO_BG,XENO_CURRENT,							XENO_BOT,1,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'w', XENO_QUAD, 204,	88,		XENO_THIN,XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_BOT,1,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,		XENO_THIN,XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_TOP,1,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,
	'x', XENO_QUAD, 85,		62,		XENO_THIN,XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_BOT,1,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,		XENO_THIN,XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_TOP,1,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,
	'y', XENO_QUAD, 21,		32,		XENO_THIN,XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_BOT,1,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,		XENO_THIN,XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_TOP,1,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,
	
	'#', XENO_BI, 116,	XENO_THIN,XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_TOP,1,	XENO_THIN,XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_BOT,1,
	'$', XENO_BI, 116,	XENO_THIN,XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_BOT,1,	XENO_THIN,XENO_BG,XENO_PARENT|XENO_PARENT_CURRENT,XENO_TOP,1,
	0
};

const static guchar radio_selected_remap[] = {
	'.', XENO_BASE,XENO_CURRENT,
	'S', XENO_BASE,XENO_SELECTED,
	'?', XENO_BI,	127,			XENO_BASE,XENO_CURRENT,		XENO_BASE,XENO_SELECTED,
	'=', XENO_BI,	179,			XENO_BASE,XENO_CURRENT,		XENO_BASE,XENO_SELECTED,
	'*', XENO_BI,	83,				XENO_BASE,XENO_CURRENT,		XENO_BASE,XENO_SELECTED,
	'z', XENO_TRI,	40,		230,	XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_TOP,1,		XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_BOT,1,		XENO_BASE,XENO_CURRENT,
	'!', XENO_TRI,	75,		153,	XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_TOP,1,		XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_BOT,1,		XENO_BASE,XENO_CURRENT,
	'%', XENO_TRI,	75,		153,	XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_BOT,1,		XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_TOP,1,		XENO_BASE,XENO_CURRENT,
	'&', XENO_TRI,	40,		230,	XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_BOT,1,		XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_TOP,1,		XENO_BASE,XENO_CURRENT,
	'i', XENO_BI,	230,			XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_BOT,1,		XENO_BASE,XENO_CURRENT,
	'j', XENO_BI,	153,			XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_BOT,1,		XENO_BASE,XENO_CURRENT,
	'8', XENO_BI,	230,			XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_TOP,1,		XENO_BASE,XENO_CURRENT,
	'9', XENO_BI,	153,			XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_TOP,1,		XENO_BASE,XENO_CURRENT,

	'W', XENO_TOP,0,
	'B', XENO_BOT,0,
	'L', XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_TOP,1,
	'D', XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_BOT,1,
	 
	'0', XENO_BI, 234,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_TOP,0,
	'1', XENO_BI, 170,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_TOP,0,
	'2', XENO_BI, 51,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_TOP,0,
	'3', XENO_BI, 127,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_TOP,0,
	'4', XENO_BI, 21,	XENO_THIN,XENO_BASE,XENO_CURRENT,	XENO_TOP,1,	XENO_TOP,0,
	'5', XENO_BI, 85,	XENO_THIN,XENO_BASE,XENO_CURRENT,	XENO_TOP,1,	XENO_TOP,0,
	'6', XENO_BI, 204,	XENO_THIN,XENO_BASE,XENO_CURRENT,	XENO_TOP,1,	XENO_TOP,0,
	'7', XENO_BI, 128,	XENO_THIN,XENO_BASE,XENO_CURRENT,	XENO_TOP,1,	XENO_TOP,0,
	
	'a', XENO_BI, 234,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_BOT,0,
	'b', XENO_BI, 170,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_BOT,0,
	'c', XENO_BI, 51,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_BOT,0,
	'd', XENO_BI, 127,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_BOT,0,
	'e', XENO_BI, 21,	XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_BOT,1,				XENO_BOT,0,
	'f', XENO_BI, 85,	XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_BOT,1,				XENO_BOT,0,
	'g', XENO_BI, 204,	XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_BOT,1,				XENO_BOT,0,
	'h', XENO_BI, 128,	XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_BOT,1,				XENO_BOT,0,
	
	'k', XENO_TRI, 27,	21,		XENO_TOP,0,		XENO_BOT,0,		XENO_BG,XENO_PARENT|XENO_NORMAL,
	'l', XENO_TRI, 52,	85,		XENO_TOP,0,		XENO_BOT,0,		XENO_BG,XENO_PARENT|XENO_NORMAL,
	'm', XENO_TRI, 75,	204,	XENO_TOP,0,		XENO_BOT,0,		XENO_BG,XENO_PARENT|XENO_NORMAL,
	'n', XENO_TRI, 110,	127,	XENO_TOP,0,		XENO_BOT,0,		XENO_BG,XENO_PARENT|XENO_NORMAL,
	'o', XENO_TRI, 110,	127,	XENO_BOT,0,		XENO_TOP,0,		XENO_BG,XENO_PARENT|XENO_NORMAL,
	'p', XENO_TRI, 75,	204,	XENO_BOT,0,		XENO_TOP,0,		XENO_BG,XENO_PARENT|XENO_NORMAL,
	'q', XENO_TRI, 52,	85,		XENO_BOT,0,		XENO_TOP,0,		XENO_BG,XENO_PARENT|XENO_NORMAL,
	'r', XENO_TRI, 27,	21,		XENO_BOT,0,		XENO_TOP,0,		XENO_BG,XENO_PARENT|XENO_NORMAL,
	
	's', XENO_QUAD, 21,	32,		XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_TOP,1,		XENO_TOP,0,	XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_BOT,1,		XENO_BOT,0,
	't', XENO_QUAD, 85,	62,		XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_TOP,1,		XENO_TOP,0, 	XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_BOT,1,		XENO_BOT,0,
	'u', XENO_QUAD, 204,88,		XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_TOP,1,		XENO_TOP,0, 	XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_BOT,1,		XENO_BOT,0,
	'v', XENO_QUAD, 128,127,	XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_TOP,1,		XENO_TOP,0, 	XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_BOT,1,		XENO_BOT,0,
	'w', XENO_QUAD, 204,88,		XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_BOT,1,		XENO_BOT,0,	XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_TOP,1,		XENO_TOP,0,
	'x', XENO_QUAD, 85,	62,		XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_BOT,1,		XENO_BOT,0,	XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_TOP,1,		XENO_TOP,0,
	'y', XENO_QUAD, 21,	32,		XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_BOT,1,		XENO_BOT,0,	XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_TOP,1,		XENO_TOP,0,
	
	'#', XENO_BI, 116,	XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_TOP,1,		XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_BOT,1,
	'$', XENO_BI, 116,	XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_BOT,1,		XENO_THIN,XENO_BASE,XENO_CURRENT,XENO_TOP,1,
	0
};

/* low-color radio button */
const static char * radio_low_xpm[] = {
"13 13 10 1",
"# c #dddddd",
"S c #685977",
"W c #ffffff",
"B c #000000",
"l c #d5d4d3",
"d c #636261",
"L c #d5d4d3",
"D c #636261",
"M c #a3a2a0",
"  c None",
"    ddddd    ",
"  ddBBBBBdD  ",
" dBB#####DML ",
" dB#######Ll ",
"dB###SSS###Wl",
"dB##SSSSS##Wl",
"dB##SSSSS##Wl",
"dB##SSSSS##Wl",
"dB###SSS###Wl",
" dD#######Wl ",
" DML#####WWl ",
"  LlWWWWWll  ",
"    lllll    ",
};

const static guchar radio_low_normal_remap[] = {
	'#', XENO_BG,XENO_CURRENT,
	'S', XENO_BG,XENO_CURRENT,
	'W', XENO_BOT,1,
	'B', XENO_TOP,1,
	'l', XENO_BOT,0,
	'd', XENO_TOP,0,
	'L', XENO_BOT,1,
	'D', XENO_TOP,1,
	'M', XENO_CORNER,1,
	0
};

const static guchar radio_low_down_remap[] = {
	'#', XENO_BG,XENO_CURRENT,
	'S', XENO_BG,XENO_CURRENT,
	'W', XENO_BOT,1,
	'B', XENO_TOP,1,
	'l', XENO_BOT,0,
	'd', XENO_TOP,0,
	'L', XENO_BOT,0,
	'D', XENO_TOP,0,
	'M', XENO_CORNER,1,
	0
};

const static guchar radio_low_selected_remap[] = {
	'#', XENO_BASE,XENO_CURRENT,
	'S', XENO_BASE,XENO_SELECTED,
	'W', XENO_BOT,1,
	'B', XENO_TOP,1,
	'l', XENO_BOT,0,
	'd', XENO_TOP,0,
	'L', XENO_BOT,0,
	'D', XENO_TOP,0,
	'M', XENO_CORNER,1,
	0
};


/* Checkmark
	"check_xpm" for all images
	
	check_bg_remap:		for images with normal or active state.
	check_base_remap:	for images with "base" as background.
*/
const static guchar check_bg_remap[] = {
	'#', XENO_FG,XENO_CURRENT,
	'a', XENO_BI, 64, XENO_FG,XENO_CURRENT, XENO_BG,XENO_CURRENT,
	'b', XENO_BI, 192, XENO_FG,XENO_CURRENT, XENO_BG,XENO_CURRENT,
	'c', XENO_BI, 127, XENO_FG,XENO_CURRENT, XENO_BG,XENO_CURRENT,
	'd', XENO_BI, 170, XENO_FG,XENO_CURRENT, XENO_BG,XENO_CURRENT,
	0
};

const static guchar check_base_remap[] = {
	'#', XENO_FG,XENO_CURRENT,
	'a', XENO_BI, 64, XENO_FG,XENO_CURRENT, XENO_BASE,XENO_CURRENT,
	'b', XENO_BI, 192, XENO_FG,XENO_CURRENT, XENO_BASE,XENO_CURRENT,
	'c', XENO_BI, 127, XENO_FG,XENO_CURRENT, XENO_BASE,XENO_CURRENT,
	'd', XENO_BI, 170, XENO_FG,XENO_CURRENT, XENO_BASE,XENO_CURRENT,
	0
};

const static guchar check_low_bg_remap[] = {
	'#', XENO_FG,XENO_CURRENT,
	'a', XENO_FG,XENO_CURRENT,
	'b', XENO_BG,XENO_CURRENT,
	'c', XENO_FG,XENO_INSENSITIVE,
	'd', XENO_BG,XENO_CURRENT,
	0
};

const static guchar check_low_bg_prelight_remap[] = {
	'#', XENO_FG,XENO_CURRENT,
	'a', XENO_FG,XENO_CURRENT,
	'b', XENO_BG,XENO_CURRENT,
	'c', XENO_FG,XENO_CURRENT,
	'd', XENO_BG,XENO_CURRENT,
	0
};

const static guchar check_low_base_remap[] = {
	'#', XENO_FG,XENO_CURRENT,
	'a', XENO_FG,XENO_CURRENT,
	'b', XENO_BASE,XENO_CURRENT,
	'c', XENO_FG,XENO_CURRENT,
	'd', XENO_BASE,XENO_CURRENT,
	0
};

const static guchar check_low_base_prelight_remap[] = {
	'#', XENO_FG,XENO_CURRENT,
	'a', XENO_FG,XENO_CURRENT,
	'b', XENO_BASE,XENO_CURRENT,
	'c', XENO_FG,XENO_CURRENT,
	'd', XENO_BASE,XENO_CURRENT,
	0
};


const static char * check7_xpm[] = {
"7 7 6 1",
"# c #000000",
"a c #0c0c0c",
"b c #888888",
"c c #353535",
"d c #aaaaaa",
"  c None",
"     aa",
"    c# ",
"   b#b ",
"   aa  ",
"aac#b  ",
"b##a   ",
" c#b   "
};

const static char * check9_xpm[] = {
"9 9 6 1",
"# c #000000",
"a c #0c0c0c",
"b c #888888",
"c c #353535",
"d c #aaaaaa",
"  c None",
"       ##",
"      a#b",
"     c#c ",
"    d#a  ",
"    ##   ",
"#a ##c   ",
"a#a##    ",
"d###c    ",
" a##     "
};

const static char * check11_xpm[] = {
"11 11 6 1",
"# c #000000",
"a c #0c0c0c",
"b c #888888",
"c c #353535",
"d c #aaaaaa",
"  c None",
"        b##",
"       b## ",
"       a#c ",
"      a#c  ",
"     b#a   ",
"     a#    ",
"    b#c    ",
"a#b a#     ",
"a##c#c     ",
" a###      ",
"  a#c      "
};

/* Radio menu item */
const static char * radio_item_xpm[] = {
"6 6 3 1",
"# c #000000",
". c #000000",
"  c None",
" .##. ",
".####.",
"######",
"######",
".####.",
" .##. ",
};

const static guchar radio_item_remap[] = {
	'#', XENO_FG,XENO_CURRENT,
	'.', XENO_BI,	127, XENO_BG,XENO_CURRENT,	XENO_FG,XENO_CURRENT,
	0
};

const static guchar radio_item_low_remap[] = {
	'#', XENO_FG,XENO_CURRENT,
	'.', XENO_FG,XENO_INSENSITIVE,
	0
};

const static guchar radio_item_low_prelight_remap[] = {
	'#', XENO_FG,XENO_CURRENT,
	'.', XENO_FG,XENO_CURRENT,
	0
};

/* Scrollbar dimple */
const static char * dimple_xpm[] = {
"6 6 11 1",
"# c #555555",
"a c #aaaaaa",
"c c #555555",
"C c #555555",
"d c #7f7f7f",
"e c #d4d4d4",
"f c #7f7f7f",
"g c #393939",
". c #000000",
"b c #ffffff",
"  c None",
" c..C ",
"c.g##d",
".g#faa",
".#fabb",
"C#abbe",
" dabe "
/*
" ebad ",
"ebba#c",
"bbaf#.",
"aaf#g.",
"d##g.c",
" c..c "
*/
};

const static guchar dimple_remap[] = {
	'#', XENO_BI, 57*2,	XENO_BLACK,XENO_CURRENT,XENO_BG,XENO_CURRENT,
	'a', XENO_BI, 114*2,XENO_BLACK,XENO_CURRENT,XENO_BG,XENO_CURRENT,
	'c', XENO_BI, 0x7f,	XENO_BG,XENO_CURRENT,	XENO_BLACK,XENO_CURRENT,
	'C', XENO_BI, 0x7f,	XENO_BG,XENO_CURRENT,	XENO_BLACK,XENO_CURRENT,
	'd', XENO_BI, 0x7f,	XENO_BG,XENO_CURRENT,	XENO_BI,0x37*2, XENO_BLACK,XENO_CURRENT,XENO_BG,XENO_CURRENT,
	'e', XENO_BI, 0x7f,	XENO_BG,XENO_CURRENT,	XENO_WHITE,XENO_CURRENT,
	'f', XENO_BI, 85*2, XENO_BLACK,XENO_CURRENT,XENO_BG,XENO_CURRENT,
	'g', XENO_BI, 38*2, XENO_BLACK,XENO_CURRENT,XENO_BG,XENO_CURRENT,
	'.', XENO_BLACK,XENO_CURRENT,
	'b', XENO_WHITE,XENO_CURRENT,
	0
};

const static guchar dimple_low_remap[] = {
	'#', XENO_DARK,XENO_CURRENT,
	'a', XENO_BG,XENO_CURRENT,
	'c', XENO_DARK,XENO_CURRENT,
	'C', XENO_BLACK,XENO_CURRENT,
	'd', XENO_DARK,XENO_CURRENT,
	'e', XENO_WHITE,XENO_CURRENT,
	'f', XENO_BG,XENO_CURRENT,
	'g', XENO_DARK,XENO_CURRENT,
	'.', XENO_BLACK,XENO_CURRENT,
	'b', XENO_WHITE,XENO_CURRENT,
	0
};

const static char * corner_xpm[] = {
"13 13 48 1",
"P c #000000",
"G c #000000",
"z c #000000",
"! c #000000",
"% c #000000",
"& c #000000",
"i c #000000",
"j c #000000",
"8 c #000000",
"9 c #000000",
"W c #000000",
"B c #000000",
"L c #000000",
"D c #000000",
"0 c #000000",
"1 c #000000",
"2 c #000000",
"3 c #000000",
"4 c #000000",
"5 c #000000",
"6 c #000000",
"7 c #000000",
"a c #000000",
"b c #000000",
"c c #000000",
"d c #000000",
"e c #000000",
"f c #000000",
"g c #000000",
"h c #000000",
"k c #000000",
"l c #000000",
"m c #000000",
"n c #000000",
"o c #000000",
"p c #000000",
"q c #000000",
"r c #000000",
"s c #000000",
"t c #000000",
"u c #000000",
"v c #000000",
"w c #000000",
"x c #000000",
"y c #000000",
"# c #000000",
"$ c #000000",
"  None",
" PP210WklmPP ",
"PP3654LstunPP",
"P37L98 z!#voP",
"26LG     G$wp",
"159       %xq",
"048       &yr",
"WL         DB",
"ksz       iea",
"lt!       jfb",
"mu#G     GDgc",
"Pnv$%& ijDhdP",
"PPowxyDefgdPP",
" PPpqrBabcPP "
};

const static guchar corner_remap[] = {
	'P', XENO_BG,XENO_PARENT|XENO_NORMAL,
	'G', XENO_BG,XENO_CURRENT,
	'z', XENO_THIN, XENO_BG,XENO_CURRENT,	XENO_TRI, 40,		230,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_TOP,1,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_BOT,1,		XENO_BG,XENO_CURRENT,
	'!', XENO_THIN, XENO_BG,XENO_CURRENT,	XENO_TRI, 75,		153,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_TOP,1,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_BOT,1,		XENO_BG,XENO_CURRENT,
	'%', XENO_THIN, XENO_BG,XENO_CURRENT,	XENO_TRI, 75,		153,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_BOT,1,		XENO_THIN,XENO_BG,XENO_CURRENT,XENO_TOP,1,	XENO_BG,XENO_CURRENT,
	'&', XENO_THIN, XENO_BG,XENO_CURRENT,	XENO_TRI, 40,		230,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_BOT,1,		XENO_THIN,XENO_BG,XENO_CURRENT,XENO_TOP,1,	XENO_BG,XENO_CURRENT,
	
	'i', XENO_THIN, XENO_BG,XENO_CURRENT,	XENO_BI, 230,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_BOT,1,		XENO_BG,XENO_CURRENT,
	'j', XENO_THIN, XENO_BG,XENO_CURRENT,	XENO_BI, 153,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_BOT,1,		XENO_BG,XENO_CURRENT,
	'8', XENO_THIN, XENO_BG,XENO_CURRENT,	XENO_BI, 230,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_TOP,1,	XENO_BG,XENO_CURRENT,
	'9', XENO_THIN, XENO_BG,XENO_CURRENT,	XENO_BI, 153,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_TOP,1,	XENO_BG,XENO_CURRENT,
	
	'W', XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'B', XENO_THIN, XENO_BOT,1, XENO_BOT,0,
	'L', XENO_THIN, XENO_BG,XENO_CURRENT,	XENO_TOP,1,
	'D', XENO_THIN, XENO_BG,XENO_CURRENT,	XENO_BOT,1,
	 
	'0', XENO_BI, 234,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'1', XENO_BI, 170,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'2', XENO_BI, 51,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'3', XENO_BI, 127,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'4', XENO_BI, 21,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_TOP,1,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'5', XENO_BI, 85,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_TOP,1,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'6', XENO_BI, 204,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_TOP,1,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	'7', XENO_BI, 128,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_TOP,1,	XENO_THIN, XENO_TOP,1, XENO_TOP,0,
	
	'a', XENO_BI, 234,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'b', XENO_BI, 170,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'c', XENO_BI, 51,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'd', XENO_BI, 127,	XENO_BG,XENO_PARENT|XENO_NORMAL,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'e', XENO_BI, 21,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_BOT,1,		XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'f', XENO_BI, 85,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_BOT,1,		XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'g', XENO_BI, 204,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_BOT,1,		XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'h', XENO_BI, 128,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_BOT,1,		XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	
	'k', XENO_TRI, 27,		21,		XENO_THIN,XENO_TOP,1,XENO_TOP,0,XENO_THIN,XENO_BOT,1,XENO_BOT,0,	XENO_BG,XENO_PARENT|XENO_NORMAL,
	'l', XENO_TRI, 52,		85,		XENO_THIN,XENO_TOP,1,XENO_TOP,0,XENO_THIN,XENO_BOT,1,XENO_BOT,0,	XENO_BG,XENO_PARENT|XENO_NORMAL,
	'm', XENO_TRI, 75,		204,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,XENO_THIN,XENO_BOT,1,XENO_BOT,0,	XENO_BG,XENO_PARENT|XENO_NORMAL,
	'n', XENO_TRI, 110,		127,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,XENO_THIN,XENO_BOT,1,XENO_BOT,0,	XENO_BG,XENO_PARENT|XENO_NORMAL,
	'o', XENO_TRI, 110,		127,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,XENO_THIN,XENO_TOP,1,XENO_TOP,0,	XENO_BG,XENO_PARENT|XENO_NORMAL,
	'p', XENO_TRI, 75,		204,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,XENO_THIN,XENO_TOP,1,XENO_TOP,0,	XENO_BG,XENO_PARENT|XENO_NORMAL,
	'q', XENO_TRI, 52,		85,		XENO_THIN,XENO_BOT,1,XENO_BOT,0,XENO_THIN,XENO_TOP,1,XENO_TOP,0,	XENO_BG,XENO_PARENT|XENO_NORMAL,
	'r', XENO_TRI, 27,		21,		XENO_THIN,XENO_BOT,1,XENO_BOT,0,XENO_THIN,XENO_TOP,1,XENO_TOP,0,	XENO_BG,XENO_PARENT|XENO_NORMAL,
	
	's', XENO_QUAD, 21,		32,		XENO_THIN,XENO_BG,XENO_CURRENT,XENO_TOP,1,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,		XENO_THIN,XENO_BG,XENO_CURRENT,XENO_BOT,1,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	't', XENO_QUAD, 85,		62,		XENO_THIN,XENO_BG,XENO_CURRENT,XENO_TOP,1,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,		XENO_THIN,XENO_BG,XENO_CURRENT,XENO_BOT,1,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'u', XENO_QUAD, 204,	88,		XENO_THIN,XENO_BG,XENO_CURRENT,XENO_TOP,1,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,		XENO_THIN,XENO_BG,XENO_CURRENT,XENO_BOT,1,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'v', XENO_QUAD, 128,	127,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_TOP,1,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,		XENO_THIN,XENO_BG,XENO_CURRENT,XENO_BOT,1,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,
	'w', XENO_QUAD, 204,	88,		XENO_THIN,XENO_BG,XENO_CURRENT,XENO_BOT,1,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,		XENO_THIN,XENO_BG,XENO_CURRENT,XENO_TOP,1,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,
	'x', XENO_QUAD, 85,		62,		XENO_THIN,XENO_BG,XENO_CURRENT,XENO_BOT,1,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,		XENO_THIN,XENO_BG,XENO_CURRENT,XENO_TOP,1,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,
	'y', XENO_QUAD, 21,		32,		XENO_THIN,XENO_BG,XENO_CURRENT,XENO_BOT,1,	XENO_THIN,XENO_BOT,1,XENO_BOT,0,		XENO_THIN,XENO_BG,XENO_CURRENT,XENO_TOP,1,	XENO_THIN,XENO_TOP,1,XENO_TOP,0,
	
	'#', XENO_BI, 116,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_TOP,1,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_BOT,1,
	'$', XENO_BI, 116,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_BOT,1,	XENO_THIN,XENO_BG,XENO_CURRENT,XENO_TOP,1,
	0
};

/*
const static XenoImageVariant radio_normal_variants[XENO_RADIO_LAST] = {
	radio_normal_xpm, radio_normal_remap, XENO_MASK_RADIO,
	radio_normal_xpm, radio_normal_remap, XENO_MASK_RADIO,
	radio_normal_xpm, radio_normal_remap, XENO_MASK_RADIO
};

const static XenoImageVariant radio_selected_variants[XENO_RADIO_LAST] = {
	radio_selected_xpm, radio_selected_remap, XENO_MASK_RADIO,
	radio_selected_xpm, radio_selected_remap, XENO_MASK_RADIO,
	radio_selected_xpm, radio_selected_remap, XENO_MASK_RADIO
};

const static XenoImageVariant radio_insensitive_variants[XENO_RADIO_LAST] = {
	radio_normal_xpm, radio_insensitive_remap, XENO_MASK_RADIO,
	radio_normal_xpm, radio_insensitive_remap, XENO_MASK_RADIO,
	radio_normal_xpm, radio_normal_remap, XENO_MASK_RADIO
};

const static XenoImageVariant check_bg_variants[XENO_CHECK_LAST] = {
	check7_xpm, check_bg_remap, XENO_MASK_CHECK_7,
	check9_xpm, check_bg_remap, XENO_MASK_CHECK_9,
	check11_xpm, check_bg_remap, XENO_MASK_CHECK_11,
	check_perkele_xpm, check_perkele_remap, XENO_MASK_CHECK_PERKELE
};

const static XenoImageVariant check_base_variants[XENO_CHECK_LAST] = {
	check7_xpm, check_base_remap, XENO_MASK_CHECK7,
	check9_xpm, check_base_remap, XENO_MASK_CHECK9,
	check11_xpm, check_base_remap, XENO_MASK_CHECK11,
	check_perkele_xpm, check_perkele_remap, XENO_MASK_CHECK_PERKELE
};

const static XenoImageVariant dimple_variant[] = {
	dimple_xpm, dimple_remap, XENO_MASK_DIMPLE,
	dimple_xpm, dimple_remap, XENO_MASK_DIMPLE
};

const static XenoImageVariant radio_item_variant[] = {
	radio_item_xpm, radio_item_remap, XENO_MASK_RADIO_ITEM
};
const static XenoImageVariant corner_variant[] = {
	corner_xpm, corner_remap, XENO_MASK_CORNER
};

XenoImage xeno_images[] = {
	radio_normal_variants,		GTK_SHADOW_OUT,		GTK_STATE_NORMAL,
	radio_normal_variants,		GTK_SHADOW_OUT,		GTK_STATE_PRELIGHT,
	radio_insensitive_variants,	GTK_SHADOW_OUT,		GTK_STATE_INSENSITIVE,
	radio_selected_variants,	GTK_SHADOW_IN,		GTK_STATE_NORMAL,
	radio_selected_variants,	GTK_SHADOW_IN,		GTK_STATE_PRELIGHT,
	radio_normal_xpm,			GTK_SHADOW_IN, 		GTK_STATE_INSENSITIVE,
	radio_normal_xpm,			GTK_SHADOW_IN,		GTK_STATE_ACTIVE,
	
	radio_item_variant,			GTK_SHADOW_NONE,	GTK_STATE_NORMAL,
	radio_item_variant,			GTK_SHADOW_NONE,	GTK_STATE_PRELIGHT,
	radio_item_variant,			GTK_SHADOW_NONE,	GTK_STATE_INSENSITIVE,
	
	corner_variant,				GTK_SHADOW_OUT,		GTK_STATE_NORMAL,
	corner_variant,				GTK_SHADOW_OUT,		GTK_STATE_ACTIVE,
	corner_variant,				GTK_SHADOW_OUT,		GTK_STATE_INSENSITIVE,
	
	dimple_variants,			GTK_SHADOW_OUT,		GTK_STATE_NORMAL,
	dimple_variants,			GTK_SHADOW_OUT,		GTK_STATE_PRELIGHT,
	dimple_variants,			GTK_SHADOW_OUT,		GTK_STATE_INSENSITIVE,
	
	check_base_variants,		GTK_SHADOW_IN,		GTK_STATE_NORMAL,
	check_base_variants,		GTK_SHADOW_IN,		GTK_STATE_PRELIGHT,
	check_base_variants,		GTK_SHADOW_IN,		GTK_STATE_INSENSITIVE,
	check_bg_variants,			GTK_SHADOW_IN,		GTK_STATE_ACTIVE,
	check_bg_variants,			GTK_SHADOW_OUT,		GTK_STATE_NORMAL,
	check_bg_variants,			GTK_SHADOW_OUT,		GTK_STATE_PRELIGHT,
	check_bg_variants,			GTK_SHADOW_OUT,		GTK_STATE_INSENSITIVE,
};
*/

const XenoImage xeno_images[] = {
	radio_normal_xpm, XENO_MASK_RADIO,	radio_normal_remap,		GTK_SHADOW_OUT,		GTK_STATE_NORMAL,
	radio_normal_xpm, XENO_MASK_RADIO,	radio_normal_remap,		GTK_SHADOW_OUT,		GTK_STATE_PRELIGHT,
	radio_normal_xpm, XENO_MASK_RADIO,	radio_normal_remap,		GTK_SHADOW_OUT,		GTK_STATE_INSENSITIVE,
	radio_selected_xpm, XENO_MASK_RADIO, radio_selected_remap,	GTK_SHADOW_IN,		GTK_STATE_NORMAL,
	radio_selected_xpm, XENO_MASK_RADIO, radio_selected_remap,	GTK_SHADOW_IN,		GTK_STATE_PRELIGHT,
	radio_normal_xpm, XENO_MASK_RADIO,	radio_down_insensitive_remap, GTK_SHADOW_IN, GTK_STATE_INSENSITIVE,
	radio_normal_xpm, XENO_MASK_RADIO,	radio_normal_remap,		GTK_SHADOW_IN,		GTK_STATE_ACTIVE,
	
	radio_item_xpm,	XENO_MASK_RADIO_ITEM, radio_item_remap,		GTK_SHADOW_NONE,	GTK_STATE_NORMAL,
	radio_item_xpm,	XENO_MASK_RADIO_ITEM, radio_item_remap,		GTK_SHADOW_NONE,	GTK_STATE_PRELIGHT,
	radio_item_xpm,	XENO_MASK_RADIO_ITEM, radio_item_remap,		GTK_SHADOW_NONE,	GTK_STATE_INSENSITIVE,
	
	corner_xpm,		XENO_MASK_CORNER,	corner_remap,			GTK_SHADOW_OUT,		GTK_STATE_NORMAL,
	corner_xpm,		XENO_MASK_CORNER,	corner_remap,			GTK_SHADOW_OUT,		GTK_STATE_ACTIVE,
	corner_xpm,		XENO_MASK_CORNER,	corner_remap,			GTK_SHADOW_OUT,		GTK_STATE_INSENSITIVE,
	
	dimple_xpm,		XENO_MASK_DIMPLE,	dimple_remap,			GTK_SHADOW_OUT,		GTK_STATE_NORMAL,
	dimple_xpm,		XENO_MASK_DIMPLE,	dimple_remap,			GTK_SHADOW_OUT,		GTK_STATE_PRELIGHT,
	dimple_xpm,		XENO_MASK_DIMPLE,	dimple_remap,			GTK_SHADOW_OUT,		GTK_STATE_INSENSITIVE,
	
	check7_xpm,		XENO_MASK_CHECK_7,	check_base_remap,		GTK_SHADOW_IN,		GTK_STATE_NORMAL,
	check7_xpm,		XENO_MASK_CHECK_7,	check_base_remap,		GTK_SHADOW_IN,		GTK_STATE_PRELIGHT,
	check7_xpm,		XENO_MASK_CHECK_7,	check_base_remap,		GTK_SHADOW_IN,		GTK_STATE_INSENSITIVE,
	check7_xpm,		XENO_MASK_CHECK_7,	check_bg_remap,			GTK_SHADOW_OUT,		GTK_STATE_ACTIVE,
	check9_xpm,		XENO_MASK_CHECK_9,	check_base_remap,		GTK_SHADOW_IN,		GTK_STATE_NORMAL,
	check9_xpm,		XENO_MASK_CHECK_9,	check_base_remap,		GTK_SHADOW_IN,		GTK_STATE_PRELIGHT,
	check9_xpm,		XENO_MASK_CHECK_9,	check_base_remap,		GTK_SHADOW_IN,		GTK_STATE_INSENSITIVE,
	check9_xpm,		XENO_MASK_CHECK_9,	check_bg_remap,			GTK_SHADOW_OUT,		GTK_STATE_ACTIVE,
	check11_xpm,	XENO_MASK_CHECK_11,	check_base_remap,		GTK_SHADOW_IN,		GTK_STATE_NORMAL,
	check11_xpm,	XENO_MASK_CHECK_11,	check_base_remap,		GTK_SHADOW_IN,		GTK_STATE_PRELIGHT,
	check11_xpm,	XENO_MASK_CHECK_11,	check_base_remap,		GTK_SHADOW_IN,		GTK_STATE_INSENSITIVE,
	check11_xpm,	XENO_MASK_CHECK_11,	check_bg_remap,			GTK_SHADOW_OUT,		GTK_STATE_ACTIVE,
	
	check7_xpm,		XENO_MASK_CHECK_7,	check_bg_remap,			GTK_SHADOW_IN,		GTK_STATE_NORMAL,
	check7_xpm,		XENO_MASK_CHECK_7,	check_bg_remap,			GTK_SHADOW_IN,		GTK_STATE_PRELIGHT,
	check7_xpm,		XENO_MASK_CHECK_7,	check_bg_remap,			GTK_SHADOW_IN,		GTK_STATE_INSENSITIVE,
	check9_xpm,		XENO_MASK_CHECK_9,	check_bg_remap,			GTK_SHADOW_IN,		GTK_STATE_NORMAL,
	check9_xpm,		XENO_MASK_CHECK_9,	check_bg_remap,			GTK_SHADOW_IN,		GTK_STATE_PRELIGHT,
	check9_xpm,		XENO_MASK_CHECK_9,	check_bg_remap,			GTK_SHADOW_IN,		GTK_STATE_INSENSITIVE,
	check11_xpm,	XENO_MASK_CHECK_11,	check_bg_remap,			GTK_SHADOW_IN,		GTK_STATE_NORMAL,
	check11_xpm,	XENO_MASK_CHECK_11,	check_bg_remap,			GTK_SHADOW_IN,		GTK_STATE_PRELIGHT,
	check11_xpm,	XENO_MASK_CHECK_11,	check_bg_remap,			GTK_SHADOW_IN,		GTK_STATE_INSENSITIVE
};

/* Different images for pseudocolor displays, optimized for low colormap usage. */
const XenoImage xeno_low_images[] = {
	radio_low_xpm,	XENO_MASK_RADIO,	radio_low_normal_remap,			GTK_SHADOW_OUT,		GTK_STATE_NORMAL,
	radio_low_xpm,	XENO_MASK_RADIO,	radio_low_normal_remap,			GTK_SHADOW_OUT,		GTK_STATE_PRELIGHT,
	radio_low_xpm,	XENO_MASK_RADIO,	radio_low_normal_remap,			GTK_SHADOW_OUT,		GTK_STATE_INSENSITIVE,
	radio_low_xpm,	XENO_MASK_RADIO,	radio_low_selected_remap,		GTK_SHADOW_IN,		GTK_STATE_NORMAL,
	radio_low_xpm,	XENO_MASK_RADIO,	radio_low_selected_remap,		GTK_SHADOW_IN,		GTK_STATE_PRELIGHT,
	radio_low_xpm,	XENO_MASK_RADIO,	radio_low_down_remap,			GTK_SHADOW_IN,		GTK_STATE_INSENSITIVE,
	radio_low_xpm,	XENO_MASK_RADIO,	radio_low_down_remap,			GTK_SHADOW_IN,		GTK_STATE_ACTIVE,
																						
	radio_item_xpm,	XENO_MASK_RADIO_ITEM, radio_item_low_remap,			GTK_SHADOW_NONE,	GTK_STATE_NORMAL,
	radio_item_xpm,	XENO_MASK_RADIO_ITEM, radio_item_low_prelight_remap,GTK_SHADOW_NONE,	GTK_STATE_PRELIGHT,
	radio_item_xpm,	XENO_MASK_RADIO_ITEM, radio_item_low_remap,			GTK_SHADOW_NONE,	GTK_STATE_INSENSITIVE,
																						
	corner_xpm,		XENO_MASK_CORNER,	corner_remap,					GTK_SHADOW_OUT,		GTK_STATE_NORMAL,
	corner_xpm,		XENO_MASK_CORNER,	corner_remap,					GTK_SHADOW_OUT,		GTK_STATE_ACTIVE,
	corner_xpm,		XENO_MASK_CORNER,	corner_remap,					GTK_SHADOW_OUT,		GTK_STATE_INSENSITIVE,
																						
	dimple_xpm,		XENO_MASK_DIMPLE,	dimple_low_remap,				GTK_SHADOW_OUT,		GTK_STATE_NORMAL,
	dimple_xpm,		XENO_MASK_DIMPLE,	dimple_low_remap,				GTK_SHADOW_OUT,		GTK_STATE_PRELIGHT,
	dimple_xpm,		XENO_MASK_DIMPLE,	dimple_low_remap,				GTK_SHADOW_OUT,		GTK_STATE_INSENSITIVE,
																						
	check7_xpm,		XENO_MASK_CHECK_7,	check_low_base_remap,			GTK_SHADOW_IN,		GTK_STATE_NORMAL,
	check7_xpm,		XENO_MASK_CHECK_7,	check_low_base_prelight_remap,	GTK_SHADOW_IN,		GTK_STATE_PRELIGHT,
	check7_xpm,		XENO_MASK_CHECK_7,	check_low_base_remap,			GTK_SHADOW_IN,		GTK_STATE_INSENSITIVE,
	check7_xpm,		XENO_MASK_CHECK_7,	check_low_bg_remap,				GTK_SHADOW_OUT,		GTK_STATE_ACTIVE,
	check9_xpm,		XENO_MASK_CHECK_9,	check_low_base_remap,			GTK_SHADOW_IN,		GTK_STATE_NORMAL,
	check9_xpm,		XENO_MASK_CHECK_9,	check_low_base_prelight_remap,	GTK_SHADOW_IN,		GTK_STATE_PRELIGHT,
	check9_xpm,		XENO_MASK_CHECK_9,	check_low_base_remap,			GTK_SHADOW_IN,		GTK_STATE_INSENSITIVE,
	check9_xpm,		XENO_MASK_CHECK_9,	check_low_bg_remap,				GTK_SHADOW_OUT,		GTK_STATE_ACTIVE,
	check11_xpm,	XENO_MASK_CHECK_11,	check_low_base_remap,			GTK_SHADOW_IN,		GTK_STATE_NORMAL,
	check11_xpm,	XENO_MASK_CHECK_11,	check_low_base_prelight_remap,	GTK_SHADOW_IN,		GTK_STATE_PRELIGHT,
	check11_xpm,	XENO_MASK_CHECK_11,	check_low_base_remap,			GTK_SHADOW_IN,		GTK_STATE_INSENSITIVE,
	check11_xpm,	XENO_MASK_CHECK_11,	check_low_bg_remap,				GTK_SHADOW_OUT,		GTK_STATE_ACTIVE,
																					    
	check7_xpm,		XENO_MASK_CHECK_7,	check_low_bg_remap,				GTK_SHADOW_IN,		GTK_STATE_NORMAL,
	check7_xpm,		XENO_MASK_CHECK_7,	check_low_bg_prelight_remap,	GTK_SHADOW_IN,		GTK_STATE_PRELIGHT,
	check7_xpm,		XENO_MASK_CHECK_7,	check_low_bg_remap,				GTK_SHADOW_IN,		GTK_STATE_INSENSITIVE,
	check9_xpm,		XENO_MASK_CHECK_9,	check_low_bg_remap,				GTK_SHADOW_IN,		GTK_STATE_NORMAL,
	check9_xpm,		XENO_MASK_CHECK_9,	check_low_bg_prelight_remap,	GTK_SHADOW_IN,		GTK_STATE_PRELIGHT,
	check9_xpm,		XENO_MASK_CHECK_9,	check_low_bg_remap,				GTK_SHADOW_IN,		GTK_STATE_INSENSITIVE,
	check11_xpm,	XENO_MASK_CHECK_11,	check_low_bg_remap,				GTK_SHADOW_IN,		GTK_STATE_NORMAL,
	check11_xpm,	XENO_MASK_CHECK_11,	check_low_bg_prelight_remap,	GTK_SHADOW_IN,		GTK_STATE_PRELIGHT,
	check11_xpm,	XENO_MASK_CHECK_11,	check_low_bg_remap,				GTK_SHADOW_IN,		GTK_STATE_INSENSITIVE
};


/*
	Shadows
*/
#define D			XENO_DARK,XENO_CURRENT
#define L			XENO_LIGHT,XENO_CURRENT
#define M			XENO_MID,XENO_CURRENT
#define W			XENO_WHITE,XENO_CURRENT
#define B			XENO_BLACK,XENO_CURRENT
#define	G			XENO_BG,XENO_CURRENT

#define DN			XENO_DARK,XENO_NORMAL
#define LN			XENO_LIGHT,XENO_NORMAL
#define MN			XENO_MID,XENO_NORMAL
#define WN			XENO_WHITE,XENO_NORMAL
#define BN			XENO_BLACK,XENO_NORMAL
#define	GN			XENO_BG,XENO_NORMAL

#define PD			XENO_DARK,XENO_PARENT|XENO_CURRENT
#define PL			XENO_LIGHT,XENO_PARENT|XENO_CURRENT
#define PM			XENO_MID,XENO_PARENT|XENO_CURRENT
#define PW			XENO_WHITE,XENO_PARENT|XENO_CURRENT
#define PB			XENO_BLACK,XENO_PARENT|XENO_CURRENT
#define PG			XENO_BG,XENO_PARENT|XENO_CURRENT

#define PDN			XENO_DARK,XENO_PARENT|XENO_NORMAL
#define PLN			XENO_LIGHT,XENO_PARENT|XENO_NORMAL
#define PMN			XENO_MID,XENO_PARENT|XENO_NORMAL
#define PWN			XENO_WHITE,XENO_PARENT|XENO_NORMAL
#define PBN			XENO_BLACK,XENO_PARENT|XENO_NORMAL
#define PGN			XENO_BG,XENO_PARENT|XENO_NORMAL

#define RB			XENO_PURE_BLACK,XENO_CURRENT
#define RW			XENO_PURE_WHITE,XENO_CURRENT

#define NONE		XENO_BG,XENO_CURRENT
#define EMPTY1		{ { NONE, NONE, NONE } }
#define EMPTY2		{ { NONE, NONE, NONE }, { NONE, NONE, NONE } }
#define EMPTY3		{ { NONE, NONE, NONE }, { NONE, NONE, NONE }, { NONE, NONE, NONE } }

const XenoShadowStyle xeno_shadows[XENO_SHADOW_LAST] = {
	/* XENO_SHADOW_ETCHED_(IN|OUT) */
	{
		{ { B,	B,	B  } },
		{ { PD, PL, PM }, { L,	D,	M } },
		{ { PD, PL, PM }, {	B,	B,	B }, {	L,	D,	M } },
		2
	}, {
		{ { B,	B,	B  } },
		{ { PL, PD, PM }, { D,	L,	M } },
		{ { PL, PD, PM }, { G,	G,	G }, {	D,	L,	M } },
		2
	},
	
	/* XENO_SHADOW_XENO_(IN|OUT) */
	{
		{ {	PDN,PLN,PMN } },
		{ { PDN,PLN,PMN }, { PBN, PWN, PDN } },
		{ { PDN,PLN,PMN }, { PBN, PWN, PDN }, { RB,	RW,	PD } },
		2
	}, {
		{ {	L,	D,	M, } },
		{ {	W,	B,	M, }, {	L,	D,	M } },
		{ { RW, RB, M, }, { W,	B,	M }, {	L,	D,	M } },
		2
	},
	
	/* XENO_SHADOW_THIN_(IN|OUT) */
 	{
		{ { D, L, M } },
		{ { D, L, M }, { G, G, G } },
		{ { D, L, M }, { G, G, G }, { G, G, G } },
		1
	}, {
		{ { L, D, M } },
		{ { L, D, M }, { G, G, G } },
		{ { L, D, M }, { G, G, G }, { G, G, G } },
		1
	},
	
	/* XENO_SHADOW_NEXT_(IN|OUT) */
	{
		{ { PB, PW, PG } },
		{ { PD, PW, PD }, { PB, PG, PB } },
		{ { PD, PW, PD }, { PB, PG, PB }, { PG, PG, PG } },
		2
	}, {
		{ { W, B, B  } },
		{ { W, B, D  }, { G, D, D } },
		{ { W, D, PG }, { W, B, B }, { G, D, D } },
		2
	},
	
	/* XENO_SHADOW_BUTTON_IN, XENO_SHADOW_NOTE */
	{
		{ { B, D, B } },
		{ { B, D, B }, { D, G, D } },
		{ { B, D, B }, { D, G, D }, { G, G, G } },
		2
	}, {
		{ { D, B, D } },
		{ { D, B, D }, { G, G, G } },
		{ { B, B, B }, { G, B, B }, { G, G, G } },
		1
	},
	
	/* XENO_SHADOW_BLACK_(IN|OUT) */
	{
		{ { RB, RB, RB } },
		{ { PD, PL, PM }, { RB, RB, RB } },
		{ { PD, PL, PM }, { RB, RB, RB }, { XENO_DARK,XENO_ACTIVE, XENO_LIGHT,XENO_ACTIVE, XENO_MID,XENO_ACTIVE } },
		3
	}, {
		{ { B, RB, B } },
		{ { B, RB, B }, { L, D, M } },
		{ { B, RB, B }, { W, D, M }, { L, M, G } },
		3
	}
};


/* end */

