/*
 *	xeno_theme_style.h
 */

#ifndef XENO_THEME_STYLE_H
#define XENO_THEME_STYLE_H

#include "xeno_theme_enums.h"
#include "xeno_theme_color.h"

/*
 *	XenoGradientSet
 */
typedef struct _XenoGradient	XenoGradient;

typedef struct {
	XenoGradient	*gradients;
	guint8			redirect[5];
} XenoGradientSet;

#define xeno_gradient_set_init(g)	\
	{ (g)->gradients   = NULL;	\
	  (g)->redirect[0] = 0;		\
	  (g)->redirect[1] = 1;		\
	  (g)->redirect[2] = 2;		\
	  (g)->redirect[3] = 3;		\
	  (g)->redirect[4] = 4;		\
	}

void	xeno_gradient_rgb (const GtkStyle *style, GtkStateType state_type, gfloat f, XenoColor *dst);
void	xeno_gradient_set_realize	(XenoGradientSet *gradient_set, GtkStyle *style);
void	xeno_gradient_set_unrealize	(XenoGradientSet *gradient_set);


/*
 *	XenoStyle / XenoStyleData
 */

#if XENO_GTK2
#define XENO_TYPE_STYLE					(xeno_style_get_type ())
#define XENO_STYLE(object)				(G_TYPE_CHECK_INSTANCE_CAST ((object), XENO_TYPE_STYLE, XenoStyle))
#define XENO_STYLE_CLASS(klass)			(G_TYPE_CHECK_CLASS_CAST ((klass), XENO_TYPE_STYLE, XenoStyleClass))
#define XENO_IS_STYLE(object)			(G_TYPE_CHECK_INSTANCE_TYPE ((object), XENO_TYPE_STYLE))
#define XENO_IS_STYLE_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), XENO_TYPE_STYLE))
#define XENO_STYLE_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS ((obj), XENO_TYPE_STYLE, XenoStyleClass))

#define XENO_STYLE_DATA(style)			XENO_STYLE(style)
#define XENO_STYLE_IS_XENO(style)		XENO_IS_STYLE(style)
#define XENO_STYLE_HAS_DATA(style)		XENO_IS_STYLE(style)

#define XENO_STYLE_XTHICKNESS(style)	GTK_STYLE(style)->xthickness
#define XENO_STYLE_YTHICKNESS(style)	GTK_STYLE(style)->ythickness

typedef struct _XenoStyleData	XenoStyle;
#else
#define XENO_STYLE_DATA(style)			((XenoStyleData *)((style)->engine_data))
#define XENO_STYLE_IS_XENO(style)		(((XenoStyleClass *)(style)->klass)->magic == XENO_STYLE_MAGIC)
#define XENO_STYLE_HAS_DATA(style)		(XENO_STYLE_IS_XENO(style) && XENO_STYLE_DATA(style))

#define XENO_STYLE_XTHICKNESS(style)	((style)->klass->xthickness)
#define XENO_STYLE_YTHICKNESS(style)	((style)->klass->ythickness)

#define XENO_STYLE_MAGIC				0x7a15D011
#endif

typedef struct _XenoStyleData	XenoStyleData;

struct _XenoStyleData {
  #if !XENO_GTK2
	gint16			ref_count;
  #endif
	
	XenoColor		white[5];
	XenoColor		black[5];
	
	GdkGC			*white_gc[5];
	GdkGC			*black_gc[5];
	GdkGC			*fgmid_gc[5];
	
	GdkPixmap		*pixmaps[XENO_IMAGE_LAST];
	
	XenoGradientSet	gradient_set;
};

typedef struct {
	GtkStyleClass	parent;
	
  #if XENO_GTK2
	/* FIXME: background, gradients etc. */
  #else
	guint32			magic; /* XENO_STYLE_MAGIC */
  #endif
} XenoStyleClass;

#if XENO_GTK2
GType			xeno_style_get_type		(void) G_GNUC_CONST;
#define			xeno_style_new()		g_object_new(xeno_style_get_type(), NULL)
#else
XenoStyleData *	xeno_style_data_new		(void);
void			xeno_style_data_destroy	(XenoStyleData *style_data);

#define xeno_style_data_clone(data)		xeno_style_data_new()
#define xeno_style_data_ref(data)		(data->ref_count += 1)
#define	xeno_style_data_unref(style_data)					\
	if (--((XenoStyleData *)style_data)->ref_count <= 0) {		\
		xeno_style_data_destroy((XenoStyleData *)style_data);	\
	}

extern XenoStyleClass xeno_style_classes[4];
#endif

void	xeno_style_realize		(GtkStyle	*style);
void	xeno_style_unrealize	(GtkStyle	*style);

#if !XENO_GTK2
extern GMemChunk *	xeno_style_data_chunk;
#endif

#endif /* XENO_THEME_STYLE_H */

