/* playlist.c generated by valac 0.14.0, the Vala compiler
 * generated from playlist.vala, do not modify */

/*
 *  Copyright (c) 2009-2010 Mike Massonnet <mmassonnet@xfce.org>
 *  Copyright (c) 2009-2010 Vincent Legout <vincent@xfce.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <mpdclient.h>
#include <stdlib.h>
#include <string.h>
#include <libxfce4ui/libxfce4ui.h>
#include <gdk/gdk.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>


#define XFMPC_TYPE_PLAYLIST (xfmpc_playlist_get_type ())
#define XFMPC_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_PLAYLIST, XfmpcPlaylist))
#define XFMPC_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_PLAYLIST, XfmpcPlaylistClass))
#define XFMPC_IS_PLAYLIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_PLAYLIST))
#define XFMPC_IS_PLAYLIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_PLAYLIST))
#define XFMPC_PLAYLIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_PLAYLIST, XfmpcPlaylistClass))

typedef struct _XfmpcPlaylist XfmpcPlaylist;
typedef struct _XfmpcPlaylistClass XfmpcPlaylistClass;
typedef struct _XfmpcPlaylistPrivate XfmpcPlaylistPrivate;

#define XFMPC_TYPE_PREFERENCES (xfmpc_preferences_get_type ())
#define XFMPC_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_PREFERENCES, XfmpcPreferences))
#define XFMPC_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesClass))
#define XFMPC_IS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_PREFERENCES))
#define XFMPC_IS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_PREFERENCES))
#define XFMPC_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_PREFERENCES, XfmpcPreferencesClass))

typedef struct _XfmpcPreferences XfmpcPreferences;
typedef struct _XfmpcPreferencesClass XfmpcPreferencesClass;

#define XFMPC_PLAYLIST_TYPE_COLUMNS (xfmpc_playlist_columns_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define XFMPC_TYPE_DBBROWSER (xfmpc_dbbrowser_get_type ())
#define XFMPC_DBBROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_DBBROWSER, XfmpcDbbrowser))
#define XFMPC_DBBROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_DBBROWSER, XfmpcDbbrowserClass))
#define XFMPC_IS_DBBROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_DBBROWSER))
#define XFMPC_IS_DBBROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_DBBROWSER))
#define XFMPC_DBBROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_DBBROWSER, XfmpcDbbrowserClass))

typedef struct _XfmpcDbbrowser XfmpcDbbrowser;
typedef struct _XfmpcDbbrowserClass XfmpcDbbrowserClass;

#define XFMPC_TYPE_EXTENDED_INTERFACE (xfmpc_extended_interface_get_type ())
#define XFMPC_EXTENDED_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_EXTENDED_INTERFACE, XfmpcExtendedInterface))
#define XFMPC_EXTENDED_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_EXTENDED_INTERFACE, XfmpcExtendedInterfaceClass))
#define XFMPC_IS_EXTENDED_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_EXTENDED_INTERFACE))
#define XFMPC_IS_EXTENDED_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_EXTENDED_INTERFACE))
#define XFMPC_EXTENDED_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_EXTENDED_INTERFACE, XfmpcExtendedInterfaceClass))

typedef struct _XfmpcExtendedInterface XfmpcExtendedInterface;
typedef struct _XfmpcExtendedInterfaceClass XfmpcExtendedInterfaceClass;
#define __g_list_free__gtk_tree_path_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__gtk_tree_path_free0_ (var), NULL)))

#define XFMPC_EXTENDED_INTERFACE_TYPE_EXTENDED_INTERFACE_WIDGET (xfmpc_extended_interface_extended_interface_widget_get_type ())
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))

#define XFMPC_TYPE_SONG_DIALOG (xfmpc_song_dialog_get_type ())
#define XFMPC_SONG_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), XFMPC_TYPE_SONG_DIALOG, XfmpcSongDialog))
#define XFMPC_SONG_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), XFMPC_TYPE_SONG_DIALOG, XfmpcSongDialogClass))
#define XFMPC_IS_SONG_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), XFMPC_TYPE_SONG_DIALOG))
#define XFMPC_IS_SONG_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), XFMPC_TYPE_SONG_DIALOG))
#define XFMPC_SONG_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), XFMPC_TYPE_SONG_DIALOG, XfmpcSongDialogClass))

typedef struct _XfmpcSongDialog XfmpcSongDialog;
typedef struct _XfmpcSongDialogClass XfmpcSongDialogClass;

struct _XfmpcPlaylist {
	GtkVBox parent_instance;
	XfmpcPlaylistPrivate * priv;
};

struct _XfmpcPlaylistClass {
	GtkVBoxClass parent_class;
};

struct _XfmpcPlaylistPrivate {
	XfmpcMpdclient* mpdclient;
	XfmpcPreferences* preferences;
	GtkListStore* store;
	GtkTreeModelFilter* filter;
	GtkTreeView* treeview;
	GtkMenu* menu;
	GtkImageMenuItem* mi_browse;
	GtkImageMenuItem* mi_information;
	gint current;
	gboolean autocenter;
};

typedef enum  {
	XFMPC_PLAYLIST_COLUMNS_COLUMN_ID,
	XFMPC_PLAYLIST_COLUMNS_COLUMN_FILENAME,
	XFMPC_PLAYLIST_COLUMNS_COLUMN_POSITION,
	XFMPC_PLAYLIST_COLUMNS_COLUMN_SONG,
	XFMPC_PLAYLIST_COLUMNS_COLUMN_LENGTH,
	XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT,
	XFMPC_PLAYLIST_COLUMNS_N_COLUMNS
} XfmpcPlaylistColumns;

typedef enum  {
	XFMPC_EXTENDED_INTERFACE_EXTENDED_INTERFACE_WIDGET_PLAYLIST,
	XFMPC_EXTENDED_INTERFACE_EXTENDED_INTERFACE_WIDGET_DBBROWSER
} XfmpcExtendedInterfaceExtendedInterfaceWidget;


static gpointer xfmpc_playlist_parent_class = NULL;
static GtkEntry* xfmpc_playlist_filter_entry;
static GtkEntry* xfmpc_playlist_filter_entry = NULL;

GType xfmpc_playlist_get_type (void) G_GNUC_CONST;
GType xfmpc_preferences_get_type (void) G_GNUC_CONST;
#define XFMPC_PLAYLIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), XFMPC_TYPE_PLAYLIST, XfmpcPlaylistPrivate))
enum  {
	XFMPC_PLAYLIST_DUMMY_PROPERTY
};
static GType xfmpc_playlist_columns_get_type (void) G_GNUC_UNUSED;
static gboolean xfmpc_playlist_visible_func_filter_tree (GtkTreeModel* model, GtkTreeIter* iter);
static void xfmpc_playlist_cb_browse_selection (XfmpcPlaylist* self);
GType xfmpc_dbbrowser_get_type (void) G_GNUC_CONST;
GType xfmpc_extended_interface_get_type (void) G_GNUC_CONST;
static void _gtk_tree_path_free0_ (gpointer var);
static void _g_list_free__gtk_tree_path_free0_ (GList* self);
void xfmpc_dbbrowser_set_wdir (XfmpcDbbrowser* self, const gchar* dir);
void xfmpc_dbbrowser_reload (XfmpcDbbrowser* self);
GType xfmpc_extended_interface_extended_interface_widget_get_type (void) G_GNUC_CONST;
void xfmpc_extended_interface_set_active (XfmpcExtendedInterface* self, XfmpcExtendedInterfaceExtendedInterfaceWidget active_widget);
static void xfmpc_playlist_cb_info_selection (XfmpcPlaylist* self);
XfmpcSongDialog* xfmpc_song_dialog_new (gint song_id);
XfmpcSongDialog* xfmpc_song_dialog_construct (GType object_type, gint song_id);
GType xfmpc_song_dialog_get_type (void) G_GNUC_CONST;
static gboolean xfmpc_playlist_cb_popup_menu (XfmpcPlaylist* self);
static void xfmpc_playlist_menu_popup (XfmpcPlaylist* self);
static void xfmpc_playlist_cb_pp_changed (XfmpcPlaylist* self, gboolean is_playing);
void xfmpc_playlist_refresh_current_song (XfmpcPlaylist* self);
static void xfmpc_playlist_cb_song_changed (XfmpcPlaylist* self);
static void xfmpc_playlist_cb_playlist_changed (XfmpcPlaylist* self);
void xfmpc_playlist_append (XfmpcPlaylist* self, gint id, gint pos, const gchar* filename, const gchar* song, const gchar* length);
static void xfmpc_playlist_cb_row_activated (XfmpcPlaylist* self, GtkTreePath* path, GtkTreeViewColumn* column);
static gboolean xfmpc_playlist_cb_key_released (XfmpcPlaylist* self, GdkEventKey* event);
void xfmpc_playlist_delete_selection (XfmpcPlaylist* self);
static gboolean xfmpc_playlist_cb_button_released (XfmpcPlaylist* self, GdkEventButton* event);
static void xfmpc_playlist_cb_filter_entry_activated (XfmpcPlaylist* self);
void xfmpc_playlist_select_row (XfmpcPlaylist* self, gint i);
static gboolean xfmpc_playlist_cb_filter_entry_key_released (XfmpcPlaylist* self, GdkEventKey* event);
static void xfmpc_playlist_cb_filter_entry_changed (XfmpcPlaylist* self);
static void xfmpc_playlist_cb_filter_entry_icon_activated (XfmpcPlaylist* self, GtkEntryIconPosition icon_pos, GdkEvent* event);
gboolean xfmpc_playlist_has_filename (XfmpcPlaylist* self, const gchar* filename, gboolean is_dir);
XfmpcPlaylist* xfmpc_playlist_new (void);
XfmpcPlaylist* xfmpc_playlist_construct (GType object_type);
static GObject * xfmpc_playlist_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
XfmpcPreferences* xfmpc_preferences_get_default (void);
gboolean xfmpc_preferences_get_playlist_autocenter (XfmpcPreferences* self);
static void _xfmpc_playlist_delete_selection_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xfmpc_playlist_cb_browse_selection_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xfmpc_playlist_cb_info_selection_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _xfmpc_playlist_cb_pp_changed_xfmpc_mpdclient_pp_changed (XfmpcMpdclient* _sender, gboolean is_playing, gpointer self);
static void _xfmpc_playlist_cb_song_changed_xfmpc_mpdclient_song_changed (XfmpcMpdclient* _sender, gpointer self);
static void _xfmpc_playlist_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender, gpointer self);
static void _xfmpc_playlist_cb_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self);
static gboolean _xfmpc_playlist_cb_key_released_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static gboolean _xfmpc_playlist_cb_button_released_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean _xfmpc_playlist_cb_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender, gpointer self);
static void _xfmpc_playlist_cb_filter_entry_activated_gtk_entry_activate (GtkEntry* _sender, gpointer self);
static gboolean _xfmpc_playlist_cb_filter_entry_key_released_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void _xfmpc_playlist_cb_filter_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void _xfmpc_playlist_cb_filter_entry_icon_activated_gtk_entry_icon_release (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self);
static void _xfmpc_playlist_cb_playlist_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void xfmpc_playlist_finalize (GObject* obj);


static GType xfmpc_playlist_columns_get_type (void) {
	static volatile gsize xfmpc_playlist_columns_type_id__volatile = 0;
	if (g_once_init_enter (&xfmpc_playlist_columns_type_id__volatile)) {
		static const GEnumValue values[] = {{XFMPC_PLAYLIST_COLUMNS_COLUMN_ID, "XFMPC_PLAYLIST_COLUMNS_COLUMN_ID", "column-id"}, {XFMPC_PLAYLIST_COLUMNS_COLUMN_FILENAME, "XFMPC_PLAYLIST_COLUMNS_COLUMN_FILENAME", "column-filename"}, {XFMPC_PLAYLIST_COLUMNS_COLUMN_POSITION, "XFMPC_PLAYLIST_COLUMNS_COLUMN_POSITION", "column-position"}, {XFMPC_PLAYLIST_COLUMNS_COLUMN_SONG, "XFMPC_PLAYLIST_COLUMNS_COLUMN_SONG", "column-song"}, {XFMPC_PLAYLIST_COLUMNS_COLUMN_LENGTH, "XFMPC_PLAYLIST_COLUMNS_COLUMN_LENGTH", "column-length"}, {XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT, "XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT", "column-weight"}, {XFMPC_PLAYLIST_COLUMNS_N_COLUMNS, "XFMPC_PLAYLIST_COLUMNS_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType xfmpc_playlist_columns_type_id;
		xfmpc_playlist_columns_type_id = g_enum_register_static ("XfmpcPlaylistColumns", values);
		g_once_init_leave (&xfmpc_playlist_columns_type_id__volatile, xfmpc_playlist_columns_type_id);
	}
	return xfmpc_playlist_columns_type_id__volatile;
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gboolean xfmpc_playlist_visible_func_filter_tree (GtkTreeModel* model, GtkTreeIter* iter) {
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* song;
	gchar* _tmp1_;
	gchar* search;
	gboolean _result_;
	GtkTreeModel* _tmp2_;
	GtkTreeIter _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean _tmp7_;
	GtkEntry* _tmp8_;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_ = NULL;
	const gchar* _tmp13_;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	song = _tmp0_;
	_tmp1_ = g_strdup ("");
	search = _tmp1_;
	_result_ = TRUE;
	_tmp2_ = model;
	_tmp3_ = *iter;
	gtk_tree_model_get (_tmp2_, &_tmp3_, XFMPC_PLAYLIST_COLUMNS_COLUMN_SONG, &song, -1, -1);
	_tmp5_ = song;
	if (_tmp5_ == NULL) {
		_tmp4_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = song;
		_tmp4_ = g_strcmp0 (_tmp6_, "") == 0;
	}
	_tmp7_ = _tmp4_;
	if (_tmp7_) {
		result = TRUE;
		_g_free0 (search);
		_g_free0 (song);
		return result;
	}
	_tmp8_ = xfmpc_playlist_filter_entry;
	_tmp9_ = gtk_entry_get_text (_tmp8_);
	_tmp10_ = g_strdup (_tmp9_);
	_g_free0 (search);
	search = _tmp10_;
	_tmp11_ = search;
	_tmp12_ = g_utf8_casefold (_tmp11_, (gssize) (-1));
	_g_free0 (search);
	search = _tmp12_;
	_tmp13_ = search;
	if (g_strcmp0 (_tmp13_, "") != 0) {
		const gchar* _tmp14_;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gint _tmp18_ = 0;
		_tmp14_ = song;
		_tmp15_ = g_utf8_casefold (_tmp14_, (gssize) (-1));
		_g_free0 (song);
		song = _tmp15_;
		_tmp16_ = song;
		_tmp17_ = search;
		_tmp18_ = string_index_of (_tmp16_, _tmp17_, 0);
		if (_tmp18_ == (-1)) {
			_result_ = FALSE;
		}
	}
	result = _result_;
	_g_free0 (search);
	_g_free0 (song);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _gtk_tree_path_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL));
}


static void _g_list_free__gtk_tree_path_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _gtk_tree_path_free0_, NULL);
	g_list_free (self);
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void xfmpc_playlist_cb_browse_selection (XfmpcPlaylist* self) {
	XfmpcDbbrowser* dbbrowser = NULL;
	XfmpcExtendedInterface* extended_interface = NULL;
	gconstpointer _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	GtkTreeView* _tmp2_;
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeSelection* _tmp4_;
	GtkTreeSelection* selection;
	GtkTreeSelection* _tmp5_;
	gint _tmp6_ = 0;
	GtkTreeModelFilter* _tmp7_;
	GtkTreeModel* _tmp8_;
	GtkTreeModel* model;
	GtkTreeSelection* _tmp9_;
	GtkTreeModel* _tmp10_ = NULL;
	GList* _tmp11_ = NULL;
	GtkTreeModel* _tmp12_;
	GList* list;
	GList* _tmp13_;
	guint _tmp14_ = 0U;
	GtkTreeIter iter = {0};
	GList* _tmp15_;
	gconstpointer _tmp16_ = NULL;
	GtkTreePath* _tmp17_;
	GtkTreePath* path;
	GtkTreeModelFilter* _tmp18_;
	GtkTreePath* _tmp19_;
	GtkTreeIter _tmp20_ = {0};
	gboolean _tmp21_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_object_get_data ((GObject*) self, "XfmpcDbbrowser");
	dbbrowser = (XfmpcDbbrowser*) _tmp0_;
	_tmp1_ = g_object_get_data ((GObject*) self, "XfmpcExtendedInterface");
	extended_interface = (XfmpcExtendedInterface*) _tmp1_;
	_tmp2_ = self->priv->treeview;
	_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	selection = _tmp4_;
	_tmp5_ = selection;
	_tmp6_ = gtk_tree_selection_count_selected_rows (_tmp5_);
	if (_tmp6_ > 1) {
		_g_object_unref0 (selection);
		return;
	}
	_tmp7_ = self->priv->filter;
	_tmp8_ = _g_object_ref0 ((GtkTreeModel*) _tmp7_);
	model = _tmp8_;
	_tmp9_ = selection;
	_tmp11_ = gtk_tree_selection_get_selected_rows (_tmp9_, &_tmp10_);
	_g_object_unref0 (model);
	_tmp12_ = _g_object_ref0 (_tmp10_);
	model = _tmp12_;
	list = _tmp11_;
	_tmp13_ = list;
	_tmp14_ = g_list_length (_tmp13_);
	if (_tmp14_ == ((guint) 0)) {
		__g_list_free__gtk_tree_path_free0_0 (list);
		_g_object_unref0 (model);
		_g_object_unref0 (selection);
		return;
	}
	_tmp15_ = list;
	_tmp16_ = g_list_nth_data (_tmp15_, (guint) 0);
	_tmp17_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp16_);
	path = _tmp17_;
	_tmp18_ = self->priv->filter;
	_tmp19_ = path;
	_tmp21_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp18_, &_tmp20_, _tmp19_);
	iter = _tmp20_;
	if (_tmp21_) {
		gchar* _tmp22_;
		gchar* filename;
		gchar* dir = NULL;
		GtkTreeModelFilter* _tmp23_;
		GtkTreeIter _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_ = NULL;
		XfmpcDbbrowser* _tmp27_;
		const gchar* _tmp28_;
		XfmpcDbbrowser* _tmp29_;
		XfmpcExtendedInterface* _tmp30_;
		_tmp22_ = g_strdup ("");
		filename = _tmp22_;
		_tmp23_ = self->priv->filter;
		_tmp24_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp23_, &_tmp24_, XFMPC_PLAYLIST_COLUMNS_COLUMN_FILENAME, &filename, -1, -1);
		_tmp25_ = filename;
		_tmp26_ = g_path_get_dirname (_tmp25_);
		_g_free0 (dir);
		dir = _tmp26_;
		_tmp27_ = dbbrowser;
		_tmp28_ = dir;
		xfmpc_dbbrowser_set_wdir (_tmp27_, _tmp28_);
		_tmp29_ = dbbrowser;
		xfmpc_dbbrowser_reload (_tmp29_);
		_tmp30_ = extended_interface;
		xfmpc_extended_interface_set_active (_tmp30_, XFMPC_EXTENDED_INTERFACE_EXTENDED_INTERFACE_WIDGET_DBBROWSER);
		_g_free0 (dir);
		_g_free0 (filename);
	}
	_gtk_tree_path_free0 (path);
	__g_list_free__gtk_tree_path_free0_0 (list);
	_g_object_unref0 (model);
	_g_object_unref0 (selection);
}


static void xfmpc_playlist_cb_info_selection (XfmpcPlaylist* self) {
	GtkTreeIter iter = {0};
	gint id;
	GtkTreeView* _tmp0_;
	GtkTreeSelection* _tmp1_ = NULL;
	GtkTreeSelection* _tmp2_;
	GtkTreeSelection* selection;
	GtkTreeSelection* _tmp3_;
	gint _tmp4_ = 0;
	GtkTreeModelFilter* _tmp5_;
	GtkTreeModel* _tmp6_;
	GtkTreeModel* model;
	GtkTreeSelection* _tmp7_;
	GtkTreeModel* _tmp8_ = NULL;
	GList* _tmp9_ = NULL;
	GtkTreeModel* _tmp10_;
	GList* list;
	GList* _tmp11_;
	guint _tmp12_ = 0U;
	GList* _tmp13_;
	gconstpointer _tmp14_ = NULL;
	GtkTreePath* _tmp15_;
	GtkTreePath* path;
	GtkTreeModelFilter* _tmp16_;
	GtkTreePath* _tmp17_;
	GtkTreeIter _tmp18_ = {0};
	gboolean _tmp19_ = FALSE;
	g_return_if_fail (self != NULL);
	id = 0;
	_tmp0_ = self->priv->treeview;
	_tmp1_ = gtk_tree_view_get_selection (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	selection = _tmp2_;
	_tmp3_ = selection;
	_tmp4_ = gtk_tree_selection_count_selected_rows (_tmp3_);
	if (_tmp4_ > 1) {
		_g_object_unref0 (selection);
		return;
	}
	_tmp5_ = self->priv->filter;
	_tmp6_ = _g_object_ref0 ((GtkTreeModel*) _tmp5_);
	model = _tmp6_;
	_tmp7_ = selection;
	_tmp9_ = gtk_tree_selection_get_selected_rows (_tmp7_, &_tmp8_);
	_g_object_unref0 (model);
	_tmp10_ = _g_object_ref0 (_tmp8_);
	model = _tmp10_;
	list = _tmp9_;
	_tmp11_ = list;
	_tmp12_ = g_list_length (_tmp11_);
	if (_tmp12_ == ((guint) 0)) {
		__g_list_free__gtk_tree_path_free0_0 (list);
		_g_object_unref0 (model);
		_g_object_unref0 (selection);
		return;
	}
	_tmp13_ = list;
	_tmp14_ = g_list_nth_data (_tmp13_, (guint) 0);
	_tmp15_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp14_);
	path = _tmp15_;
	_tmp16_ = self->priv->filter;
	_tmp17_ = path;
	_tmp19_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp16_, &_tmp18_, _tmp17_);
	iter = _tmp18_;
	if (_tmp19_) {
		GtkTreeModelFilter* _tmp20_;
		GtkTreeIter _tmp21_;
		gint _tmp22_;
		XfmpcSongDialog* _tmp23_;
		XfmpcSongDialog* _tmp24_;
		XfmpcSongDialog* dialog;
		XfmpcSongDialog* _tmp25_;
		_tmp20_ = self->priv->filter;
		_tmp21_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp20_, &_tmp21_, XFMPC_PLAYLIST_COLUMNS_COLUMN_ID, &id, -1, -1);
		_tmp22_ = id;
		_tmp23_ = xfmpc_song_dialog_new (_tmp22_);
		_tmp24_ = g_object_ref_sink (_tmp23_);
		dialog = _tmp24_;
		_tmp25_ = dialog;
		gtk_widget_show_all ((GtkWidget*) _tmp25_);
		_g_object_unref0 (dialog);
	}
	_gtk_tree_path_free0 (path);
	__g_list_free__gtk_tree_path_free0_0 (list);
	_g_object_unref0 (model);
	_g_object_unref0 (selection);
}


static gboolean xfmpc_playlist_cb_popup_menu (XfmpcPlaylist* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	xfmpc_playlist_menu_popup (self);
	result = TRUE;
	return result;
}


static void xfmpc_playlist_cb_pp_changed (XfmpcPlaylist* self, gboolean is_playing) {
	g_return_if_fail (self != NULL);
	xfmpc_playlist_refresh_current_song (self);
}


static void xfmpc_playlist_cb_song_changed (XfmpcPlaylist* self) {
	g_return_if_fail (self != NULL);
	xfmpc_playlist_refresh_current_song (self);
}


static void xfmpc_playlist_cb_playlist_changed (XfmpcPlaylist* self) {
	gchar* filename;
	gchar* song;
	gchar* length;
	gint id;
	gint pos;
	XfmpcMpdclient* _tmp0_;
	gint _tmp1_ = 0;
	GtkListStore* _tmp2_;
	g_return_if_fail (self != NULL);
	filename = NULL;
	song = NULL;
	length = NULL;
	id = 0;
	pos = 0;
	_tmp0_ = self->priv->mpdclient;
	_tmp1_ = xfmpc_mpdclient_get_id (_tmp0_);
	self->priv->current = _tmp1_;
	_tmp2_ = self->priv->store;
	gtk_list_store_clear (_tmp2_);
	while (TRUE) {
		XfmpcMpdclient* _tmp3_;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gint _tmp10_;
		gint _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp3_ = self->priv->mpdclient;
		_tmp9_ = xfmpc_mpdclient_playlist_read (_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_);
		id = _tmp4_;
		pos = _tmp5_;
		_g_free0 (filename);
		filename = _tmp6_;
		_g_free0 (song);
		song = _tmp7_;
		_g_free0 (length);
		length = _tmp8_;
		if (!_tmp9_) {
			break;
		}
		_tmp10_ = id;
		_tmp11_ = pos;
		_tmp12_ = filename;
		_tmp13_ = song;
		_tmp14_ = length;
		xfmpc_playlist_append (self, _tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_);
	}
	xfmpc_playlist_refresh_current_song (self);
	_g_free0 (length);
	_g_free0 (song);
	_g_free0 (filename);
}


static void xfmpc_playlist_cb_row_activated (XfmpcPlaylist* self, GtkTreePath* path, GtkTreeViewColumn* column) {
	GtkTreeIter iter = {0};
	GtkTreePath* _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* new_path;
	gint id;
	GtkTreeModelFilter* _tmp2_;
	GtkTreePath* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	GtkTreeModelFilter* _tmp6_;
	GtkTreeIter _tmp7_;
	GtkEntry* _tmp8_;
	XfmpcMpdclient* _tmp9_;
	gint _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = path;
	_tmp1_ = _gtk_tree_path_copy0 (_tmp0_);
	new_path = _tmp1_;
	id = 0;
	_tmp2_ = self->priv->filter;
	_tmp3_ = new_path;
	_tmp5_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp2_, &_tmp4_, _tmp3_);
	iter = _tmp4_;
	if (!_tmp5_) {
		_gtk_tree_path_free0 (new_path);
		return;
	}
	_tmp6_ = self->priv->filter;
	_tmp7_ = iter;
	gtk_tree_model_get ((GtkTreeModel*) _tmp6_, &_tmp7_, XFMPC_PLAYLIST_COLUMNS_COLUMN_ID, &id, -1, -1);
	_tmp8_ = xfmpc_playlist_filter_entry;
	gtk_entry_set_text (_tmp8_, "");
	_tmp9_ = self->priv->mpdclient;
	_tmp10_ = id;
	xfmpc_mpdclient_set_id (_tmp9_, _tmp10_);
	_gtk_tree_path_free0 (new_path);
}


static gboolean xfmpc_playlist_cb_key_released (XfmpcPlaylist* self, GdkEventKey* event) {
	gboolean result = FALSE;
	GdkEventKey _tmp0_;
	GdkEventType _tmp1_;
	GdkEventKey _tmp2_;
	guint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.type;
	if (_tmp1_ != GDK_KEY_RELEASE) {
		result = FALSE;
		return result;
	}
	_tmp2_ = *event;
	_tmp3_ = _tmp2_.keyval;
	switch (_tmp3_) {
		case 0xffff:
		{
			xfmpc_playlist_delete_selection (self);
			break;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


static gboolean xfmpc_playlist_cb_button_released (XfmpcPlaylist* self, GdkEventButton* event) {
	gboolean result = FALSE;
	GtkTreePath* path = NULL;
	GtkTreeSelection* selection = NULL;
	gboolean _tmp0_ = FALSE;
	GdkEventButton _tmp1_;
	GdkEventType _tmp2_;
	gboolean _tmp5_;
	GtkTreeView* _tmp6_;
	GtkTreeSelection* _tmp7_ = NULL;
	GtkTreeSelection* _tmp8_;
	GtkTreeSelection* _tmp9_;
	gint _tmp10_ = 0;
	gboolean sensitive;
	GtkImageMenuItem* _tmp11_;
	gboolean _tmp12_;
	GtkImageMenuItem* _tmp13_;
	gboolean _tmp14_;
	GtkTreeView* _tmp15_;
	GdkEventButton _tmp16_;
	gdouble _tmp17_;
	GdkEventButton _tmp18_;
	gdouble _tmp19_;
	GtkTreePath* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	GtkTreeSelection* _tmp28_;
	gint _tmp29_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = *event;
	_tmp2_ = _tmp1_.type;
	if (_tmp2_ != GDK_BUTTON_PRESS) {
		_tmp0_ = TRUE;
	} else {
		GdkEventButton _tmp3_;
		guint _tmp4_;
		_tmp3_ = *event;
		_tmp4_ = _tmp3_.button;
		_tmp0_ = _tmp4_ != ((guint) 3);
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		result = FALSE;
		_g_object_unref0 (selection);
		_gtk_tree_path_free0 (path);
		return result;
	}
	_tmp6_ = self->priv->treeview;
	_tmp7_ = gtk_tree_view_get_selection (_tmp6_);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (selection);
	selection = _tmp8_;
	_tmp9_ = selection;
	_tmp10_ = gtk_tree_selection_count_selected_rows (_tmp9_);
	sensitive = _tmp10_ == 1;
	_tmp11_ = self->priv->mi_browse;
	_tmp12_ = sensitive;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, _tmp12_);
	_tmp13_ = self->priv->mi_information;
	_tmp14_ = sensitive;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, _tmp14_);
	_tmp15_ = self->priv->treeview;
	_tmp16_ = *event;
	_tmp17_ = _tmp16_.x;
	_tmp18_ = *event;
	_tmp19_ = _tmp18_.y;
	_tmp21_ = gtk_tree_view_get_path_at_pos (_tmp15_, (gint) _tmp17_, (gint) _tmp19_, &_tmp20_, NULL, NULL, NULL);
	_gtk_tree_path_free0 (path);
	path = _tmp20_;
	if (_tmp21_) {
		GtkTreeSelection* _tmp22_;
		GtkTreePath* _tmp23_;
		gboolean _tmp24_ = FALSE;
		_tmp22_ = selection;
		_tmp23_ = path;
		_tmp24_ = gtk_tree_selection_path_is_selected (_tmp22_, _tmp23_);
		if (!_tmp24_) {
			GtkTreeSelection* _tmp25_;
			GtkTreeSelection* _tmp26_;
			GtkTreePath* _tmp27_;
			_tmp25_ = selection;
			gtk_tree_selection_unselect_all (_tmp25_);
			_tmp26_ = selection;
			_tmp27_ = path;
			gtk_tree_selection_select_path (_tmp26_, _tmp27_);
		}
	}
	_tmp28_ = selection;
	_tmp29_ = gtk_tree_selection_count_selected_rows (_tmp28_);
	if (_tmp29_ < 1) {
		result = TRUE;
		_g_object_unref0 (selection);
		_gtk_tree_path_free0 (path);
		return result;
	}
	xfmpc_playlist_menu_popup (self);
	result = TRUE;
	_g_object_unref0 (selection);
	_gtk_tree_path_free0 (path);
	return result;
}


static void xfmpc_playlist_menu_popup (XfmpcPlaylist* self) {
	GtkMenu* _tmp0_;
	guint32 _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->menu;
	_tmp1_ = gtk_get_current_event_time ();
	gtk_menu_popup (_tmp0_, NULL, NULL, NULL, NULL, (guint) 0, _tmp1_);
}


static void xfmpc_playlist_cb_filter_entry_activated (XfmpcPlaylist* self) {
	GtkTreeModelFilter* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* model;
	GtkTreeView* _tmp2_;
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_;
	GList* list;
	GList* _tmp7_;
	gconstpointer _tmp8_ = NULL;
	GtkTreePath* _tmp9_;
	GtkTreePath* path;
	GList* _tmp10_;
	guint _tmp11_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->filter;
	_tmp1_ = _g_object_ref0 ((GtkTreeModel*) _tmp0_);
	model = _tmp1_;
	_tmp2_ = self->priv->treeview;
	_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
	_tmp5_ = gtk_tree_selection_get_selected_rows (_tmp3_, &_tmp4_);
	_g_object_unref0 (model);
	_tmp6_ = _g_object_ref0 (_tmp4_);
	model = _tmp6_;
	list = _tmp5_;
	_tmp7_ = list;
	_tmp8_ = g_list_nth_data (_tmp7_, (guint) 0);
	_tmp9_ = _gtk_tree_path_copy0 ((GtkTreePath*) _tmp8_);
	path = _tmp9_;
	_tmp10_ = list;
	_tmp11_ = g_list_length (_tmp10_);
	if (_tmp11_ > ((guint) 0)) {
		GtkTreeView* _tmp12_;
		GtkTreePath* _tmp13_;
		GtkTreeView* _tmp14_;
		GtkTreeViewColumn* _tmp15_ = NULL;
		GtkEntry* _tmp16_;
		gint _tmp17_;
		GtkTreeView* _tmp18_;
		_tmp12_ = self->priv->treeview;
		_tmp13_ = path;
		_tmp14_ = self->priv->treeview;
		_tmp15_ = gtk_tree_view_get_column (_tmp14_, 0);
		gtk_tree_view_row_activated (_tmp12_, _tmp13_, _tmp15_);
		_tmp16_ = xfmpc_playlist_filter_entry;
		gtk_entry_set_text (_tmp16_, "");
		_tmp17_ = self->priv->current;
		xfmpc_playlist_select_row (self, _tmp17_);
		_tmp18_ = self->priv->treeview;
		gtk_widget_grab_focus ((GtkWidget*) _tmp18_);
	}
	_gtk_tree_path_free0 (path);
	__g_list_free__gtk_tree_path_free0_0 (list);
	_g_object_unref0 (model);
}


static gboolean xfmpc_playlist_cb_filter_entry_key_released (XfmpcPlaylist* self, GdkEventKey* event) {
	gboolean result = FALSE;
	GdkEventKey _tmp0_;
	GdkEventType _tmp1_;
	GdkEventKey _tmp2_;
	guint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.type;
	if (_tmp1_ != GDK_KEY_RELEASE) {
		result = FALSE;
		return result;
	}
	_tmp2_ = *event;
	_tmp3_ = _tmp2_.keyval;
	if (_tmp3_ == ((guint) 0xff1b)) {
		GtkEntry* _tmp4_;
		gint _tmp5_;
		GtkTreeView* _tmp6_;
		_tmp4_ = xfmpc_playlist_filter_entry;
		gtk_entry_set_text (_tmp4_, "");
		_tmp5_ = self->priv->current;
		xfmpc_playlist_select_row (self, _tmp5_);
		_tmp6_ = self->priv->treeview;
		gtk_widget_grab_focus ((GtkWidget*) _tmp6_);
	} else {
		GtkEntry* _tmp7_;
		const gchar* _tmp8_ = NULL;
		_tmp7_ = xfmpc_playlist_filter_entry;
		_tmp8_ = gtk_entry_get_text (_tmp7_);
		if (g_strcmp0 (_tmp8_, "") != 0) {
			xfmpc_playlist_select_row (self, 0);
		} else {
			gint _tmp9_;
			_tmp9_ = self->priv->current;
			xfmpc_playlist_select_row (self, _tmp9_);
		}
	}
	result = TRUE;
	return result;
}


static void xfmpc_playlist_cb_filter_entry_changed (XfmpcPlaylist* self) {
	GtkEntry* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GtkTreeModelFilter* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = xfmpc_playlist_filter_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	if (g_strcmp0 (_tmp1_, "") != 0) {
		GtkEntry* _tmp2_;
		_tmp2_ = xfmpc_playlist_filter_entry;
		gtk_entry_set_icon_from_stock (_tmp2_, GTK_ENTRY_ICON_SECONDARY, GTK_STOCK_CLEAR);
	} else {
		GtkEntry* _tmp3_;
		_tmp3_ = xfmpc_playlist_filter_entry;
		gtk_entry_set_icon_from_stock (_tmp3_, GTK_ENTRY_ICON_SECONDARY, NULL);
	}
	_tmp4_ = self->priv->filter;
	gtk_tree_model_filter_refilter (_tmp4_);
}


static void xfmpc_playlist_cb_filter_entry_icon_activated (XfmpcPlaylist* self, GtkEntryIconPosition icon_pos, GdkEvent* event) {
	GtkEntryIconPosition _tmp0_;
	GtkEntry* _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (event != NULL);
	_tmp0_ = icon_pos;
	if (_tmp0_ != GTK_ENTRY_ICON_SECONDARY) {
		return;
	}
	_tmp1_ = xfmpc_playlist_filter_entry;
	gtk_entry_set_text (_tmp1_, "");
	_tmp2_ = self->priv->current;
	xfmpc_playlist_select_row (self, _tmp2_);
}


void xfmpc_playlist_append (XfmpcPlaylist* self, gint id, gint pos, const gchar* filename, const gchar* song, const gchar* length) {
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	gint _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (filename != NULL);
	g_return_if_fail (song != NULL);
	g_return_if_fail (length != NULL);
	_tmp0_ = self->priv->store;
	gtk_list_store_append (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = self->priv->store;
	_tmp3_ = iter;
	_tmp4_ = id;
	_tmp5_ = filename;
	_tmp6_ = pos;
	_tmp7_ = song;
	_tmp8_ = length;
	gtk_list_store_set (_tmp2_, &_tmp3_, XFMPC_PLAYLIST_COLUMNS_COLUMN_ID, _tmp4_, XFMPC_PLAYLIST_COLUMNS_COLUMN_FILENAME, _tmp5_, XFMPC_PLAYLIST_COLUMNS_COLUMN_POSITION, _tmp6_ + 1, XFMPC_PLAYLIST_COLUMNS_COLUMN_SONG, _tmp7_, XFMPC_PLAYLIST_COLUMNS_COLUMN_LENGTH, _tmp8_, XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT, PANGO_WEIGHT_NORMAL, -1, -1);
}


void xfmpc_playlist_refresh_current_song (XfmpcPlaylist* self) {
	GtkTreeIter iter = {0};
	GtkTreePath* path = NULL;
	gint _tmp0_;
	gint _tmp1_;
	GtkTreePath* _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreePath* _tmp4_;
	GtkTreeIter _tmp5_ = {0};
	gboolean _tmp6_ = FALSE;
	XfmpcMpdclient* _tmp9_;
	gint _tmp10_ = 0;
	gint _tmp11_;
	GtkTreePath* _tmp12_;
	GtkListStore* _tmp13_;
	GtkTreePath* _tmp14_;
	GtkTreeIter _tmp15_ = {0};
	gboolean _tmp16_ = FALSE;
	gboolean _tmp19_ = FALSE;
	GtkEntry* _tmp20_;
	const gchar* _tmp21_ = NULL;
	gboolean _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	if (_tmp0_ < 0) {
		self->priv->current = 0;
	}
	_tmp1_ = self->priv->current;
	_tmp2_ = gtk_tree_path_new_from_indices (_tmp1_, -1, -1);
	_gtk_tree_path_free0 (path);
	path = _tmp2_;
	_tmp3_ = self->priv->store;
	_tmp4_ = path;
	_tmp6_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp3_, &_tmp5_, _tmp4_);
	iter = _tmp5_;
	if (_tmp6_) {
		GtkListStore* _tmp7_;
		GtkTreeIter _tmp8_;
		_tmp7_ = self->priv->store;
		_tmp8_ = iter;
		gtk_list_store_set (_tmp7_, &_tmp8_, XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT, PANGO_WEIGHT_NORMAL, -1, -1);
	}
	_tmp9_ = self->priv->mpdclient;
	_tmp10_ = xfmpc_mpdclient_get_pos (_tmp9_);
	self->priv->current = _tmp10_;
	_tmp11_ = self->priv->current;
	_tmp12_ = gtk_tree_path_new_from_indices (_tmp11_, -1, -1);
	_gtk_tree_path_free0 (path);
	path = _tmp12_;
	_tmp13_ = self->priv->store;
	_tmp14_ = path;
	_tmp16_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp13_, &_tmp15_, _tmp14_);
	iter = _tmp15_;
	if (_tmp16_) {
		GtkListStore* _tmp17_;
		GtkTreeIter _tmp18_;
		_tmp17_ = self->priv->store;
		_tmp18_ = iter;
		gtk_list_store_set (_tmp17_, &_tmp18_, XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT, PANGO_WEIGHT_BOLD, -1, -1);
	}
	_tmp20_ = xfmpc_playlist_filter_entry;
	_tmp21_ = gtk_entry_get_text (_tmp20_);
	if (g_strcmp0 (_tmp21_, "") == 0) {
		gboolean _tmp22_;
		_tmp22_ = self->priv->autocenter;
		_tmp19_ = _tmp22_;
	} else {
		_tmp19_ = FALSE;
	}
	_tmp23_ = _tmp19_;
	if (_tmp23_) {
		gint _tmp24_;
		_tmp24_ = self->priv->current;
		xfmpc_playlist_select_row (self, _tmp24_);
	}
	_gtk_tree_path_free0 (path);
}


void xfmpc_playlist_select_row (XfmpcPlaylist* self, gint i) {
	gint _tmp0_;
	GtkTreeModelFilter* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_;
	GtkTreePath* _tmp4_;
	GtkTreePath* path;
	GtkTreeView* _tmp5_;
	GtkTreePath* _tmp6_;
	GtkTreeView* _tmp7_;
	GtkTreePath* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	if (_tmp0_ < 0) {
		return;
	}
	_tmp1_ = self->priv->filter;
	_tmp2_ = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp1_, NULL);
	if (_tmp2_ == 0) {
		return;
	}
	_tmp3_ = i;
	_tmp4_ = gtk_tree_path_new_from_indices (_tmp3_, -1, -1);
	path = _tmp4_;
	_tmp5_ = self->priv->treeview;
	_tmp6_ = path;
	gtk_tree_view_set_cursor (_tmp5_, _tmp6_, NULL, FALSE);
	_tmp7_ = self->priv->treeview;
	_tmp8_ = path;
	gtk_tree_view_scroll_to_cell (_tmp7_, _tmp8_, NULL, TRUE, (gfloat) 0.42, (gfloat) 0);
	_gtk_tree_path_free0 (path);
}


void xfmpc_playlist_delete_selection (XfmpcPlaylist* self) {
	gint id;
	GtkTreeIter iter = {0};
	GtkTreeModelFilter* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* model;
	GtkTreeView* _tmp2_;
	GtkTreeSelection* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	GtkTreeModel* _tmp6_;
	GList* list;
	GList* _tmp7_;
	XfmpcMpdclient* _tmp17_;
	g_return_if_fail (self != NULL);
	id = 0;
	_tmp0_ = self->priv->filter;
	_tmp1_ = _g_object_ref0 ((GtkTreeModel*) _tmp0_);
	model = _tmp1_;
	_tmp2_ = self->priv->treeview;
	_tmp3_ = gtk_tree_view_get_selection (_tmp2_);
	_tmp5_ = gtk_tree_selection_get_selected_rows (_tmp3_, &_tmp4_);
	_g_object_unref0 (model);
	_tmp6_ = _g_object_ref0 (_tmp4_);
	model = _tmp6_;
	list = _tmp5_;
	_tmp7_ = list;
	{
		GList* path_collection = NULL;
		GList* path_it = NULL;
		path_collection = _tmp7_;
		for (path_it = path_collection; path_it != NULL; path_it = path_it->next) {
			GtkTreePath* _tmp8_;
			GtkTreePath* path = NULL;
			_tmp8_ = _gtk_tree_path_copy0 ((GtkTreePath*) path_it->data);
			path = _tmp8_;
			{
				GtkTreeModelFilter* _tmp9_;
				GtkTreePath* _tmp10_;
				GtkTreeIter _tmp11_ = {0};
				gboolean _tmp12_ = FALSE;
				_tmp9_ = self->priv->filter;
				_tmp10_ = path;
				_tmp12_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp9_, &_tmp11_, _tmp10_);
				iter = _tmp11_;
				if (_tmp12_) {
					GtkTreeModelFilter* _tmp13_;
					GtkTreeIter _tmp14_;
					XfmpcMpdclient* _tmp15_;
					gint _tmp16_;
					_tmp13_ = self->priv->filter;
					_tmp14_ = iter;
					gtk_tree_model_get ((GtkTreeModel*) _tmp13_, &_tmp14_, XFMPC_PLAYLIST_COLUMNS_COLUMN_ID, &id, -1, -1);
					_tmp15_ = self->priv->mpdclient;
					_tmp16_ = id;
					xfmpc_mpdclient_queue_remove_id (_tmp15_, _tmp16_);
				}
				_gtk_tree_path_free0 (path);
			}
		}
	}
	_tmp17_ = self->priv->mpdclient;
	xfmpc_mpdclient_queue_commit (_tmp17_);
	__g_list_free__gtk_tree_path_free0_0 (list);
	_g_object_unref0 (model);
}


gboolean xfmpc_playlist_has_filename (XfmpcPlaylist* self, const gchar* filename, gboolean is_dir) {
	gboolean result = FALSE;
	GtkTreeIter iter = {0};
	GtkTreePath* path = NULL;
	gchar* _tmp0_;
	gchar* name;
	GtkTreePath* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (filename != NULL, FALSE);
	_tmp0_ = g_strdup ("");
	name = _tmp0_;
	_tmp1_ = gtk_tree_path_new_from_indices (0, -1, -1);
	_gtk_tree_path_free0 (path);
	path = _tmp1_;
	while (TRUE) {
		GtkListStore* _tmp2_;
		GtkTreePath* _tmp3_;
		GtkTreeIter _tmp4_ = {0};
		gboolean _tmp5_ = FALSE;
		GtkListStore* _tmp6_;
		GtkTreeIter _tmp7_;
		gboolean _tmp8_;
		GtkTreePath* _tmp14_;
		_tmp2_ = self->priv->store;
		_tmp3_ = path;
		_tmp5_ = gtk_tree_model_get_iter ((GtkTreeModel*) _tmp2_, &_tmp4_, _tmp3_);
		iter = _tmp4_;
		if (!_tmp5_) {
			break;
		}
		_tmp6_ = self->priv->store;
		_tmp7_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp6_, &_tmp7_, XFMPC_PLAYLIST_COLUMNS_COLUMN_FILENAME, &name, -1, -1);
		_tmp8_ = is_dir;
		if (_tmp8_) {
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gboolean _tmp11_ = FALSE;
			_tmp9_ = name;
			_tmp10_ = filename;
			_tmp11_ = g_str_has_prefix (_tmp9_, _tmp10_);
			if (_tmp11_) {
				result = TRUE;
				_g_free0 (name);
				_gtk_tree_path_free0 (path);
				return result;
			}
		} else {
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp12_ = name;
			_tmp13_ = filename;
			if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
				result = TRUE;
				_g_free0 (name);
				_gtk_tree_path_free0 (path);
				return result;
			}
		}
		_tmp14_ = path;
		gtk_tree_path_next (_tmp14_);
	}
	result = FALSE;
	_g_free0 (name);
	_gtk_tree_path_free0 (path);
	return result;
}


XfmpcPlaylist* xfmpc_playlist_construct (GType object_type) {
	XfmpcPlaylist * self = NULL;
	self = (XfmpcPlaylist*) g_object_new (object_type, NULL);
	return self;
}


XfmpcPlaylist* xfmpc_playlist_new (void) {
	return xfmpc_playlist_construct (XFMPC_TYPE_PLAYLIST);
}


static void _xfmpc_playlist_delete_selection_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xfmpc_playlist_delete_selection (self);
}


static void _xfmpc_playlist_cb_browse_selection_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xfmpc_playlist_cb_browse_selection (self);
}


static void _xfmpc_playlist_cb_info_selection_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	xfmpc_playlist_cb_info_selection (self);
}


static void _xfmpc_playlist_cb_pp_changed_xfmpc_mpdclient_pp_changed (XfmpcMpdclient* _sender, gboolean is_playing, gpointer self) {
	xfmpc_playlist_cb_pp_changed (self, is_playing);
}


static void _xfmpc_playlist_cb_song_changed_xfmpc_mpdclient_song_changed (XfmpcMpdclient* _sender, gpointer self) {
	xfmpc_playlist_cb_song_changed (self);
}


static void _xfmpc_playlist_cb_playlist_changed_xfmpc_mpdclient_playlist_changed (XfmpcMpdclient* _sender, gpointer self) {
	xfmpc_playlist_cb_playlist_changed (self);
}


static void _xfmpc_playlist_cb_row_activated_gtk_tree_view_row_activated (GtkTreeView* _sender, GtkTreePath* path, GtkTreeViewColumn* column, gpointer self) {
	xfmpc_playlist_cb_row_activated (self, path, column);
}


static gboolean _xfmpc_playlist_cb_key_released_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = xfmpc_playlist_cb_key_released (self, event);
	return result;
}


static gboolean _xfmpc_playlist_cb_button_released_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = xfmpc_playlist_cb_button_released (self, event);
	return result;
}


static gboolean _xfmpc_playlist_cb_popup_menu_gtk_widget_popup_menu (GtkWidget* _sender, gpointer self) {
	gboolean result;
	result = xfmpc_playlist_cb_popup_menu (self);
	return result;
}


static void _xfmpc_playlist_cb_filter_entry_activated_gtk_entry_activate (GtkEntry* _sender, gpointer self) {
	xfmpc_playlist_cb_filter_entry_activated (self);
}


static gboolean _xfmpc_playlist_cb_filter_entry_key_released_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = xfmpc_playlist_cb_filter_entry_key_released (self, event);
	return result;
}


static void _xfmpc_playlist_cb_filter_entry_changed_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	xfmpc_playlist_cb_filter_entry_changed (self);
}


static void _xfmpc_playlist_cb_filter_entry_icon_activated_gtk_entry_icon_release (GtkEntry* _sender, GtkEntryIconPosition p0, GdkEvent* p1, gpointer self) {
	xfmpc_playlist_cb_filter_entry_icon_activated (self, p0, p1);
}


static void _xfmpc_playlist_cb_playlist_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	xfmpc_playlist_cb_playlist_changed (self);
}


static GObject * xfmpc_playlist_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	XfmpcPlaylist * self;
	XfmpcMpdclient* _tmp0_ = NULL;
	XfmpcPreferences* _tmp1_ = NULL;
	XfmpcPreferences* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GtkListStore* _tmp5_;
	GtkListStore* _tmp6_;
	GtkTreeModelFilter* _tmp7_;
	GtkTreeModelFilter* _tmp8_;
	GtkTreeView* _tmp9_;
	GtkTreeView* _tmp10_;
	GtkTreeView* _tmp11_;
	GtkTreeSelection* _tmp12_ = NULL;
	GtkTreeView* _tmp13_;
	GtkTreeView* _tmp14_;
	GtkTreeView* _tmp15_;
	GtkTreeView* _tmp16_;
	GtkTreeView* _tmp17_;
	GtkTreeModelFilter* _tmp18_;
	GtkCellRendererText* _tmp19_;
	GtkCellRendererText* _tmp20_;
	GtkCellRendererText* cell;
	GtkCellRendererText* _tmp21_;
	GtkTreeView* _tmp22_;
	GtkCellRendererText* _tmp23_;
	GtkCellRendererText* _tmp24_;
	GtkCellRendererText* _tmp25_;
	GtkCellRendererText* _tmp26_;
	GtkCellRendererText* _tmp27_;
	GtkTreeViewColumn* _tmp28_;
	GtkTreeViewColumn* _tmp29_;
	GtkTreeViewColumn* column;
	GtkTreeViewColumn* _tmp30_;
	GtkTreeView* _tmp31_;
	GtkTreeViewColumn* _tmp32_;
	GtkCellRendererText* _tmp33_;
	GtkCellRendererText* _tmp34_;
	GtkCellRendererText* _tmp35_;
	GtkTreeView* _tmp36_;
	GtkCellRendererText* _tmp37_;
	GtkAdjustment* _tmp38_;
	GtkAdjustment* _tmp39_;
	GtkAdjustment* _tmp40_;
	GtkAdjustment* _tmp41_;
	GtkScrolledWindow* _tmp42_;
	GtkScrolledWindow* _tmp43_;
	GtkScrolledWindow* _tmp44_;
	GtkScrolledWindow* scrolled;
	GtkScrolledWindow* _tmp45_;
	GtkMenu* _tmp46_;
	GtkMenu* _tmp47_;
	GtkImageMenuItem* _tmp48_;
	GtkImageMenuItem* _tmp49_;
	GtkImageMenuItem* mi;
	GtkMenu* _tmp50_;
	GtkImageMenuItem* _tmp51_;
	GtkImageMenuItem* _tmp52_;
	const gchar* _tmp53_ = NULL;
	GtkImageMenuItem* _tmp54_;
	GtkImageMenuItem* _tmp55_;
	GtkImage* _tmp56_;
	GtkImage* _tmp57_;
	GtkImage* image;
	GtkImageMenuItem* _tmp58_;
	GtkImage* _tmp59_;
	GtkMenu* _tmp60_;
	GtkImageMenuItem* _tmp61_;
	GtkImageMenuItem* _tmp62_;
	GtkImageMenuItem* _tmp63_;
	GtkImageMenuItem* _tmp64_;
	GtkMenu* _tmp65_;
	GtkImageMenuItem* _tmp66_;
	GtkImageMenuItem* _tmp67_;
	GtkMenu* _tmp68_;
	GtkEntry* _tmp69_;
	GtkEntry* _tmp70_;
	GtkEntry* _tmp71_;
	GtkEntry* _tmp72_;
	GtkEntry* _tmp73_;
	GtkScrolledWindow* _tmp74_;
	GtkTreeView* _tmp75_;
	GtkScrolledWindow* _tmp76_;
	GtkEntry* _tmp77_;
	XfmpcMpdclient* _tmp78_;
	XfmpcMpdclient* _tmp79_;
	XfmpcMpdclient* _tmp80_;
	GtkTreeView* _tmp81_;
	GtkTreeView* _tmp82_;
	GtkTreeView* _tmp83_;
	GtkTreeView* _tmp84_;
	GtkEntry* _tmp85_;
	GtkEntry* _tmp86_;
	GtkEntry* _tmp87_;
	GtkEntry* _tmp88_;
	XfmpcPreferences* _tmp89_;
	XfmpcPreferences* _tmp90_;
	parent_class = G_OBJECT_CLASS (xfmpc_playlist_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = XFMPC_PLAYLIST (obj);
	_tmp0_ = xfmpc_mpdclient_get_default ();
	self->priv->mpdclient = _tmp0_;
	_tmp1_ = xfmpc_preferences_get_default ();
	self->priv->preferences = _tmp1_;
	_tmp2_ = self->priv->preferences;
	_tmp3_ = xfmpc_preferences_get_playlist_autocenter (_tmp2_);
	_tmp4_ = _tmp3_;
	self->priv->autocenter = _tmp4_;
	_tmp5_ = gtk_list_store_new ((gint) XFMPC_PLAYLIST_COLUMNS_N_COLUMNS, G_TYPE_INT, G_TYPE_STRING, G_TYPE_INT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_INT);
	_g_object_unref0 (self->priv->store);
	self->priv->store = _tmp5_;
	_tmp6_ = self->priv->store;
	_tmp7_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new ((GtkTreeModel*) _tmp6_, NULL);
	_g_object_unref0 (self->priv->filter);
	self->priv->filter = _tmp7_;
	_tmp8_ = self->priv->filter;
	gtk_tree_model_filter_set_visible_func (_tmp8_, (GtkTreeModelFilterVisibleFunc) xfmpc_playlist_visible_func_filter_tree, NULL, NULL);
	_tmp9_ = (GtkTreeView*) gtk_tree_view_new ();
	_tmp10_ = g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->treeview);
	self->priv->treeview = _tmp10_;
	_tmp11_ = self->priv->treeview;
	_tmp12_ = gtk_tree_view_get_selection (_tmp11_);
	gtk_tree_selection_set_mode (_tmp12_, GTK_SELECTION_MULTIPLE);
	_tmp13_ = self->priv->treeview;
	gtk_tree_view_set_rubber_banding (_tmp13_, TRUE);
	_tmp14_ = self->priv->treeview;
	gtk_tree_view_set_enable_search (_tmp14_, FALSE);
	_tmp15_ = self->priv->treeview;
	gtk_tree_view_set_headers_visible (_tmp15_, FALSE);
	_tmp16_ = self->priv->treeview;
	gtk_tree_view_set_rules_hint (_tmp16_, TRUE);
	_tmp17_ = self->priv->treeview;
	_tmp18_ = self->priv->filter;
	gtk_tree_view_set_model (_tmp17_, (GtkTreeModel*) _tmp18_);
	_tmp19_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp20_ = g_object_ref_sink (_tmp19_);
	cell = _tmp20_;
	_tmp21_ = cell;
	g_object_set ((GtkCellRenderer*) _tmp21_, "xalign", (gfloat) 1, NULL);
	_tmp22_ = self->priv->treeview;
	_tmp23_ = cell;
	gtk_tree_view_insert_column_with_attributes (_tmp22_, -1, "Length", (GtkCellRenderer*) _tmp23_, "text", XFMPC_PLAYLIST_COLUMNS_COLUMN_POSITION, "weight", XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT, NULL, NULL);
	_tmp24_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp25_ = g_object_ref_sink (_tmp24_);
	_g_object_unref0 (cell);
	cell = _tmp25_;
	_tmp26_ = cell;
	g_object_set (_tmp26_, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	_tmp27_ = cell;
	_tmp28_ = gtk_tree_view_column_new_with_attributes ("Song", (GtkCellRenderer*) _tmp27_, "text", XFMPC_PLAYLIST_COLUMNS_COLUMN_SONG, "weight", XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT, NULL, NULL);
	_tmp29_ = g_object_ref_sink (_tmp28_);
	column = _tmp29_;
	_tmp30_ = column;
	gtk_tree_view_column_set_expand (_tmp30_, TRUE);
	_tmp31_ = self->priv->treeview;
	_tmp32_ = column;
	gtk_tree_view_append_column (_tmp31_, _tmp32_);
	_tmp33_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp34_ = g_object_ref_sink (_tmp33_);
	_g_object_unref0 (cell);
	cell = _tmp34_;
	_tmp35_ = cell;
	g_object_set ((GtkCellRenderer*) _tmp35_, "xalign", (gfloat) 1, NULL);
	_tmp36_ = self->priv->treeview;
	_tmp37_ = cell;
	gtk_tree_view_insert_column_with_attributes (_tmp36_, -1, "Length", (GtkCellRenderer*) _tmp37_, "text", XFMPC_PLAYLIST_COLUMNS_COLUMN_LENGTH, "weight", XFMPC_PLAYLIST_COLUMNS_COLUMN_WEIGHT, NULL, NULL);
	_tmp38_ = (GtkAdjustment*) gtk_adjustment_new ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	_tmp39_ = g_object_ref_sink (_tmp38_);
	_tmp40_ = (GtkAdjustment*) gtk_adjustment_new ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
	_tmp41_ = g_object_ref_sink (_tmp40_);
	_tmp42_ = (GtkScrolledWindow*) gtk_scrolled_window_new (_tmp39_, _tmp41_);
	_tmp43_ = g_object_ref_sink (_tmp42_);
	_tmp44_ = _tmp43_;
	_g_object_unref0 (_tmp41_);
	_g_object_unref0 (_tmp39_);
	scrolled = _tmp44_;
	_tmp45_ = scrolled;
	gtk_scrolled_window_set_policy (_tmp45_, GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	_tmp46_ = (GtkMenu*) gtk_menu_new ();
	_tmp47_ = g_object_ref_sink (_tmp46_);
	_g_object_unref0 (self->priv->menu);
	self->priv->menu = _tmp47_;
	_tmp48_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_REMOVE, NULL);
	_tmp49_ = g_object_ref_sink (_tmp48_);
	mi = _tmp49_;
	_tmp50_ = self->priv->menu;
	_tmp51_ = mi;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp50_, (GtkWidget*) ((GtkMenuItem*) _tmp51_));
	_tmp52_ = mi;
	g_signal_connect_object ((GtkMenuItem*) _tmp52_, "activate", (GCallback) _xfmpc_playlist_delete_selection_gtk_menu_item_activate, self, 0);
	_tmp53_ = _ ("Browse");
	_tmp54_ = (GtkImageMenuItem*) gtk_image_menu_item_new_with_mnemonic (_tmp53_);
	_tmp55_ = g_object_ref_sink (_tmp54_);
	_g_object_unref0 (self->priv->mi_browse);
	self->priv->mi_browse = _tmp55_;
	_tmp56_ = (GtkImage*) gtk_image_new_from_stock (GTK_STOCK_OPEN, GTK_ICON_SIZE_MENU);
	_tmp57_ = g_object_ref_sink (_tmp56_);
	image = _tmp57_;
	_tmp58_ = self->priv->mi_browse;
	_tmp59_ = image;
	gtk_image_menu_item_set_image (_tmp58_, (GtkWidget*) _tmp59_);
	_tmp60_ = self->priv->menu;
	_tmp61_ = self->priv->mi_browse;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp60_, (GtkWidget*) ((GtkMenuItem*) _tmp61_));
	_tmp62_ = self->priv->mi_browse;
	g_signal_connect_object ((GtkMenuItem*) _tmp62_, "activate", (GCallback) _xfmpc_playlist_cb_browse_selection_gtk_menu_item_activate, self, 0);
	_tmp63_ = (GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_INFO, NULL);
	_tmp64_ = g_object_ref_sink (_tmp63_);
	_g_object_unref0 (self->priv->mi_information);
	self->priv->mi_information = _tmp64_;
	_tmp65_ = self->priv->menu;
	_tmp66_ = self->priv->mi_information;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp65_, (GtkWidget*) ((GtkMenuItem*) _tmp66_));
	_tmp67_ = self->priv->mi_information;
	g_signal_connect_object ((GtkMenuItem*) _tmp67_, "activate", (GCallback) _xfmpc_playlist_cb_info_selection_gtk_menu_item_activate, self, 0);
	_tmp68_ = self->priv->menu;
	gtk_widget_show_all ((GtkWidget*) _tmp68_);
	_tmp69_ = (GtkEntry*) gtk_entry_new ();
	_tmp70_ = g_object_ref_sink (_tmp69_);
	_g_object_unref0 (xfmpc_playlist_filter_entry);
	xfmpc_playlist_filter_entry = _tmp70_;
	_tmp71_ = xfmpc_playlist_filter_entry;
	gtk_entry_set_icon_from_stock (_tmp71_, GTK_ENTRY_ICON_PRIMARY, GTK_STOCK_FIND);
	_tmp72_ = xfmpc_playlist_filter_entry;
	gtk_entry_set_icon_activatable (_tmp72_, GTK_ENTRY_ICON_PRIMARY, FALSE);
	_tmp73_ = xfmpc_playlist_filter_entry;
	gtk_entry_set_icon_activatable (_tmp73_, GTK_ENTRY_ICON_SECONDARY, TRUE);
	_tmp74_ = scrolled;
	_tmp75_ = self->priv->treeview;
	gtk_container_add ((GtkContainer*) _tmp74_, (GtkWidget*) _tmp75_);
	_tmp76_ = scrolled;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp76_, TRUE, TRUE, (guint) 0);
	_tmp77_ = xfmpc_playlist_filter_entry;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp77_, FALSE, FALSE, (guint) 0);
	_tmp78_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp78_, "pp-changed", (GCallback) _xfmpc_playlist_cb_pp_changed_xfmpc_mpdclient_pp_changed, self, 0);
	_tmp79_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp79_, "song-changed", (GCallback) _xfmpc_playlist_cb_song_changed_xfmpc_mpdclient_song_changed, self, 0);
	_tmp80_ = self->priv->mpdclient;
	g_signal_connect_object (_tmp80_, "playlist-changed", (GCallback) _xfmpc_playlist_cb_playlist_changed_xfmpc_mpdclient_playlist_changed, self, 0);
	_tmp81_ = self->priv->treeview;
	g_signal_connect_object (_tmp81_, "row-activated", (GCallback) _xfmpc_playlist_cb_row_activated_gtk_tree_view_row_activated, self, 0);
	_tmp82_ = self->priv->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp82_, "key-release-event", (GCallback) _xfmpc_playlist_cb_key_released_gtk_widget_key_release_event, self, 0);
	_tmp83_ = self->priv->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp83_, "button-press-event", (GCallback) _xfmpc_playlist_cb_button_released_gtk_widget_button_press_event, self, 0);
	_tmp84_ = self->priv->treeview;
	g_signal_connect_object ((GtkWidget*) _tmp84_, "popup-menu", (GCallback) _xfmpc_playlist_cb_popup_menu_gtk_widget_popup_menu, self, 0);
	_tmp85_ = xfmpc_playlist_filter_entry;
	g_signal_connect_object (_tmp85_, "activate", (GCallback) _xfmpc_playlist_cb_filter_entry_activated_gtk_entry_activate, self, 0);
	_tmp86_ = xfmpc_playlist_filter_entry;
	g_signal_connect_object ((GtkWidget*) _tmp86_, "key-release-event", (GCallback) _xfmpc_playlist_cb_filter_entry_key_released_gtk_widget_key_release_event, self, 0);
	_tmp87_ = xfmpc_playlist_filter_entry;
	g_signal_connect_object ((GtkEditable*) _tmp87_, "changed", (GCallback) _xfmpc_playlist_cb_filter_entry_changed_gtk_editable_changed, self, 0);
	_tmp88_ = xfmpc_playlist_filter_entry;
	g_signal_connect_object (_tmp88_, "icon-release", (GCallback) _xfmpc_playlist_cb_filter_entry_icon_activated_gtk_entry_icon_release, self, 0);
	_tmp89_ = self->priv->preferences;
	g_signal_connect_object ((GObject*) _tmp89_, "notify::song-format", (GCallback) _xfmpc_playlist_cb_playlist_changed_g_object_notify, self, 0);
	_tmp90_ = self->priv->preferences;
	g_signal_connect_object ((GObject*) _tmp90_, "notify::song-format-custom", (GCallback) _xfmpc_playlist_cb_playlist_changed_g_object_notify, self, 0);
	_g_object_unref0 (image);
	_g_object_unref0 (mi);
	_g_object_unref0 (scrolled);
	_g_object_unref0 (column);
	_g_object_unref0 (cell);
	return obj;
}


static void xfmpc_playlist_class_init (XfmpcPlaylistClass * klass) {
	xfmpc_playlist_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (XfmpcPlaylistPrivate));
	G_OBJECT_CLASS (klass)->constructor = xfmpc_playlist_constructor;
	G_OBJECT_CLASS (klass)->finalize = xfmpc_playlist_finalize;
}


static void xfmpc_playlist_instance_init (XfmpcPlaylist * self) {
	self->priv = XFMPC_PLAYLIST_GET_PRIVATE (self);
	self->priv->current = 0;
}


static void xfmpc_playlist_finalize (GObject* obj) {
	XfmpcPlaylist * self;
	self = XFMPC_PLAYLIST (obj);
	_g_object_unref0 (self->priv->store);
	_g_object_unref0 (self->priv->filter);
	_g_object_unref0 (self->priv->treeview);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->mi_browse);
	_g_object_unref0 (self->priv->mi_information);
	G_OBJECT_CLASS (xfmpc_playlist_parent_class)->finalize (obj);
}


GType xfmpc_playlist_get_type (void) {
	static volatile gsize xfmpc_playlist_type_id__volatile = 0;
	if (g_once_init_enter (&xfmpc_playlist_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (XfmpcPlaylistClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) xfmpc_playlist_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (XfmpcPlaylist), 0, (GInstanceInitFunc) xfmpc_playlist_instance_init, NULL };
		GType xfmpc_playlist_type_id;
		xfmpc_playlist_type_id = g_type_register_static (GTK_TYPE_VBOX, "XfmpcPlaylist", &g_define_type_info, 0);
		g_once_init_leave (&xfmpc_playlist_type_id__volatile, xfmpc_playlist_type_id);
	}
	return xfmpc_playlist_type_id__volatile;
}



