/* ------------------------------------------------------------------------
   xfreecd include file for XfreeCD

   Copyright 1998 by Brian C. Lane
   http://www.brianlane.com/

   ------------------------------------------------------------------------ */
#define DEFAULT_CDDB_PATH "~/.config/CDDB"
#define DEFAULT_SERVER    "freedb.freedb.org"
#define DEFAULT_DEVICE    "/dev/cdrom"
#define DEFAULT_TO_CDDBD  "xmcd-cddb@amb.org"
#define MAIL_BINARY       "mail"


struct SITE {
  char *name;
  int  port;
  struct SITE *next;
};

struct CONFIG {
  char   *device;               /* CD device to use */
  char   *local_cddb;
  char   *current;              /* Current server name */
  char   *to_cddbd;             /* Server to send to */
  struct SITE *server;
  short  done_eject;            /* Eject when play is finished */
  short  exit_eject;            /* Eject on Exit when not playing */
  short  startup;               /* What should we do at startup? See STARTUP_* */
  short  cddb;                  /* Is cddb support enabled? */
  short  wm_no_decor;           /* Hide main window decorations? */
  short  changer;               /* Is IDE CD changer support enabled? */
  short  saved;                 /* Saved state. 1 = saved, 0 = needs to be saved */
};
