%define release 1

Summary:	GNOME-based Bible research tool
Name:		xiphos
Prefix:		/usr
Version:	3.1.3
Release:	%{release}
License:	GPL
URL:		http://xiphos.sourceforge.net/
Group:		Applications/Productivity
Source:		http://prdownloads.sourceforge.net/%{name}/%{name}-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-root
Requires:	sword = %(rpm -q --queryformat '%%{version}' sword)
Requires:	libgnomeui >= 2.2
Requires:	gtkhtml3 >= 3.0
Requires:	libbonobo >= 2.0
BuildRequires:	sword-devel >= 1.5.6
BuildRequires:	libgnomeui-devel >= 2.2
BuildRequires:	gtkhtml3-devel >= 3.0
BuildRequires:	libbonobo-devel >= 2.0
BuildRequires:	gnome-spell
BuildRequires:	scrollkeeper >= 0.3.5
Obsoletes:	xiphos

%description
Bible Study Software for the Linux community. Lookup and search Bible texts and
commentaries. Xiphos uses modules and libraries from the SWORD Project. 
Display multiple translations in the interlinear window. Search for passages in 
any translation by word, phrase, or regular expression. Install this package
if you want to browse the Bible translations and reference works distributed
by Crosswire Bible Society through the SWORD Project.

%prep
%setup -q -n %{name}-%{version}

%build
./configure --prefix=%{prefix} --sysconfdir=/etc
make

%install
make DESTDIR=$RPM_BUILD_ROOT install

mkdir -p $RPM_BUILD_ROOT%{prefix}/share/doc/%{name}-%{version}
mv $RPM_BUILD_ROOT%{prefix}/share/doc/%{name}/* $RPM_BUILD_ROOT%{prefix}/share/doc/%{name}-%{version}
rmdir $RPM_BUILD_ROOT%{prefix}/share/doc/%{name}
cd $RPM_BUILD_ROOT%{prefix}

%clean
case "$RPM_BUILD_ROOT" in
/var/*) rm -rf $RPM_BUILD_ROOT;;
esac

%post
if which scrollkeeper-update>/dev/null 2>&1; then scrollkeeper-update -q -o %{_datadir}/omf/%{name}; fi

%postun
if which scrollkeeper-update>/dev/null 2>&1; then scrollkeeper-update -q; fi

%files
%defattr(-,root,root)
%{prefix}/bin/xiphos
%{prefix}/bin/gnomesword2
%{prefix}/share/gnome/help/*
%{prefix}/share/xiphos/*
%{prefix}/share/locale/*
%{prefix}/share/pixmaps/*
%doc ABOUT-NLS AUTHORS COPYING COPYING-DOCS INSTALL NEWS README TODO
%{prefix}/share/applications/%{name}.desktop

%changelog
* Sun Dec 17 2006 Karl Kleinpaste <karl@charcoal.com>
- reworked a lot of cruft for FC 5 & 6.
* Wed Jan 14 2004 Andy Piper <andyp@users.sf.net>
- cleaned build statements thanks to Hugo (will now build as user)
- changed package name
* Wed Dec 31 2003 Andy Piper <andyp@users.sf.net>
- Better checking for SWORD version
- tidied up macros
* Wed Dec 10 2003 Andy Piper <andyp@users.sf.net>
- Updated dependencies
* Mon Dec 08 2003 Andy Piper <andyp@users.sf.net>
- Updated dependencies
* Fri Dec 05 2003 Andy Piper <andyp@users.sf.net>
- Added to Xiphos CVS
* Thu Nov 27 2003 Hugo van der Kooij <hugo@vanderkooij.org>
- Fixed loose ends in the config
* Tue Nov 25 2003 Hugo van der Kooij <hugo@vanderkooij.org>
- Version 2.0-0.9dev15
- Changed bits to follow new name convention
* Sat Nov 15 2003 Hugo van der Kooij <hugo@vanderkooij.org>
- Version 2.0-0.9dev11
- Build and tested on Fedora Core 1
* Tue Oct 28 2003 Hugo van der Kooij <hugo@vanderkooij.org>
- Version 2.0-0.9dev9
* Sat Oct 25 2003 Hugo van der Kooij <hugo@vanderkooij.org>
- Version 2.0-0.9dev8
* Fri Aug 29 2003  Hugo van der Kooij <hugo@vanderkooij.org>
- Version 1.0-0.9dev5
- Build against Sword 1.5.6rc1
- Build and tested on Red Hat Linux 9
* Mon Mar 25 2003 Hugo van der Kooij <hugo@vanderkooij.org>
- Version 0.7.9
- Build against Sword 1.5.5
- Build and tested on Red Hat Linux 8.0
* Sat Mar 15 2003 Hugo van der Kooij <hugo@vanderkooij.org>
- Version 0.7.8
- Build against Sword 1.5.5
- Build and tested on Red Hat Linux 8.0
* Fri Dec 20 2002 Hugo van der Kooij <hugo@vanderkooij.org>
- Version 0.7.7
- Build against Sword 1.5.5
- Build and tested on Red Hat Linux 8.0
* Sat Dec 14 2002 Hugo van der Kooij <hugo@vanderkooij.org>
- Version 0.7.6
- Build against Sword 1.5.5
- Build and tested on Red Hat Linux 8.0
* Sat Sep 28 2002 Hugo van der Kooij <hugo@vanderkooij.org>
- Build against Sword 1.5.4
* Mon Sep 02 2002 Hugo van der Kooij <hugo@vanderkooij.org>
- Fixed the docs with small patch
* Tue Aug 21 2002 Hugo van der Kooij <hugo@vanderkooij.org>
- Version 0.7.5
- Install in the regular tree (not /usr/local)
- Needs fix on documentation directory (usr/doc should be /usr/share/doc)
* Thu Dec 13 2001 Stuart Gathman <stuart@bmsi.com>
- version 0.5.2c
- move applnk to /usr/share/gnome
* Mon Dec 25 2000 Stuart Gathman <stuart@bmsi.com>
- version 0.3.7a
* Thu Nov 30 2000 Stuart Gathman <stuart@bmsi.com>
- version 0.3.2
* Fri Nov 17 2000 Stuart Gathman <stuart@bmsi.com>
- add applnk entry
* Wed Nov 08 2000 Stuart Gathman <stuart@bmsi.com>
- build against sword-1.5.1a
- SWModule::Delete renamed to SWModule::deleteEntry
* Fri Oct 28 2000 Stuart Gathman <stuart@bmsi.com>
- initial release
