/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2002 Joop Stakenborg <pa4tu@amsat.org>
 *
 * This program is free oftware; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * callbacks_clist.c - callbacks for the clist widget
 */

#include <stdlib.h>
#include <gtk/gtk.h>

#include "callbacks_clist.h"
#include "interface.h"
#include "support.h"
#include "types.h"
#include "log.h"
#include "utils.h"

extern GtkWidget *mainwindow;
extern statetype state;
extern gchar **bandsplit;
extern gchar **modesplit;
extern preferencestype preferences;
extern GList *logwindowlist;
extern GtkWidget *mainnotebook;

/* a row is selected, update the qso frame */
void on_log_select_row (GtkCList *clist, gint row, gint column, GdkEvent *event, gpointer user_data) {
	GtkWidget *dateentry, *gmtentry, *callentry, *rstentry, *myrstentry,
						*remarksentry, *bandentry, *modeentry, *outcheckbutton,
						*incheckbutton;
	GtkWidget *modeoptionmenu, *bandoptionmenu, *qsoframe;
	gchar *frametext, *bandcopy, **item;
	guint i, bandindex = 0, modeindex = 0;
	logtype *logwindow;

	dateentry = lookup_widget(mainwindow, "dateentry");
	gmtentry = lookup_widget(mainwindow, "gmtentry");
	callentry = lookup_widget(mainwindow, "callentry");
	bandentry = lookup_widget(mainwindow, "bandentry");
	modeentry = lookup_widget(mainwindow, "modeentry");
	rstentry = lookup_widget(mainwindow, "rstentry");
	myrstentry = lookup_widget(mainwindow, "myrstentry");
	remarksentry = lookup_widget(mainwindow, "remarksentry");
	modeoptionmenu = lookup_widget(mainwindow, "modeoptionmenu");
	bandoptionmenu = lookup_widget(mainwindow, "bandoptionmenu");
	outcheckbutton = lookup_widget(mainwindow, "outcheckbutton");
	incheckbutton = lookup_widget(mainwindow, "incheckbutton");

	item = g_new0(gchar *, 11);
	for (i = 0; i < 11; i++) gtk_clist_get_text(clist, row, i, &item[i]);

	for (i = 0; i < g_list_length(logwindowlist); i++)
	{
		logwindow = g_list_nth_data(logwindowlist, i);
		if ((GTK_CLIST(logwindow->clist)) != GTK_CLIST(clist))
			gtk_clist_unselect_all(GTK_CLIST(logwindow->clist));
	}

	gtk_entry_set_text(GTK_ENTRY(dateentry), item[DATE]);
	gtk_entry_set_text(GTK_ENTRY(gmtentry), item[GMT]);
	gtk_entry_set_text(GTK_ENTRY(callentry), item[CALL]);
	gtk_entry_set_text(GTK_ENTRY(rstentry), item[RST]);
	gtk_entry_set_text(GTK_ENTRY(myrstentry), item[MYRST]);
	gtk_entry_set_text(GTK_ENTRY(remarksentry), item[REMARKS]);

	/* lookup the mode for this qso and set the optionmenu and the modeentry*/
	gtk_entry_set_text(GTK_ENTRY(modeentry), item[MODE]);
	if (preferences.modeseditbox == 0)
	{
		for (;;)
		{
			if (!modesplit[modeindex]) break;
			if (g_strcasecmp(item[MODE], modesplit[modeindex]) == 0)
			{
				gtk_option_menu_set_history(GTK_OPTION_MENU(modeoptionmenu), modeindex);
				break;
			}
			modeindex++;
		}
	}
	gtk_entry_set_text(GTK_ENTRY(bandentry), item[BAND]);
	if (preferences.bandseditbox == 0)
	{
		if (strlen(item[BAND]) <= 2) bandcopy = g_strdup(item[BAND]);
		else bandcopy = finddot(item[BAND]);
		for (;;) 
		{
			if (!bandsplit[bandindex]) break;
			if (g_strcasecmp(bandcopy, bandsplit[bandindex]) == 0) 
			{
				gtk_option_menu_set_history(GTK_OPTION_MENU(bandoptionmenu), bandindex);
				break;
			}
			bandindex++;
		}
		g_free(bandcopy);
	}

	/* set QSL out and QSL in checkbuttons */
	if (g_strcasecmp(item[QSLOUT], "x") == 0)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(outcheckbutton), TRUE);
	else
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(outcheckbutton), FALSE);
	if (g_strcasecmp(item[QSLIN], "x") == 0) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(incheckbutton), TRUE);
	else
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(incheckbutton), FALSE);

	qsoframe = lookup_widget(mainwindow, "qsoframe");
	frametext = g_strdup_printf("QSO %s", item[NR]);
	gtk_frame_set_label(GTK_FRAME(qsoframe), frametext);
	g_free(frametext);
	g_free(item);
}
