/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2006 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* gui_aboutdialog.c - creation of the about dialog */

#include <gtk/gtk.h>

#include "gui_aboutdialog.h"
#include "gui_utils.h"
#include "support.h"
#include "preferences.h"

extern preferencestype preferences;
extern GtkWidget *mainwindow;

static void
handle_url (GtkAboutDialog *about, const char *link, gpointer data)
{
	gchar *command[] = {"firefox", NULL, NULL};

	command[1] = g_strdup (link);
	g_spawn_async
		(NULL, command, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, NULL);
	g_free (command[1]);
}

static void
handle_email (GtkAboutDialog *about, const char *link, gpointer data)
{
	gchar *command[] = {"evolution", NULL, NULL};

	command[1] = g_strdup_printf ("mailto:%s", link);
	g_spawn_async
		(NULL, command, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, NULL);
	g_free (command[1]);
}

void
on_menu_about_activate (GtkMenuItem * menuitem, gpointer user_data)
{
	gchar *authors[] = { "Joop Stakenborg PG4I <pg4i@amsat.org>", 
		"Stephane Fillod F8CFE <f8cfe@free.fr>", NULL };
	GdkPixbuf *pixbuf = create_pixbuf ("xlog.png");

	gtk_about_dialog_set_url_hook (handle_url, NULL, NULL);
	gtk_about_dialog_set_email_hook (handle_email, NULL, NULL);

	gtk_show_about_dialog (GTK_WINDOW(mainwindow), 
		"authors", authors,
		"comments", _("logbook program for amateur radio operators"),
		"license", 
"Copyright (C) 2001 - 2005 Joop Stakenborg <pg4i@amsat.org>\n"
"\n"
"This program is free software; you can redistribute it and/or modify\n"
"it under the terms of the GNU General Public License as published by\n"
"the Free Software Foundation; either version 2 of the License, or\n"
"(at your option) any later version.\n"
"\n"
"This program is distributed in the hope that it will be useful,\n"
"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the\n"
"GNU Library General Public License for more details.\n"
"\n"
"You should have received a copy of the GNU General Public License\n"
"along with this program; if not, write to the Free Software\n"
"Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n",
		"website", "http://www.qsl.net/pg4i/linux/xlog.html",
		"logo", pixbuf,
		"translator-credits",
"Czech: Jan Straka OK2JTB <bach@email.cz>\n"
"Danish: Alexandru Csete OZ9AEC <alexc@phys.au.dk>\n"
"Dutch: Joop Stakenborg PG4I <pg4i@amsat.org>\n"
"French: Jean-Luc Coulon F5IBH <jean-luc.coulon@wanadoo.fr>\n"
"Polish: Boguslaw Ciastek SQ5TB <ciacho@z.pl>\n"
"Spanish: Jaime Robles EA4TV <jaime@robles.nu>\n"
"Slovak: Michal Karas OM4AA <zoliq@ilm.utc.sk>\n"
"Swedish: Peter Landgren SM4ABE <peter.talken@telia.com>\n",
		"version", VERSION,
		NULL);
}
