/*

   xlog - GTK+ logging program for amateur radio operators
   Copyright (C) 2001 - 2007 Joop Stakenborg <pg4i@amsat.org>

   This file is part of xlog.

   Xlog is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   Xlog is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with xlog.  If not, see <http://www.gnu.org/licenses/>.

*/

/*
 * labels.c - support for glabels, export some fields in a TAB separated way
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <glib.h>

#include "logfile.h"
#include "preferences.h"
#include "wwl.h"

/*
 * file fields
 */
static gint labels_open (LOGDB *);
static void labels_close (LOGDB *);
static gint labels_create (LOGDB *);
static gint labels_qso_append (LOGDB *, const qso_t *);
static gint labels_qso_foreach (LOGDB *,
	gint (*fn) (LOGDB *, qso_t *, gpointer arg), gpointer arg);

extern preferencestype preferences;

const struct log_ops labels_ops = {
	.open = labels_open,
	.close = labels_close,
	.create = labels_create,
	.qso_append = labels_qso_append,
	.qso_foreach = labels_qso_foreach,
	.type = TYPE_LABELS,
	.name = "Labels",
	.extension = ".labels",
};

/*
 * open for read
 */
gint
labels_open (LOGDB * handle)
{
	FILE *fp;

	fp = fopen (handle->path, "r");
	if (!fp)
		return -1;
	handle->priv = (gpointer) fp;

	return 0;
}

/*
 * open for write
 */
gint
labels_create (LOGDB * handle)
{
	FILE *fp;

	fp = fopen (handle->path, "w");
	if (!fp)
		return -1;
	handle->priv = (gpointer) fp;
	return 0;
}

void
labels_close (LOGDB * handle)
{
	FILE *fp = (FILE *) handle->priv;
	fclose (fp);
}

gint
labels_qso_append (LOGDB * handle, const qso_t * q)
{
	FILE *fp = (FILE *) handle->priv;
	gint kms, miles, l, result;

	if (preferences.saveastsv2[0] == '1')
	{
		if (q[DATE]) fprintf (fp, "%s\t", q[DATE]); else fprintf (fp, "\t");
	}
	if (preferences.saveastsv2[2] == '1')
	{
		if (q[GMT]) fprintf (fp, "%s\t", q[GMT]); else fprintf (fp, "\t");
	}
	if (preferences.saveastsv2[4] == '1')
	{
		if (q[GMTEND]) fprintf (fp, "%s\t", q[GMTEND]); else fprintf (fp, "\t");
	}
	if (preferences.saveastsv2[6] == '1')
	{
		if (q[CALL]) fprintf (fp, "%s\t", q[CALL]); else fprintf (fp, "\t");
	}
	if (preferences.saveastsv2[8] == '1')
	{
		if (q[BAND]) fprintf (fp, "%s\t", q[BAND]); else fprintf (fp, "\t");
	}
	if (preferences.saveastsv2[10] == '1')
	{
		if (q[MODE]) fprintf (fp, "%s\t", q[MODE]); else fprintf (fp, "\t");
	}
	if (preferences.saveastsv2[12] == '1')
	{
		if (q[RST]) fprintf (fp, "%s\t", q[RST]); else fprintf (fp, "\t");
	}
	if (preferences.saveastsv2[14] == '1')
	{
		if (q[MYRST]) fprintf (fp, "%s\t", q[MYRST]); else fprintf (fp, "\t");
	}
	if (preferences.saveastsv2[16] == '1')
	{
		if (q[AWARDS]) fprintf (fp, "%s\t", q[AWARDS]); else fprintf (fp, "\t");
	}
	if (preferences.saveastsv2[18] == '1')
	{
		if (q[QSLOUT]) fprintf (fp, "%s\t", q[QSLOUT]); else fprintf (fp, "\t");
	}
	if (preferences.saveastsv2[20] == '1')
	{
		if (q[QSLIN]) fprintf (fp, "%s\t", q[QSLIN]); else fprintf (fp, "\t");
	}
	if (preferences.saveastsv2[22] == '1')
	{
		if (q[POWER]) fprintf (fp, "%s\t", q[POWER]); else fprintf (fp, "\t");
	}
	if (preferences.saveastsv2[24] == '1')
	{
		if (q[NAME]) fprintf (fp, "%s\t", q[NAME]); else fprintf (fp, "\t");
	}
	if (preferences.saveastsv2[26] == '1')
	{
		if (q[QTH]) fprintf (fp, "%s\t", q[QTH]); else fprintf (fp, "\t");
	}
	if (preferences.saveastsv2[28] == '1')
	{
		if (q[LOCATOR])
		{
			if (preferences.tsvcalc == 0) 
				fprintf (fp, "%s\t", q[LOCATOR]);
			else
			{
				result =  locatordistance (preferences.locator, q[LOCATOR], &kms, &l);
				if (result == 0)
				{
					if (preferences.units == 1)
						fprintf (fp, "%s\t%d\t%d\t", q[LOCATOR], kms, l);
					else
					{
						miles = (gint) (kms / 1.609);
						fprintf (fp, "%s\t%d\t%d\t", q[LOCATOR], miles, l);
					}
				}
				else
					fprintf (fp, "%s\t%d\t%d\t", q[LOCATOR], 0, 0);
			}
 		}
		else 
		{
			if (preferences.tsvcalc == 0) 
				fprintf (fp, "\t");
			else
				fprintf (fp, "\t\t\t");
		}
	}
	if (preferences.saveastsv2[30] == '1')
	{
		if (q[U1]) fprintf (fp, "%s\t", q[U1]); else fprintf (fp, "\t");
	}
	if (preferences.saveastsv2[32] == '1')
	{
		if (q[U2]) fprintf (fp, "%s\t", q[U2]); else fprintf (fp, "\t");
	}
	if (preferences.saveastsv2[34] == '1')
	{
		if (q[REMARKS]) fprintf (fp, "%s\t", q[REMARKS]); else fprintf (fp, "\t");
	}
	fprintf (fp, "\n");
	return 0;
}

gint labels_qso_foreach 
(LOGDB * handle, gint (*fn) (LOGDB *, qso_t *, gpointer arg), gpointer arg)
{
	return 1;
}
