package xm::xhtml;
use xm::o;

# http://www.w3.org/TR/2000/REC-xhtml-basic-20001219

$xm{xhtml}{xhtmlbasic} =
{
    # structure module
    body => 3, head => 2, html => 2, title => 2,
    # text module
    abbr => 2, acronym => 2, address => 2, blockquote => 2,
    br => 1, cite => 2, code => 2, dfn => 2, div => 2,
    em => 2, h1 => 2, h2 => 2, h3 => 2, h4 => 2, h5 => 2, h6 => 2,
    kbd => 2, p => 3, pre => 2, q => 2, samp => 2, span => 2, 
    strong => 2, var => 2,
    # hypertext module
    a => 3,
    # list module
    dl => 2, dt => 2, dd => 2, ol => 2, ul => 2, li => 3,
    # basic forms module
    form => 2, input => 3, label => 3, select => 2,
    option => 3, textarea => 3,
    # basic tables module
    caption => 2, table => 2, td => 2, th => 2, tr => 2,
    # image module
    img => 1,
    # object module
    object => 3, param => 1,
    # metainformation module
    meta => 1,
    # link module
    link => 1,
    # base module
    base => 1,
};


$xm{xhtml}{xhtmldef} = 
{
    ### copy from xhtmlbasic ###
    # structure module
    body => 3, head => 2, html => 2, title => 2,
    # text module
    abbr => 2, acronym => 2, address => 2, blockquote => 2,
    br => 1, cite => 2, code => 2, dfn => 2, div => 2,
    em => 2, h1 => 2, h2 => 2, h3 => 2, h4 => 2, h5 => 2, h6 => 2,
    kbd => 2, p => 3, pre => 2, q => 2, samp => 2, span => 2, 
    strong => 2, var => 2,
    # hypertext module
    a => 3,
    # list module
    dl => 2, dt => 2, dd => 2, ol => 2, ul => 2, li => 3,
    # basic forms module
    form => 2, input => 1, label => 3, select => 2,
    option => 3, textarea => 3,
    # basic tables module
    caption => 2, table => 2, td => 2, th => 2, tr => 2,
    # image module
    img => 1,
    # object module
    object => 3, param => 1,
    # metainformation module
    meta => 1,
    # link module
    link => 1,
    # base module
    base => 1,

    ### extension modules ###
    # presentation module
    b => 2, big => 2, hr => 1, i => 2, small => 2, 
    "sub" => 2, "sup" => 2, tt => 2,

    ### legacy module ### -> depracated, do not use
    basefont => 1, center => 2, font => 2, s => 2,
    strike => 2, u => 2,

    ### not mentioned in the docs
    nobr => 2,
};



