/* Xmmsfind - A small searchplugin for the X Multimedia Player
 * Copyright (C) 2001-2002 Isak Savo <iso01001@student.mdh.se> 
 * 
 * This program is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public Licensse as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  This program is distributed in the hope
 * that it will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.  You
 * should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <ctype.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <xmms/configfile.h>
#include <xmms/xmmsctrl.h>
#include "config.h"
#include "globals.h"

_cfg_struct cfg_x;
static GtkWidget *cfg_window;
GtkWidget *cfg_chk_title, *cfg_chk_file, *cfg_chk_enqueue, *cfg_rdo_xmms_enqueue, *cfg_rdo_list_enqueue; 
GtkWidget *cfg_chk_force_rdm_off, *cfg_chk_smart_enqueue;
GtkWidget *cfg_chk_show_title, *cfg_chk_center, *cfg_chk_persistent;

void cfg_write_changes (_cfg_struct cfg_local)
{
    ConfigFile *cfgfile;
    
    if ((cfgfile = xmms_cfg_open_default_file()) != NULL)
    {
	xmms_cfg_write_boolean(cfgfile, "xmmsfind", "match_title", cfg_local.match_title);
	xmms_cfg_write_boolean(cfgfile, "xmmsfind", "match_path", cfg_local.match_path);
	xmms_cfg_write_boolean(cfgfile, "xmmsfind", "enqueue", cfg_local.enqueue);
	xmms_cfg_write_boolean(cfgfile, "xmmsfind", "xmms_enqueue", cfg_local.xmms_enqueue);
	xmms_cfg_write_boolean(cfgfile, "xmmsfind", "list_enqueue", cfg_local.list_enqueue);
	xmms_cfg_write_boolean(cfgfile, "xmmsfind", "force_rdm_off", cfg_local.force_rdm_off);
	xmms_cfg_write_boolean(cfgfile, "xmmsfind", "smart_enqueue", cfg_local.smart_enqueue);
	xmms_cfg_write_boolean(cfgfile, "xmmsfind", "show_title", cfg_local.show_title);
	xmms_cfg_write_boolean(cfgfile, "xmmsfind", "center", cfg_local.center);
	xmms_cfg_write_boolean(cfgfile, "xmmsfind", "persistent", cfg_local.persistent);
	xmms_cfg_write_int(cfgfile, "xmmsfind", "size_x", cfg_local.size_x);
	xmms_cfg_write_int(cfgfile, "xmmsfind", "size_y", cfg_local.size_y);
	xmms_cfg_write_default_file (cfgfile);
	xmms_cfg_free (cfgfile);
    }
    else
      g_warning ("xmmsfind: Unable to write changes to xmms config file!\n");
}

void exit_cfg_save_changes (GtkWidget *btn, gpointer data)
{
    
    cfg_x.match_title =   gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cfg_chk_title));
    cfg_x.match_path =    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cfg_chk_file));
    cfg_x.enqueue =       gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cfg_chk_enqueue));
    cfg_x.xmms_enqueue =  gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cfg_rdo_xmms_enqueue));
    cfg_x.list_enqueue =  gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cfg_rdo_list_enqueue));
    cfg_x.force_rdm_off = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cfg_chk_force_rdm_off));
    cfg_x.smart_enqueue = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cfg_chk_smart_enqueue));
    cfg_x.show_title =    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cfg_chk_show_title));
    cfg_x.center =    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cfg_chk_center));
    cfg_x.persistent =    gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cfg_chk_persistent));
    
    cfg_write_changes (cfg_x);
    gtk_widget_destroy (GTK_WIDGET (cfg_window));
    cfg_window = NULL;
}

void exit_cfg_discard_changes (GtkWidget *btn, gpointer data)
{
    gtk_widget_destroy (GTK_WIDGET (cfg_window));
    cfg_window = NULL;
}

void xmmsfind_do_read_config_file (void)
{
    ConfigFile *cfgfile;
    
    cfgfile = xmms_cfg_open_default_file();
    /* split out to test evey read for when options change between version */
    /* and yes, it looks ugly with all the g_prints, I'm not sure if they are useful
     * or not... maybe I'll delete em later. */
    if (!xmms_cfg_read_boolean (cfgfile, "xmmsfind", "match_title", &(cfg_x.match_title))) 
	    cfg_x.match_title = TRUE;
	if (!xmms_cfg_read_boolean (cfgfile, "xmmsfind", "match_path", &(cfg_x.match_path))) 
	    cfg_x.match_path = FALSE;
	if (!xmms_cfg_read_boolean (cfgfile, "xmmsfind", "enqueue", &(cfg_x.enqueue))) 
        cfg_x.enqueue = FALSE;
	if (!xmms_cfg_read_boolean (cfgfile, "xmmsfind", "xmms_enqueue", &(cfg_x.xmms_enqueue))) 
	    cfg_x.xmms_enqueue = TRUE;
	if (!xmms_cfg_read_boolean (cfgfile, "xmmsfind", "list_enqueue", &(cfg_x.list_enqueue)))
	    cfg_x.list_enqueue = FALSE;
	if (!xmms_cfg_read_boolean (cfgfile, "xmmsfind", "force_rdm_off", &(cfg_x.force_rdm_off)))
        cfg_x.force_rdm_off = TRUE;
	if (!xmms_cfg_read_boolean (cfgfile, "xmmsfind", "smart_enqueue", &(cfg_x.smart_enqueue))) 
	    cfg_x.smart_enqueue = FALSE;
    if (!xmms_cfg_read_boolean (cfgfile, "xmmsfind", "show_title", &(cfg_x.show_title))) 
	    cfg_x.show_title = FALSE; 
    if (!xmms_cfg_read_boolean (cfgfile, "xmmsfind", "center", &(cfg_x.center))) 
	    cfg_x.center = TRUE;
    if (!xmms_cfg_read_boolean (cfgfile, "xmmsfind", "persistent", &(cfg_x.persistent))) 
	    cfg_x.persistent = FALSE;
	if (!xmms_cfg_read_int (cfgfile, "xmmsfind", "size_x", &(cfg_x.size_x))) 
        cfg_x.size_x = 300;
	if (!xmms_cfg_read_int (cfgfile, "xmmsfind", "size_y", &(cfg_x.size_y))) 
        cfg_x.size_y = 400;
	xmms_cfg_free (cfgfile);
}

void cfg_check_list_enqueue_changed (void)
{
    gtk_widget_set_sensitive (cfg_chk_force_rdm_off, gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cfg_rdo_list_enqueue)));
    gtk_widget_set_sensitive (cfg_chk_smart_enqueue, gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cfg_rdo_list_enqueue)));
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cfg_chk_force_rdm_off), gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (cfg_rdo_list_enqueue)));
}

void xmmsfind_config (void)
{
    GtkWidget *cfg_hsep, *cfg_fr_vbox, *cfg_hbox;
    GtkWidget *cfg_frame, *cfg_main_vbox;
    GtkWidget *cfg_btn_ok, *cfg_btn_abort, *lbl;
    GtkTooltips *tip;
    
    if (cfg_window)
    {
	gtk_widget_grab_focus (cfg_window);
	return;
    }
    
    tip = gtk_tooltips_new ();
    gtk_tooltips_enable (tip);
    
    xmmsfind_do_read_config_file ();
    cfg_window = gtk_window_new (GTK_WINDOW_DIALOG);
    gtk_container_border_width (GTK_CONTAINER (cfg_window), 10);
    gtk_window_set_position (GTK_WINDOW (cfg_window), GTK_WIN_POS_CENTER);
    gtk_window_set_title (GTK_WINDOW (cfg_window), "Xmmsfind Configuration");
    gtk_signal_connect (GTK_OBJECT (cfg_window), "delete_event",
			GTK_SIGNAL_FUNC (exit_cfg_discard_changes), cfg_window);
    
    cfg_main_vbox = gtk_vbox_new (FALSE, 10);
    
    cfg_chk_title = gtk_check_button_new_with_label ("Title/Filename");
    cfg_chk_file = gtk_check_button_new_with_label ("Directory Path");
    cfg_chk_enqueue = gtk_check_button_new_with_label ("Enqueue songs by default");
    cfg_rdo_xmms_enqueue = gtk_radio_button_new_with_label (NULL, "XMMS enqueue");
    cfg_rdo_list_enqueue = gtk_radio_button_new_with_label_from_widget (GTK_RADIO_BUTTON (cfg_rdo_xmms_enqueue), "Playlist enqueue");
    cfg_chk_force_rdm_off = gtk_check_button_new_with_label ("Force random off");
    cfg_chk_smart_enqueue = gtk_check_button_new_with_label ("Use smart enqueueing"); /* FIXME: name? */
    cfg_chk_show_title = gtk_check_button_new_with_label ("Get titleinfo from xmms");
    cfg_chk_center = gtk_check_button_new_with_label ("Center the Xmmsfind window");
    cfg_chk_persistent = gtk_check_button_new_with_label ("Do not close Xmmsfind window");
    
    gtk_tooltips_set_tip (GTK_TOOLTIPS (tip), cfg_chk_title,
			 "Makes xmmsfind match its search with the titlestring and filename",
			 "The titlestring is the one got from xmms (i.e. the one you see in the playlist)");
    gtk_tooltips_set_tip (GTK_TOOLTIPS (tip), cfg_chk_file,
			 "Makes xmmsfind match its search with the directory path",
			 "The directory is the entire path to the file (i.e. '/usr/mp3/rock/')");
    gtk_tooltips_set_tip (GTK_TOOLTIPS (tip), cfg_chk_enqueue,
			 "Will force xmmsfind to enqueue the file, rather than jumping to it.",
			 "Enqueuing a file will set it to be played next, rather than immediatly.");
    gtk_tooltips_set_tip (GTK_TOOLTIPS (tip), cfg_rdo_xmms_enqueue,
                         "Makes xmmsfind use XMMS's built-in enqueue system and does not edit the actual playlist.",
			 "This feature allows you to queue songs without editing your playlist and still works with random mode on.");
    gtk_tooltips_set_tip (GTK_TOOLTIPS (tip), cfg_rdo_list_enqueue,
			 "Will force xmmsfind to move the file to the position after the currently playing, editing the playlist.",
			 "Enqueuing a file will make xmmsfind move it to the song position after the one that is currently being played.");
    gtk_tooltips_set_tip (GTK_TOOLTIPS (tip), cfg_chk_force_rdm_off,
			 "When enqueueing file, turn off random (shuffle) mode if its on.",
			 "You should probably use this if you want to enqueue by default since enqueueing wont work otherwise");
    gtk_tooltips_set_tip (GTK_TOOLTIPS (tip), cfg_chk_smart_enqueue,
			 "Will add an offset to the enqueue so that the next song enqueued will be moved after the previous one",
			 "This is useful if you usually enqueues more than one song at time and you wish for them to appear in the order you enqueued them.");
    gtk_tooltips_set_tip (GTK_TOOLTIPS (tip), cfg_chk_show_title,
			 "Tells xmmsfind to query xmms for the titlestring. With this option enabled to speed up xmmsfind set 'Read info on' to 'load' in the xmms preferences dialog under options.",
			 "If selected, then the string shown in the searchbox will be tha basename of the file");
    gtk_tooltips_set_tip (GTK_TOOLTIPS (tip), cfg_chk_center,
			"This will make the Xmmsfind window pop up in the center of the screen.",
			"Disabling this will allow the window manager to choose a location.");
    gtk_tooltips_set_tip (GTK_TOOLTIPS (tip), cfg_chk_persistent,
			 "This will make the Xmmsfind window stay open after a song has been changed",
			 "This is useful if you want to use xmmsfind as a complement to the ordinary playlist");
        
    lbl = gtk_label_new ("Match search by:");
    cfg_frame = gtk_frame_new (NULL);
    cfg_fr_vbox = gtk_vbox_new (FALSE, 2);
    gtk_box_pack_start (GTK_BOX (cfg_fr_vbox), lbl, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (cfg_fr_vbox), cfg_chk_title, FALSE, FALSE, 0);
    gtk_box_pack_start (GTK_BOX (cfg_fr_vbox), cfg_chk_file, FALSE, FALSE, 0);

    cfg_hsep = gtk_hseparator_new ();
    lbl = gtk_label_new ("Misc:");
    gtk_box_pack_end (GTK_BOX (cfg_fr_vbox), cfg_chk_persistent, FALSE, FALSE, 0);
    gtk_box_pack_end (GTK_BOX (cfg_fr_vbox), cfg_chk_center, FALSE, FALSE, 0);
    gtk_box_pack_end (GTK_BOX (cfg_fr_vbox), lbl, FALSE, FALSE, 0);
    gtk_box_pack_end (GTK_BOX (cfg_fr_vbox), cfg_hsep, FALSE, FALSE, 0);


    cfg_hsep = gtk_hseparator_new ();
    lbl = gtk_label_new ("Speed ups:");
    gtk_box_pack_end (GTK_BOX (cfg_fr_vbox), cfg_chk_show_title, FALSE, FALSE, 0);
    gtk_box_pack_end (GTK_BOX (cfg_fr_vbox), lbl, FALSE, FALSE, 0);
    gtk_box_pack_end (GTK_BOX (cfg_fr_vbox), cfg_hsep, FALSE, FALSE, 0);
    
    cfg_hsep = gtk_hseparator_new ();
    lbl = gtk_label_new ("Enqueuing:");
    gtk_box_pack_end (GTK_BOX (cfg_fr_vbox), cfg_chk_smart_enqueue, FALSE, FALSE, 0);
    gtk_box_pack_end (GTK_BOX (cfg_fr_vbox), cfg_chk_force_rdm_off, FALSE, FALSE, 0);
    gtk_box_pack_end (GTK_BOX (cfg_fr_vbox), cfg_rdo_list_enqueue, FALSE, FALSE, 0);
    gtk_box_pack_end (GTK_BOX (cfg_fr_vbox), cfg_rdo_xmms_enqueue, FALSE, FALSE, 0);
    gtk_box_pack_end (GTK_BOX (cfg_fr_vbox), cfg_chk_enqueue, FALSE, FALSE, 0);
    gtk_box_pack_end (GTK_BOX (cfg_fr_vbox), lbl, FALSE, FALSE, 0);
    gtk_box_pack_end (GTK_BOX (cfg_fr_vbox), cfg_hsep, FALSE, FALSE, 0);
    
    /* Set the togglebuttons to the state last saved */
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cfg_chk_title), cfg_x.match_title);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cfg_chk_file), cfg_x.match_path);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cfg_chk_enqueue), cfg_x.enqueue);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cfg_rdo_xmms_enqueue), cfg_x.xmms_enqueue);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cfg_rdo_list_enqueue), cfg_x.list_enqueue);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cfg_chk_force_rdm_off), cfg_x.force_rdm_off);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cfg_chk_smart_enqueue), cfg_x.smart_enqueue);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cfg_chk_show_title), cfg_x.show_title);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cfg_chk_center), cfg_x.center);
    gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (cfg_chk_persistent), cfg_x.persistent);

    gtk_signal_connect (GTK_OBJECT (cfg_rdo_xmms_enqueue), "clicked", GTK_SIGNAL_FUNC (cfg_check_list_enqueue_changed), NULL);
    gtk_signal_connect (GTK_OBJECT (cfg_rdo_list_enqueue), "clicked", GTK_SIGNAL_FUNC (cfg_check_list_enqueue_changed), NULL);
    gtk_widget_set_sensitive (cfg_chk_force_rdm_off, cfg_x.list_enqueue);	/* Only clickable if cfg_chk_list_enqueue is toggled */
    gtk_widget_set_sensitive (cfg_chk_smart_enqueue, cfg_x.list_enqueue);
    
    gtk_container_add (GTK_CONTAINER (cfg_frame), cfg_fr_vbox);
    
    cfg_btn_ok = gtk_button_new_with_label ("Ok");
    cfg_btn_abort = gtk_button_new_with_label ("Cancel");

    gtk_signal_connect (GTK_OBJECT (cfg_btn_ok), "clicked", GTK_SIGNAL_FUNC (exit_cfg_save_changes), cfg_window);
    gtk_signal_connect (GTK_OBJECT (cfg_btn_abort), "clicked", GTK_SIGNAL_FUNC (exit_cfg_discard_changes), cfg_window);
    
    cfg_hbox = gtk_hbox_new (TRUE, 10);
    
    gtk_box_pack_start (GTK_BOX (cfg_hbox), cfg_btn_ok, FALSE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (cfg_hbox), cfg_btn_abort, FALSE, TRUE, 0);
    
    gtk_box_pack_start (GTK_BOX (cfg_main_vbox), cfg_frame, TRUE, TRUE, 5);
    gtk_box_pack_start (GTK_BOX (cfg_main_vbox), cfg_hbox, FALSE, FALSE, 0);
    
    gtk_container_add (GTK_CONTAINER (cfg_window), cfg_main_vbox);
    
    gtk_widget_show_all (cfg_window);
}

