#ifndef SONGLYRICS_H
#define SONGLYRICS_H

#include <qsplitter.h>

#include <qvbox.h> 
#include <qhttp.h> 
#include <qnetwork.h> 
#include <qstring.h> 
#include <qlistbox.h>
#include <qlineedit.h>
#include <qtextedit.h>
#include <qtextstream.h>
#include <qregexp.h>
#include <qurl.h>
#include <qxml.h>
#include <qfile.h>
#include <qdir.h>
#include <qprogressbar.h>
#include <qtimer.h>
#include <qpoint.h>
#include <qsize.h> 
#include <qmutex.h> 

#include <kconfig.h>
#include <klocale.h>
#include <kstandarddirs.h>

#include <vector>

#include "parser.h"
#include "lyricsentry.h"

class Request {

 public:
  Request(int i) {
    id = i;
  }

  Request(int i, Parser *p, QHttp *h) {
    id = i;
    parser = p;
    http = h;
  }

  int id;
  QString contents;
  Parser *parser;
  QHttp *http;
};

class RequestList : public QPtrList<Request> {

 public:

  virtual int compareItems(QPtrCollection::Item item1, 
			   QPtrCollection::Item item2) {

    int i1 = ((Request *) item1)->id;
    int i2 = ((Request *) item2)->id;

    if (i1 == -1 && i2 == -1)
      return 1;
    
    if (i1 == i2)
      return 0;

    return 1;
  }
};


class SongLyrics : public QSplitter {

  Q_OBJECT
    
public:
  
  SongLyrics(KConfig *conf);  
  ~SongLyrics();

  int request(QString artist, QString title);
  void writeConfig();

signals:

public slots:

private slots:
  int selected(int index);
  void progress();
 
  void searchRequestStarted(int id);
  void searchRequestFinished(int id, bool error);

  void getRequestStarted(int id);
  void getRequestFinished(int id, bool error);
  void markup(const QString & text);

private: 
 
  void requestWeb(QString artist, QString title);
  void setText(QString text);
  QString getPathName(QString artist, QString title);
  QString getFileName(QString artist, QString title);

  /*
  QHttp *searchHttp; 
  QHttp *getHttp; 
  */

  int mode;
  int searchRequestID;
  int getRequestID;
  
  QListBox *box;
  QTextEdit *edit;
  QLineEdit *search;
  QString *currentText;

  QProgressBar *bar;
  
  QTimer *timer;
  int prog;
  
  QPoint framePos;
  QSize frameSize;
  
  KConfig *config;

  Entry *entry;

  RequestList requests;
};

#endif
