
/* Type */
#define CFG_LAST       0	/* last table entry              */
#define CFG_BOOL       1	/* value is a int (yes/no)       */
#define CFG_INT        2	/* value is a int                */
#define CFG_STRING     3	/* value is a char*              */
#define CFG_CALLBACK   4	/* call a function for this one  */
#define CFG_TYPEMASK  15
/* Flags */
#define CFG_RDONLY    16	/* don't write back this one     */

struct CONFIG_FILE {
    int             what;	/* type & flags */
    char           *tag;	/* tag name */
    void           *data;	/* where to read/write data */
    void            (*cb) (char *);	/* callback function */
    int             low, high;	/* int: range for walid values */
    int             flag;	/* flag for internal use */
};

void            config_read(char *own, char *all, struct CONFIG_FILE *cfg);
void            config_write(char *own, char *all, struct CONFIG_FILE *cfg);
