/* toon_draw.c - draw and erase the toons 
 * Copyright (C) 1999-2001  Robin Hogan
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "toon.h"
#include <stdio.h>
/* DRAWING FUNCTIONS */

/* Draw the toons from toon[0] to toon[n-1] */
/* Currently always returns 0 */
int
ToonDraw(Toon *toon, int n)
{
  int width,height,i;
  for (i=0;i<n;i++) {
    Toon *t = toon+i;
    if (t->active) {
      ToonData *data = toon_data[t->genus] + t->type;
      int direction = t->direction;
      if (direction >= data->ndirections) {
	direction = 0;
      }

      width = data->width;
      height = data->height;

      XSetClipOrigin(toon_display, toon_drawGC,
		     t->x-width*t->frame, t->y-height*direction); 
      XSetClipMask(toon_display, toon_drawGC, data->mask);   
      XCopyArea(toon_display, data->pixmap,
		toon_root,toon_drawGC,width*t->frame,height*direction,
		width,height,t->x,t->y);
      XSetClipMask(toon_display, toon_drawGC, None);
      t->x_map = t->x;
      t->y_map = t->y;
      t->width_map = width;
      t->height_map = height;
    }
  }
  return 0;
}

/* Erase toons toon[0] to toon[n-1] */
/* Currently always returns 0 */
int
ToonErase(Toon *toon,int n)
{
  int i;
  Toon *t;
  for (i=0;i<n;i++) {
    t=toon+i;
    XClearArea(toon_display, toon_root, t->x_map, t->y_map,
    	       t->width_map, t->height_map, False);
  }
  return 0;
}

/* Send any buffered X calls immediately */
void
ToonFlush()
{
  XFlush(toon_display);
  return;
}
