/*

    xpuyopuyo - pinfo.c       Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org     http://chaos2.org/
    
    Usage information
    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include <sys/stat.h>
#include <unistd.h>
#include <config.h>
#include <xpuyopuyo.h>
#include <pconfig.h>
#include <pconfigm.h>
#include <pinfo.h>
#include <pwindow.h>
#include <pplayer.h>



int p_usage(const char *progname) {
/* usage */
   
   /* This function pretty much documents itself :) */
   
   printf("%s [options]\n", progname);
   
   printf("\nOPTIONS:\n");
   printf("   A short toggle option may be preceded by \"/\" to turn off the option.\n");
   printf("   Long toggle options may be preceded by \"no\" to turn off the option.\n");
   printf("\nGENERAL OPTIONS:\n");
   printf("   -h, --help         Displays this help.\n");
   printf("   --insanity         If you have to ask ...\n");
   printf("\n");
   printf("   -1, --oneplayer    Select one player game.  No rocks in this version.\n");
   printf("   -2, --twoplayer    Select two player game, human versus human.\n");
   printf("   -a, --aiplayer     Select two player game, human versus computer.\n");
   printf("   -d, --demo         Select two player game, computer versus computer.\n");
   printf("\n");
   printf("   -e, --easy         Easy gameplay. Enables options for easier gameplay.\n");
   printf("   -m, --medium       Medium gameplay. Enables more difficult round.\n");
   printf("   -H, --hard         Hard gameplay. Enables most difficult of gameplay\n");
   printf("\n");
   printf("   -n, --number=n     Number of different color blocks,  %d<n=%d<%d\n", P_COLORS_MIN, P_COLORS_DEF, P_COLORS_MAX); 
   printf("   -t, --restart      Automatically restart after a \"Game Over\" (toggle).\n");
   printf("   -T, --tutorial     Used with -1 or -a, enable AI assistance (toggle).\n");
   printf("\n");
   printf("   --theme name       Load the selected theme\n");
   printf("   --tooltips         Enable tooltips if set\n");

   #if USE_SOUND
      printf("\nSOUND OPTIONS:\n");
      printf("   -S, --sound        Enable music and sound effects (toggle).\n");
      printf("   -/S, --nosound     Disable music and sound effects.\n");
      printf("   --hqmixer          Mix sound using the high-quality mixer.\n");
      printf("   --nohqmixer        Do not mix sound using the high-quality mixer.\n");
      printf("   --effects          Enable sound effects (toggle).\n");
      printf("   --noeffects        Disable the sound effects.\n");
   #endif /* Sound? */

   printf("\nADVANCED OPTIONS:\n");
   printf("   --width=n          Set width of the playing field.\n");
   printf("   --height=n         Set height of the playing field.\n");
   printf("   --match=n          Number of same-color required to match\n");
   printf("   -U, --nullify      Your rocks may nullify opponent's (toggle)\n");
   printf("   -/U, --nonullify   Your rocks may not nullify opponent's\n");
   printf("   -I, --indestructibles    Indestructibles allowed (toggle).\n");
   printf("   -/I, --noindestructibles Indestructibles not allowed.\n");
 
   printf("\nPLAYER OPTIONS:\n");
   printf("   -s, --speed=n      Selects speed for blocks to fall in ms.  %d<n=%d\n", P_MINDROP_TIME, P_DROP_TIME);
   printf("   -A, --accel=dec    Acceleration in %c time lost per minute\n", '%');

   printf("\nAI OPTIONS:\n");
   printf("   -r, --airule2=n    Selects an AI rule for the right AI player.\n");
   printf("   -R, --airule1=n    Selects an AI rule for the left AI player.\n");
   printf("   -r random, --airule2=random    Select a random AI rule for left player.\n");
   printf("   -R, --airule1=n    Selects an AI rule for the right AI player.\n");
   printf("   -R random, --airule1=random    Select a random AI rule for right player.\n");
   printf("   -c, --aiscore      Display AI score instead of AI's next piece (toggle).\n");
   printf("   -/c, --noaiscore   Display AI's next piece.\n");
   printf("   -i, --aidrop       AI can drop pieces when the human drops pieces (toggle).\n");
   printf("   -/i, --noaidrop    AI cannot drop pieces when the human drops pieces.\n");

   #if USE_NETWORK
      printf("\nNETWORK OPTIONS:\n");
      printf("   --server           Start as a new server.\n");
      printf("   --client=hostname  Connect to hostname specified.\n");
      printf("   --port=n           Listen to/connect to the port number specified.\n");
      printf("   --networkai        Allow AI in network game (toggle).\n");
      printf("   --nonetworkai      Do not allow AI in network game (always the default).\n");
   #endif

   #if P_ALLOW_TOURNAMENT
      printf("\nTOURNAMENT OPTIONS:\n");
      printf("   -z, --tournament   AI's play in tournament mode.\n");
      printf("   -Z, --hypertournament  AI's play very fast; tournament repeat.\n");
      printf("   -Y                 Do not use (debugging flag).\n");
   #endif

   return(1);

}



int p_susage(const char *progname) {
/* susage */
   
   /* This function pretty much documents itself :) */
   
   printf("%s [options]\n", progname);
   printf("   -h, --help         for complete help\n");

   return(1);

}



void p_info(void) {
/* Info */

   printf("XPuyoPuyo!  Version %s\n", VERSION);
   printf("Code copyright(c) 1999,2000 Justin David Smith\n");
   printf("Images copyright(c) 1999,2000 Owen Aftreth, Denny Mingus, Brett Smith, and Andrew Carpenter\n");
   printf("Original GTK code copyright(c) 1999 Havoc Pennington\n");
   printf("Music copyright(c) 2000 theGREENzebra (tgz@orotech.net)\n");
   printf("This software is available under the GNU General Public License.\n");
   return;

}



void p_statistics(pconfig *c) {

   pplayer *p;
   int i;
   int j;
   int a;
   int b;

   for(i = 0; i < P_NUM_PLAYERS; i++) {
      p = P_PLAYER(c, i);
      if(p->state != P_STATE_DISABLED) {
         if(!c->quiet) {
            printf("Player %i (%s) (%s):\n", i + 1, p->state == P_STATE_WINNER ? "winner" : "loser", p->name);
            printf("   pieces=%-4d   Score=%6d  \n", p->f_pieces, p->score);
            printf("   rocks recv'd=%-4d, sent=%-4d\n", p->f_rkrecv, p->f_rksent);
            if(p->f_pieces > 0) printf("   recv/piece=%3d%c    sent/piece=%3d%c\n", p->f_rkrecv * 100 / p->f_pieces, '%', p->f_rksent * 100 / p->f_pieces, '%');
            printf("   at_once=");
            for(j = 0; j < P_PLAYER_NUM_CLUMPS; j++) printf("%d ", p->num_clumps[j]);
            printf("\n");
            a = p->f_pieces;
            b = p->f_rksent;
            printf("   survival=%4d  rocks sent=%4d\n", a, b);
         }
         if((j = p_high_score_add(c->high, p)) >= 0 && !c->quiet) {
            printf("  **  New high score!  Name %s, ranking %d, score %d\n", p->name, j + 1, p->score);
         }
         if(!c->quiet) printf("\n");
      }
   }
   
}


