/*

    xpuyopuyo - pfile.h       Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org     http://chaos2.org/
    
    Utilities for FILE I/O
    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __pfile_h_included
#define __pfile_h_included


#include <stdlib.h>
#include <stdio.h>


#define P_IO_BUFFER     0x4000


char *p_file_break(char *s, char k);
char *p_local_file_name(char *filename, const char *base, int size);
char *p_local_theme_file_name(char *filename, const char *base, int size);
char *p_merge_path_base(char *filename, const char *path, const char *base, int size);
FILE *p_file_open(const char *filename, const char *flag);
#define p_file_open_read(filename)     p_file_open((filename), "r")
#define p_file_open_write(filename)    p_file_open((filename), "w")
char *p_file_read_line(char *buf, int size, FILE *f);
void p_make_config_dir(void);


#endif /* __pfile_h_included */
