# file      : build/xsde/parser/xsd-cxx.make
# author    : Boris Kolpackov <boris@codesynthesis.com>
# copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
# license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#@@ Need to use extensions from cxx config.
#

$(call include,$(scf_root)/configuration.make)

ifeq ($(xsd_pskel_suffix),)
xsd_pskel_suffix := -pskel
endif

xsd_parser_pattern :=                \
$(out_base)/%$(xsd_pskel_suffix).cxx \
$(out_base)/%$(xsd_pskel_suffix).hxx \
$(out_base)/%$(xsd_pskel_suffix).ixx

ifneq ($(xsd_pimpl_suffix),)
xsd_parser_pattern +=                \
$(out_base)/%$(xsd_pimpl_suffix).cxx \
$(out_base)/%$(xsd_pimpl_suffix).hxx \
$(out_base)/%-driver.cxx
endif

$(xsd_parser_pattern): xsde := xsde
$(xsd_parser_pattern): xsde_command := cxx-parser
$(xsd_parser_pattern): xsde_options := --skel-file-suffix $(xsd_pskel_suffix)

# Can't use += here.
#
ifneq ($(xsd_pimpl_suffix),)
$(xsd_parser_pattern): xsde_options := $(xsde_options) --impl-file-suffix $(xsd_pimpl_suffix)
endif

ifeq ($(xsde_stl),n)
$(xsd_parser_pattern): xsde_options += --no-stl
endif

ifeq ($(xsde_iostream),n)
$(xsd_parser_pattern): xsde_options += --no-iostream
endif

ifeq ($(xsde_exceptions),n)
$(xsd_parser_pattern): xsde_options += --no-exceptions
endif

ifeq ($(xsde_longlong),n)
$(xsd_parser_pattern): xsde_options += --no-long-long
endif

ifeq ($(xsde_validation_parser),n)
$(xsd_parser_pattern): xsde_options += --suppress-validation
endif

.PRECIOUS: $(xsd_parser_pattern)

$(xsd_parser_pattern): $(out_base)/%.xsd | $$(dir $$@).
	$(call message,xsde $<,$(xsde) $(xsde_command) $(xsde_options) --output-dir $(dir $@) $<)

ifneq ($(out_base),$(src_base))

$(xsd_parser_pattern): $(src_base)/%.xsd | $$(dir $$@).
	$(call message,xsde $<,$(xsde) $(xsde_command) $(xsde_options) --output-dir $(dir $@) $<)

endif


.PHONY: $(out_base)/%$(xsd_pskel_suffix).cxx.xsd.clean

$(out_base)/%$(xsd_pskel_suffix).cxx.xsd.clean:
	$(call message,rm $(@:.cxx.xsd.clean=.cxx),rm -f $(@:.cxx.xsd.clean=.cxx))
	$(call message,rm $(@:.cxx.xsd.clean=.hxx),rm -f $(@:.cxx.xsd.clean=.hxx))
	$(call message,rm $(@:.cxx.xsd.clean=.ixx),rm -f $(@:.cxx.xsd.clean=.ixx))

ifneq ($(xsd_pimpl_suffix),)
.PHONY: $(out_base)/%$(xsd_pimpl_suffix).cxx.xsd.clean

$(out_base)/%$(xsd_pimpl_suffix).cxx.xsd.clean:
	$(call message,rm $$1,rm -f $$1,$(@:.cxx.xsd.clean=.cxx))
	$(call message,rm $$1,rm -f $$1,$(@:.cxx.xsd.clean=.hxx))
	$(call message,rm $$1,rm -f $$1,$(out_base)/$*-driver.cxx)
endif

# Reset the config variables so they won't take effect in other places.
#
xsd_pskel_suffix :=
xsd_pimpl_suffix :=
