// file      : examples/cxx/serializer/mixin/driver.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : not copyrighted - public domain

#include <iostream>

#include "types.hxx"
#include "schema-sskel.hxx"

using namespace std;

struct base_simpl: virtual base_sskel
{
  virtual void
  pre (const base& b)
  {
    base_ = &b;
  }

  virtual bool
  a ()
  {
    return base_->a ();
  }

protected:
  const base* base_;
};

// Implement derived serializer by mixing-in base's implementation.
//
struct derived_simpl: virtual derived_sskel, base_simpl
{
  virtual void
  pre (const derived& d)
  {
    // Call base::pre
    //
    base_simpl::pre (d);
  }

  virtual int
  b ()
  {
    // We could also store a pointer to derived in derived_simpl to
    // avoid casting.
    //
    return static_cast<const derived*> (base_)->b ();
  }
};

int
main ()
{
  try
  {
    // Construct the serializer.
    //
    xml_schema::boolean_simpl bool_s;
    xml_schema::int_simpl int_s;
    derived_simpl derived_s;

    derived_s.serializers (bool_s, int_s);

    xml_schema::document_simpl doc_s (derived_s, "root");

    derived d;
    d.a (true);
    d.b (1);

    derived_s.pre (d);
    doc_s.serialize (cout);
    derived_s.post ();
  }
  catch (const xml_schema::serializer_exception& e)
  {
    cerr << "error: " << e.text () << endl;
    return 1;
  }
  catch (const std::ios_base::failure&)
  {
    cerr << "error: write failure" << endl;
    return 1;
  }

  return 0;
}
