// file      : xsde/cxx/serializer/validating/idrefs-stl.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <xsde/cxx/pre.hxx>

#include <xsde/cxx/serializer/validating/idrefs-stl.hxx>

namespace xsde
{
  namespace cxx
  {
    namespace serializer
    {
      namespace validating
      {
        void idrefs_simpl::
        pre (const string_sequence& value)
        {
          value_ = value;
        }

        void idrefs_simpl::
        _serialize_content ()
        {
          // Make sure we don't hold any references to the strings.
          //
          string_sequence tmp;
          tmp.swap (value_);

          // Should have at least one element.
          //
          if (!tmp.empty ())
          {
            bool first = true;
            context& ctx = _context ();

            for (string_sequence::const_iterator i (tmp.begin ()),
                   e (tmp.end ()); i != e; ++i)
            {
              serializer_.pre (*i);

#ifndef XSDE_EXCEPTIONS
              if (serializer_._error_type ())
                serializer_._copy_error (ctx);

              if (ctx.error_type ())
                break;
#endif

              if (!first)
              {
#ifdef XSDE_EXCEPTIONS
                _characters (" ", 1);
#else
                if (!_characters (" ", 1))
                  break;
#endif
              }
              else
                first = false;

              serializer_._pre_impl (ctx);

              if (ctx.error_type ())
                break;

              serializer_._serialize_content ();

              if (ctx.error_type ())
                break;

              serializer_._post_impl ();

              if (ctx.error_type ())
                break;

              serializer_.post ();

#ifndef XSDE_EXCEPTIONS
              if (serializer_._error_type ())
                serializer_._copy_error (ctx);

              if (ctx.error_type ())
                break;
#endif
            }
          }
          else
            _schema_error (schema_error::invalid_idrefs_value);
        }
      }
    }
  }
}

#include <xsde/cxx/post.hxx>
