// file      : xsde/cxx/parser/parser-source.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2007 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <cxx/parser/parser-source.hxx>

#include <xsd-frontend/semantic-graph.hxx>
#include <xsd-frontend/traversal.hxx>

namespace CXX
{
  namespace Parser
  {
    namespace
    {
      struct Enumeration: Traversal::Enumeration,
                          protected virtual Context
      {
        Enumeration (Context& c)
            : Context (c)
        {
        }

        virtual Void
        traverse (Type& e)
        {
          String const& ret (ret_type (e));

          SemanticGraph::Type& base (e.inherits ().base ());

          Boolean same (ret == ret_type (base));

          if (same || ret == L"void")
          {
            String const& name (ename (e));

            os << "// " << name << endl
               << "//" << endl
               << endl;

            os << ret << " " << name << "::" << endl
               << post_name (e) << " ()"
               << "{";

            if (same)
            {
              if (ret == L"void")
                os << post_name (base) << " ();";
              else
                os << "return " << post_name (base) << " ();";
            }

            os << "}";
          }
        }
      };

      //
      //
      struct List: Traversal::List, protected virtual Context
      {
        List (Context& c)
            : Context (c)
        {
        }

        virtual Void
        traverse (Type& l)
        {
          String const& name (ename (l));
          SemanticGraph::Type& t (l.argumented ().type ());

          String item (unclash (name, "item"));

          os << "// " << name << endl
             << "//" << endl
             << endl;

          // item
          //
          String const& arg (arg_type (t));

          os << "void " << name << "::" << endl
             << item;

          if (arg == L"void")
            os << " ()";
          else
            os << " (" << arg << ")";

          os << "{"
             << "}";

          // post
          //
          if (ret_type (l) == L"void")
            os << "void " << name << "::" << endl
               << post_name (l) << " ()"
               << "{"
               << "}";

          // parse_item
          //
          String inst (L"_xsde_" + item + L"_");
          String const& post (post_name (t));

          os << "void " << name << "::" << endl
             << "_xsde_parse_item (const " << string_type << "& v)"
             << "{"
             << "if (this->" << inst << ")"
             << "{";

          // This implementation should work for both validating
          // and non-validating cases.
          //
          if (!exceptions || validation)
          {
            String const& ret (ret_type (t));

            os << "this->" << inst << "->pre ();"
               << "if (!this->" << inst << "->_error_p ())" << endl
               << "this->" << inst << "->_pre_impl ();"
               << "if (!this->" << inst << "->_error_p ())" << endl
               << "this->" << inst << "->_characters (v);"
               << "if (!this->" << inst << "->_error_p ())" << endl
               << "this->" << inst << "->_post_impl ();"
               << "if (!this->" << inst << "->_error_p ())" << endl;

            if (ret == L"void")
              os << "this->" << inst << "->" << post << " ();"
                 << endl;
            else
              os << "{"
                 << arg_type (t) << " tmp = this->" << inst << "->" <<
                post << " ();"
                 << endl;

            os << "if (!this->" << inst << "->_error_p ())" << endl;

            if (ret == L"void")
              os << "this->" << item << " ();"
                 << endl;
            else
              os << "this->" << item << " (tmp);"
                 << "}";

            os << "if (this->" << inst << "->_error_p ())" << endl
               << "this->_copy_error (this->" << inst << ");";
          }
          else
          {
            os << "this->" << inst << "->pre ();"
               << "this->" << inst << "->_pre_impl ();"
               << "this->" << inst << "->_characters (v);"
               << "this->" << inst << "->_post_impl ();";

            if (ret_type (t) == L"void")
              os << "this->" << inst << "->" << post << " ();"
                 << "this->" << item << " ();";
            else
              os << "this->" << item << " (this->" << inst << "->" <<
                post << " ());";
          }

          os << "}"
             << "}";
        }
      };


      //
      //
      struct Union: Traversal::Union, protected virtual Context
      {
        Union (Context& c)
            : Context (c)
        {
        }

        virtual Void
        traverse (Type& u)
        {
          if (ret_type (u) == L"void")
          {
            String const& name (ename (u));

            os << "// " << name << endl
               << "//" << endl
               << endl;

            os << "void " << name << "::" << endl
               << post_name (u) << " ()"
               << "{"
               << "}";
          }
        }
      };


      //
      //
      struct StartElement : Traversal::Element,
                            protected virtual Context
      {
        StartElement (Context& c)
            : Context (c)
        {
        }

        virtual Void
        traverse (Type& e)
        {
          String const& name (ename (e));
          String const& inst (emember (e));

          if (e.qualified ())
          {
            os << "if (n == " << L << "\"" << e.name () << "\" && " <<
              "ns == " << L << "\"" << e.namespace_ ().name () << "\")"
               << "{";
          }
          else
          {
            os << "if (n == " << L << "\"" << e.name () << "\" && ns.empty ())"
               << "{";
          }

          os << "this->complex_content::context_.top ().parser_ = " <<
            "this->" << inst << ";"
             << endl
             << "if (this->" << inst << ")"
             << "{"
             << "this->" << inst << "->pre ();"; // _start_element calls _pre

          if (!exceptions)
            os << "if (this->" << inst << "->_error_p ())" << endl
               << "this->_copy_error (this->" << inst<< ");";

          os << "}"
             << "return true;"
             << "}";
        }
      };


      //
      //
      struct EndElement : Traversal::Element,
                          protected virtual Context
      {
        EndElement (Context& c)
            : Context (c)
        {
        }

        virtual Void
        traverse (Type& e)
        {
          String const& name (ename (e));
          String const& inst (emember (e));

          if (e.qualified ())
          {
            os << "if (n == " << L << "\"" << e.name () << "\" && " <<
              "ns == " << L << "\"" << e.namespace_ ().name () << "\")"
               << "{";
          }
          else
          {
            os << "if (n == " << L << "\"" << e.name () << "\" && ns.empty ())"
               << "{";
          }

          // _end_element calls post
          //

          SemanticGraph::Type& type (e.type ());
          String const& post (post_name (type));

          os << "if (this->" << inst << ")"
             << "{";

          if (exceptions)
          {
            if (ret_type (type) == L"void")
              os << "this->" << inst << "->" << post << " ();"
                 << "this->" << name << " ();";
            else
              os << "this->" << name << " (this->" << inst << "->" <<
                post << " ());";
          }
          else
          {
            if (ret_type (type) == L"void")
            {
              os << "this->" << inst << "->" << post << " ();"
                 << "if (this->" << inst << "->_error_p ())" << endl
                 << "this->_copy_error (this->" << inst << ");"
                 << "else" << endl
                 << "this->" << name << " ();";
            }
            else
            {
              os << arg_type (type) << " tmp = this->" << inst << "->" <<
                post << " ();"
                 << "if (this->" << inst << "->_error_p ())" << endl
                 << "this->_copy_error (this->" << inst << ");"
                 << "else" << endl
                 << "this->" << name << " (tmp);";
            }
          }

          os << "}"
             << "return true;"
             << "}";
        }
      };


      //
      //
      struct Attribute : Traversal::Attribute,
                         protected virtual Context
      {
        Attribute (Context& c)
            : Context (c)
        {
        }

        virtual Void
        traverse (Type& a)
        {
          String const& name (ename (a));
          String const& inst (emember (a));

          if (a.qualified ())
          {
            os << "if (n == " << L << "\"" << a.name () << "\" && " <<
              "ns == " << L << "\"" << a.namespace_ ().name () << "\")"
               << "{";
          }
          else
          {
            os << "if (n == " << L << "\"" << a.name () << "\" && ns.empty ())"
               << "{";
          }

          SemanticGraph::Type& type (a.type ());
          String const& post (post_name (type));
          String const& ret (ret_type (type));

          os << "if (this->" << inst << ")"
             << "{";

          if (exceptions)
          {
            os << "this->" << inst << "->pre ();"
               << "this->" << inst << "->_pre_impl ();"
               << "this->" << inst << "->_characters (v);"
               << "this->" << inst << "->_post_impl ();";

            if (ret == L"void")
              os << "this->" << inst << "->" << post << " ();"
                 << "this->" << name << " ();";
            else
              os << "this->" << name << " (this->" << inst << "->" <<
                post << " ());";
          }
          else
          {
            os << "this->" << inst << "->pre ();"
               << "if (!this->" << inst << "->_error_p ())" << endl
               << "this->" << inst << "->_pre_impl ();"
               << "if (!this->" << inst << "->_error_p ())" << endl
               << "this->" << inst << "->_characters (v);"
               << "if (!this->" << inst << "->_error_p ())" << endl
               << "this->" << inst << "->_post_impl ();";


            if (ret == L"void")
              os << "if (!this->" << inst << "->_error_p ())" << endl
                 << "this->" << inst << "->" << post << " ();"
                 << "if (!this->" << inst << "->_error_p ())" << endl
                 << "this->" << name << " ();";
            else
              os << "if (!this->" << inst << "->_error_p ())" << endl
                 << "{"
                 << arg_type (type) << " tmp = this->" << inst << "->" <<
                post << " ();"
                 << "if (!this->" << inst << "->_error_p ())" << endl
                 << "this->" << name << " (tmp);"
                 << "}";

              os << "if (this->" << inst << "->_error_p ())" << endl
                 << "this->_copy_error (this->" << inst << ");";
          }

          os << "}"
             << "return true;"
             << "}";
        }
      };


      // Callbacks.
      //
      struct ParticleCallback: Traversal::Element,
                               protected virtual Context
      {
        ParticleCallback (Context& c)
            : Context (c)
        {
        }

        virtual Void
        traverse (SemanticGraph::Element& e)
        {
          String const& arg (arg_type (e.type ()));

          os << "void " << ename (e.scope ()) << "::" << endl
             << ename (e);

          if (arg == L"void")
            os << " ()";
          else
            os << " (" << arg << ")";

          os << "{"
             << "}";
        }
      };

      struct AttributeCallback: Traversal::Attribute,
                                protected virtual Context
      {
        AttributeCallback (Context& c)
            : Context (c)
        {
        }

        virtual Void
        traverse (SemanticGraph::Attribute& a)
        {
          String const& arg (arg_type (a.type ()));

          os << "void " << ename (a.scope ()) << "::" << endl
             << ename (a);

          if (arg == L"void")
            os << " ()";
          else
            os << " (" << arg << ")";

          os << "{"
             << "}";
        }
      };

      //
      //
      struct Complex : Traversal::Complex,
                       protected virtual Context
      {
        Complex (Context& c)
            : Context (c),
              particle_callback_ (c),
              attribute_callback_ (c),
              start_element_ (c),
              end_element_ (c),
              attribute_ (c)
        {
          // Callback.
          //
          contains_compositor_callback_ >> compositor_callback_;
          compositor_callback_ >> contains_particle_callback_;
          contains_particle_callback_ >> compositor_callback_;
          contains_particle_callback_ >> particle_callback_;

          names_attribute_callback_ >> attribute_callback_;

          //
          //
          contains_compositor_start_ >> start_compositor_;
          start_compositor_ >> contains_particle_start_;
          contains_particle_start_ >> start_compositor_;
          contains_particle_start_ >> start_element_;

          //
          //
          contains_compositor_end_ >> end_compositor_;
          end_compositor_ >> contains_particle_end_;
          contains_particle_end_ >> end_compositor_;
          contains_particle_end_ >> end_element_;

          //
          //
          names_attribute_ >> attribute_;
        }

        virtual Void
        traverse (Type& c)
        {
          Boolean he (has<Traversal::Element> (c));
          Boolean ha (has<Traversal::Attribute> (c));
          String const& ret (ret_type (c));
          Boolean same (c.inherits_p () &&
                        ret == ret_type (c.inherits ().base ()));

          if (!(he || ha || same || ret == L"void"))
            return;

          String const& name (ename (c));

          os << "// " << name << endl
             << "//" << endl
             << endl;

          // Member callbacks.
          //
          if (!restriction_p (c))
          {
            if (ha)
              names (c, names_attribute_callback_);

            if (he)
              contains_compositor (c, contains_compositor_callback_);
          }

          // post
          //
          if (same || ret == L"void")
          {
            os << ret << " " << name << "::" << endl
               << post_name (c) << " ()"
               << "{";

            if (same)
            {
              SemanticGraph::Type& base (c.inherits ().base ());

              if (ret == L"void")
                os << post_name (base) << " ();";
              else
                os << "return " << post_name (base) << " ();";
            }

            os << "}";
          }


          // The rest is parsing/validation code which is generated in
          // *-validation-source.cxx.
          //
          if (validation)
            return;

          // Don't use restriction_p here since we don't want special
          // treatment of anyType.
          //
          Boolean restriction (
            c.inherits_p () &&
            c.inherits ().is_a<SemanticGraph::Restricts> ());

          // _start_element_impl & _end_element_impl
          //
          if (he)
          {
            // _start_element_impl
            //

            os << "bool " << name << "::" << endl
               << "_start_element_impl (const " << string_type << "& ns," << endl
               << "const " << string_type << "& n)"
               << "{";

            if (!restriction)
            {
              os << "if (";

              // Use unqualified name of our base.
              //
              if (c.inherits_p ())
                os << ename (c.inherits ().base ());
              else
                os << "complex_content";

              os << "::_start_element_impl (ns, n))"
                 << "{"
                 << "return true;"
                 << "}";
            }

            contains_compositor (c, contains_compositor_start_);

            os << "return false;"
               << "}";


            // _end_element_impl
            //
            os << "bool " << name << "::" << endl
               << "_end_element_impl (const " << string_type << "& ns," << endl
               << "const " << string_type << "& n)"
               << "{";


            if (!restriction)
            {
              os << "if (";

              // Use unqualified name of our base.
              //
              if (c.inherits_p ())
                os << ename (c.inherits ().base ());
              else
                os << "complex_content";

              os << "::_end_element_impl (ns, n))"
                 << "{"
                 << "return true;"
                 << "}";
            }

            contains_compositor (c, contains_compositor_end_);

            os << "return false;"
               << "}";
          }


          if (ha)
          {
            // _attribute_impl
            //

            os << "bool " << name << "::" << endl
               << "_attribute_impl (const " << string_type << "& ns," << endl
               << "const " << string_type << "& n," << endl
               << "const " << string_type << "& v)"
               << "{";

            if (!restriction)
            {
              os << "if (";

              // Use unqualified name of our base.
              //
              if (c.inherits_p ())
                os << ename (c.inherits ().base ());
              else
                os << "complex_content";

              os << "::_attribute_impl (ns, n, v))"
                 << "{"
                 << "return true;"
                 << "}";
            }

            names (c, names_attribute_);

            os << "return false;"
               << "}";
          }
        }

      private:
        //
        //
        Traversal::Compositor compositor_callback_;
        ParticleCallback particle_callback_;
        Traversal::ContainsCompositor contains_compositor_callback_;
        Traversal::ContainsParticle contains_particle_callback_;

        AttributeCallback attribute_callback_;
        Traversal::Names names_attribute_callback_;

        //
        //
        Traversal::Compositor start_compositor_;
        StartElement start_element_;
        Traversal::ContainsCompositor contains_compositor_start_;
        Traversal::ContainsParticle contains_particle_start_;

        //
        //
        Traversal::Compositor end_compositor_;
        EndElement end_element_;
        Traversal::ContainsCompositor contains_compositor_end_;
        Traversal::ContainsParticle contains_particle_end_;

        //
        //
        Attribute attribute_;
        Traversal::Names names_attribute_;
      };
    }

    Void
    generate_parser_source (Context& ctx)
    {
      Traversal::Schema schema;

      Traversal::Sources sources;
      Traversal::Names schema_names;

      Namespace ns (ctx);
      Traversal::Names names;

      schema >> sources >> schema;
      schema >> schema_names >> ns >> names;

      List list (ctx);
      Union union_ (ctx);
      Complex complex (ctx);
      Enumeration enumeration (ctx);

      names >> list;
      names >> union_;
      names >> complex;
      names >> enumeration;

      schema.dispatch (ctx.schema_root);
    }
  }
}

