// file      : xsd/cxx/tree/stream-source.cxx
// author    : Boris Kolpackov <boris@codesynthesis.com>
// copyright : Copyright (c) 2005-2008 Code Synthesis Tools CC
// license   : GNU GPL v2 + exceptions; see accompanying LICENSE file

#include <cxx/tree/stream-source.hxx>

#include <xsd-frontend/semantic-graph.hxx>
#include <xsd-frontend/traversal.hxx>

namespace CXX
{
  namespace Tree
  {
    namespace
    {
      struct List : Traversal::List, protected virtual Context
      {
        List (Context& c)
            : Context (c)
        {
        }

        virtual Void
        traverse (Type& l)
        {
          String name (ename (l));

          // If renamed name is empty then we do not need to generate
          // anything for this type.
          //
          if (renamed_type (l, name) && !name)
            return;

          os << std_ostream_type << "&" << endl
             << "operator<< (" << std_ostream_type << "& o, " <<
            "const " << name << "& i)"
             << "{"
             << "return o << static_cast< const ::xsd::cxx::tree::list< " <<
            item_type_name (l.argumented ().type ()) << ", " <<
            char_type << " >& > (i);"
             << "}";
        }

      private:
        String
        item_type_name (SemanticGraph::Type& t)
        {
          std::wostringstream o;

          MemberTypeName type (*this, o);
          type.dispatch (t);

          return o.str ();
        }
      };


      struct Union : Traversal::Union, protected virtual Context
      {
        Union (Context& c)
            : Context (c)
        {
        }

        virtual Void
        traverse (Type& u)
        {
          String name (ename (u));

          // If renamed name is empty then we do not need to generate
          // anything for this type.
          //
          if (renamed_type (u, name) && !name)
            return;

          os << std_ostream_type << "&" << endl
             << "operator<< (" << std_ostream_type << "& o, " <<
            "const " << name << "& i)"
             << "{"
             << "return o << static_cast< const " << xs_string_type << "& > (i);"
             << "}";
        }
      };


      struct Enumeration : Traversal::Enumeration, protected virtual Context
      {
        Enumeration (Context& c)
            : Context (c), base_ (c)
        {
          inherits_base_ >> base_;
        }

        virtual Void
        traverse (Type& e)
        {
          String name (ename (e));

          // If renamed name is empty then we do not need to generate
          // anything for this type.
          //
          if (renamed_type (e, name) && !name)
            return;

          Boolean string_based (false);
          {
            IsStringBasedType t (string_based);
            t.dispatch (e);
          }

          Boolean enum_based (false);
          if (string_based)
          {
            SemanticGraph::Enumeration* be (0);
            IsEnumBasedType t (be);
            t.dispatch (e);

            enum_based = (be != 0);
          }

          // If we are based on an enum then the value type is just an
          // alias and we don't need to generate this operator again.
          //
          if (string_based && !enum_based)
          {
            os << std_ostream_type << "&" << endl
               << "operator<< (" << std_ostream_type << "& o, " <<
              name << "::" << evalue (e) << " i)"
               << "{"
               << "return o << " << name << "::_xsd_" << name <<
              "_literals_[i];"
               << "}";
          }

          os << std_ostream_type << "&" << endl
             << "operator<< (" << std_ostream_type << "& o, " <<
            "const " << name << "& i)"
             << "{"
             << "return o << static_cast< const ";

          inherits (e, inherits_base_);

          os << "& > (i);"
             << "}";
        }

      private:
        Traversal::Inherits inherits_base_;
        BaseTypeName base_;
      };

      struct Element : Traversal::Element, protected virtual Context
      {
        Element (Context& c, String const& scope_)
            : Context (c), scope (scope_)
        {
        }

        virtual Void
        traverse (Type& e)
        {
          if (skip (e))
            return;

          String const& aname (eaname (e));

          if (max (e) != 1)
          {
            // sequence
            //
            os << "for (" << scope << "::" << econst_iterator (e) << endl
               << "b (i." << aname << " ().begin ()), " <<
              "e (i." << aname << " ().end ());" << endl
               << "b != e; ++b)"
               << "{"
               << "o << ::std::endl << " << L << "\"" << e.name () <<
              ": \" << *b;"
               << "}";
          }
          else if (min (e) == 0)
          {
            // optional
            //

            os << "if (i." << aname << " ())"
               << "{"
               << "o << ::std::endl << " << L << "\"" << e.name () <<
              ": \" << *i." << aname << " ();"
               << "}";
          }
          else
          {
            // one
            //
            os << "o << ::std::endl << " << L << "\"" << e.name () <<
              ": \" << i." << aname << " ();";
          }
        }

      private:
        String scope;
      };

      struct Attribute : Traversal::Attribute, protected virtual Context
      {
        Attribute (Context& c)
            : Context (c)
        {
        }

        virtual Void
        traverse (Type& a)
        {
          String const& aname (eaname (a));

          if (a.optional () && !a.default_ ())
          {
            os << "if (i." << aname << " ())"
               << "{"
               << "o << ::std::endl << " << L << "\"" << a.name () <<
              ": \" << *i." << aname << " ();"
               << "}";
          }
          else
          {
            os << "o << ::std::endl << " << L << "\"" << a.name () <<
              ": \" << i." << aname << " ();";
          }
        }
      };


      struct Complex : Traversal::Complex, protected virtual Context
      {
        Complex (Context& c)
            : Context (c), base_ (c)
        {
          inherits_ >> base_;
        }

        virtual Void
        traverse (Type& c)
        {
          String name (ename (c));

          // If renamed name is empty then we do not need to generate
          // anything for this type.
          //
          if (renamed_type (c, name) && !name)
            return;

          //
          //
          Boolean has_body (has<Traversal::Member> (c) || c.inherits_p ());

          os << std_ostream_type << "&" << endl
             << "operator<< (" << std_ostream_type << "& o, " <<
            "const " << name << "&" << (has_body ? " i" : "") << ")"
             << "{";

          if (c.inherits_p ())
          {
            os << "o << static_cast< const ";

            inherits (c, inherits_);

            os << "& > (i);";
          }

          {
            Traversal::Names names_member;
            Element element (*this, name);
            Attribute attribute (*this);

            names_member >> element;
            names_member >> attribute;

            names (c, names_member);
          }

          os << "return o;"
             << "}";
        }

      private:
        Traversal::Inherits inherits_;
        BaseTypeName base_;
      };
    }

    Void
    generate_stream_source (Context& ctx,
                            UnsignedLong first,
                            UnsignedLong last)
    {
      String c (ctx.char_type);

      ctx.os << "#include <ostream>" << endl
             << endl;

      Traversal::Schema schema;

      Traversal::Sources sources;
      Traversal::Names names_ns, names;

      Namespace ns (ctx, first, last);

      List list (ctx);
      Union union_ (ctx);
      Complex complex (ctx);
      Enumeration enumeration (ctx);

      schema >> sources >> schema;
      schema >> names_ns >> ns >> names;

      names >> list;
      names >> union_;
      names >> complex;
      names >> enumeration;

      schema.dispatch (ctx.schema_root);
    }
  }
}
