/*******************************************************************
 *
 * Licensed under a dual GPL/BSD license.  (See LICENSE file for more info.)
 *
 * File: timer.h
 *
 * Authors: Chris.Hessing@utah.edu
 *
 *******************************************************************/

#ifndef _TIMER_H_
#define _TIMER_H_

// Different types of timers that we will use.
#define NUM_TIMER_IDS   6

// BE SURE THAT IF YOU ADD A TIMER HERE, THAT YOU ADD IT'S DEF. IN timer.c!
#define COUNTERMEASURE_TIMER 1
#define REKEY_PROB_TIMER     2
#define ASSOCIATION_TIMER    3
#define STALE_KEY_WARN_TIMER 4
#define PASSIVE_SCAN_TIMER   5

void timer_init();
void timer_add_timer(uint16_t, uint16_t, void *, void *);
void timer_tick(struct interface_data *);
uint8_t timer_reset_timer_count(uint16_t, uint16_t);
char *timer_get_name_from_id(uint16_t);
uint8_t timer_check_existing(uint16_t);
struct timer_data *timer_get_by_id(uint16_t);
void timer_cancel(uint16_t);
void timer_cleanup();
void timer_clock_start();
void timer_sleep(uint16_t);

#endif
