# $Id: xtend.bash,v 1.1 1998-04-02 01:22:04-05 dshaw Exp $

# This can be 'source'd into your BASH shell scripts so you can take
# advantage of the functions below to parse the environment variables
# set by Xtend.
#
# Use them like:  if_on a1 command
# which executes "command" if a1 is on.
#
# Note that if_appliance and if_light are only valid if one of the other
# bits are set as well.  This saves memory. 

if_on()
	{
	local temp="\$X10_`echo $1 | tr a-z A-Z`"
	eval `echo local realvar=$temp`
	shift
	[ $((${realvar:-0} & 0x80)) -ne 0 ] && $*
	}

if_off()
	{
	local temp="\$X10_`echo $1 | tr a-z A-Z`"
	eval `echo local realvar=$temp`
	shift
	[ $((${realvar:-0} & 0x80)) -eq 0 ] && $*
	}

if_addressed()
	{
	local temp="\$X10_`echo $1 | tr a-z A-Z`"
	eval `echo local realvar=$temp`
	shift
	[ $((${realvar:-0} & 0x40)) -ne 0 ] && $*
	}

if_notaddressed()
	{
	local temp="\$X10_`echo $1 | tr a-z A-Z`"
	eval `echo local realvar=$temp`
	shift
	[ $((${realvar:-0} & 0x40)) -eq 0 ] && $*
	}

if_appliance()
	{
	local temp="\$X10_`echo $1 | tr a-z A-Z`"
	eval `echo local realvar=$temp`
	shift
	[ $((${realvar:-0} & 0x20)) -ne 0 ] && $*
	}

if_light()
	{
	local temp="\$X10_`echo $1 | tr a-z A-Z`"
	eval `echo local realvar=$temp`
	shift
	[ $((${realvar:-0} & 0x20)) -eq 0 ] && $*
	}

