#! /usr/bin/perl -w


# Ham Radio Contest Country check module wysiwyg.pm by PA0R.

# This program is published under the GPL license.
#   Copyright (C) 2005, 2006
#       Rein Couperus PA0R (rein@couperus.com)
# 
# *    wysiwyg.pm is free software; you can redistribute it and/or modify
# *    it under the terms of the GNU General Public License as published by
# *    the Free Software Foundation; either version 2 of the License, or
# *    (at your option) any later version.
# *
# *    wysiwyg.pm is distributed in the hope that it will be useful,
# *    but WITHOUT ANY WARRANTY; without even the implied warranty of
# *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# *    GNU General Public License for more details.
# *
# *    You should have received a copy of the GNU General Public License
# *    along with this program; if not, write to the Free Software
# *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Date: 04-04-06

#################################################
# API:
# add, check, delete wsections in hash per band... 
# Input is wsection and band (int)
# Output is nr. of records per wsection
#
# addwsection($wsection, $band);
# checkwsection($wsection, $band)
# delwsection($wsection, $band)
# 
# @cnts = countwsections() (160, 80, 40,20, 15,10)
#################################################

use Switch;


{ # start outer block



#################################################
sub getwsectioninfo {
#################################################

	return @wsections;
}


#################################################
sub addwsection {
#################################################
	my ($wsection, $band) = @_;
	if ($wsection !~ /^\d+/) {
		; # continue
	} else { return 0; } # is serial nr.
	
	switch($band) {
		case "160"	{$r = addwsection_160($wsection);}
		case "80"	{$r = addwsection_80($wsection);}
		case "40"	{$r = addwsection_40($wsection);}
		case "20"	{$r = addwsection_20($wsection);}
		case "15"	{$r = addwsection_15($wsection);}
		case "10"	{$r = addwsection_10($wsection);}
		case "99"   {$r = addwsection_all($wsection);
		}
	}
	return $r;
}

#################################################
sub checkwsection {
#################################################
	my ($wsection, $band) = @_;

	my $r = 0;

	switch($band) {
		case "160"	{$r = checkwsection_160($wsection);}
		case " 80"	{$r = checkwsection_80($wsection);}
		case " 40"	{$r = checkwsection_40($wsection);}
		case " 20"	{$r = checkwsection_20($wsection);}
		case " 15"	{$r = checkwsection_15($wsection);}
		case " 10"	{$r = checkwsection_10($wsection);}
		case "99"	{$r = checkwsection_all($wsection);}
	}
	if ($r) {
		return $r;
	} else {
		return 0;
	}
}

#################################################
sub delwsection {
#################################################
	my ($wsection, $band) = @_;

	switch($band) {
		case 160	{$r = delwsection_160($wsection)}
		case  80	{$r = delwsection_80($wsection)}
		case  40	{$r = delwsection_40($wsection)}
		case  20	{$r = delwsection_20($wsection)}
		case  15	{$r = delwsection_15($wsection)}
		case  10	{$r = delwsection_10($wsection)}
	}
	return $r;
}


{ # start block#########################################

%wsection_all = ();
%wsection_10 = ();
%wsection_15 = ();
%wsection_20 = ();
%wsection_40 = ();
%wsection_80 = ();
%wsection_160 = ();

#################################################
sub addwsection_all {
#################################################
	my $wsection = shift @_;
	
		$wsection_all{$wsection}++;
		return $wsection_all{$wsection};
	
}
#################################################
sub addwsection_10 {
#################################################
	my $wsection = shift @_;
	
		$wsection_10{$wsection}++;
		return $wsection_10{$wsection};
	
}
#################################################
sub checkwsection_10 {
#################################################
	my $wsection = shift @_;
	if ($wsection_10{$wsection}) {
		return $wsection_10{$wsection};
	}
	return 0;
}

#################################################
sub delwsection_10 {
#################################################
	my $wsection = shift @_;
	
	if ($wsection_10{$wsection}) {
		$wsection_10{$wsection}--; 
		$wsection_all{$wsection}--; 
		return $wsection_10{$wsection};
	}
	return 0;
}

#################################################
sub addwsection_15 {
#################################################
	my $wsection = shift @_;
	
		$wsection_15{$wsection}++;
		return $wsection_15{$wsection};
	
}
#################################################
sub checkwsection_15 {
#################################################
	my $wsection = shift @_;
	if ($wsection_15{$wsection}) {
		return $wsection_15{$wsection};
	}
	return 0;
}

#################################################
sub delwsection_15 {
#################################################
	my $wsection = shift @_;
	
	if ($wsection_15{$wsection}) {
		$wsection_15{$wsection}--; 
		$wsection_all{$wsection}--; 
		return $wsection_15{$wsection};
	}
	return 0;
}

#################################################
sub addwsection_20 {
#################################################
	my $wsection = shift @_;
		$wsection_20{$wsection}++;

		return $wsection_20{$wsection};
	
}
#################################################
sub checkwsection_20 {
#################################################
	my $wsection = shift @_;
	if ($wsection_20{$wsection}) {
		return $wsection_20{$wsection};
	}
	return 0;
}

#################################################
sub delwsection_20 {
#################################################
	my $wsection = shift @_;
	
	if ($wsection_20{$wsection}) {
		$wsection_20{$wsection}--; 
		$wsection_all{$wsection}--; 
		return $wsection_20{$wsection};
	}
	return 0;
}

#################################################
sub addwsection_40 {
#################################################
	my $wsection = shift @_;

		$wsection_40{$wsection}++;

		return $wsection_40{$wsection};
	
}
#################################################
sub checkwsection_40 {
#################################################
	my $wsection = shift @_;
	if ($wsection_40{$wsection}) {
		return $wsection_40{$wsection};
	}
	return 0;
}

#################################################
sub delwsection_40 {
#################################################
	my $wsection = shift @_;
	
	if ($wsection_40{$wsection}) {
		$wsection_40{$wsection}--; 
		$wsection_all{$wsection}--; 
		return $wsection_40{$wsection};
	}
	return 0;
}

#################################################
sub addwsection_80 {
#################################################
	my $wsection = shift @_;
	
		$wsection_80{$wsection}++;
		return $wsection_80{$wsection};
	
}
#################################################
sub checkwsection_80 {
#################################################
	my $wsection = shift @_;
	if ($wsection_80{$wsection}) {
		return $wsection_80{$wsection};
	}
	return 0;
}

#################################################
sub delwsection_80 {
#################################################
	my $wsection = shift @_;
	
	if ($wsection_80{$wsection}) {
		$wsection_80{$wsection}--; 
		$wsection_all{$wsection}--; 
		return $wsection_80{$wsection};
	}
	return 0;
}

#################################################
sub addwsection_160 {
#################################################
	my $wsection = shift @_;
	
		$wsection_160{$wsection}++;
		return $wsection_160{$wsection};
	
}
#################################################
sub checkwsection_160 {
#################################################
	my $wsection = shift @_;
	if ($wsection_160{$wsection}) {
		return $wsection_160{$wsection};
	}
	return 0;
}

#################################################
sub delwsection_160 {
#################################################
	my $wsection = shift @_;
	
	if ($wsection_160{$wsection}) {
		$wsection_160{$wsection}--; 
		$wsection_all{$wsection}--; 
		return $wsection_160{$wsection};
	}
	return 0;
}

#################################################
sub checkwsection_all {
#################################################
	my $wsection = shift @_;
	if ($wsection_all{$wsection}) {
		return $wsection_all{$wsection};
	}
	return 0;
}
#################################################
sub countwsections_all {
#################################################
my $count = 0;
my @out = ();
	foreach my $key (keys %wsection_all) {
		$count ++;
	}
	push @out, $count;
	return @out;
}

#################################################
sub countwsections {
#################################################
my $count = 0;
my @out = ();
	foreach my $key (keys %wsection_160) {
		$count ++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %wsection_80) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %wsection_40) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %wsection_20) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %wsection_15) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %wsection_10) {
		$count++;
	}
	push @out, $count;
	
	return @out;
}

###############################################
sub init_wsections {
###############################################
%wsection_all = ();
%wsection_10 = ();
%wsection_15 = ();
%wsection_20 = ();
%wsection_40 = ();
%wsection_80 = ();
%wsection_160 = ();
}

} # end block ##########################################
	
{ # start block#########################################

my %cwwsection_all;
my %cwwsection_10;
my %cwwsection_15;
my %cwwsection_20;
my %cwwsection_40;
my %cwection_80;
my %cwwsection_160;

#################################################
sub addcwwsection {
#################################################
	my ($wsection, $band) = @_;
	if ($wsection =~ /([A-Z]).*/) {
		; # continue
	} else { return 0; } # is serial nr.

	switch($band) {
		case 160	{
				$cwwsection_160{$wsection}++;
				$r = $cwwsection_160{$wsection};
			}
		case  80	{
				$cwwsection_80{$wsection}++;
				$r = $cwwsection_80{$wsection};
			}
		case  40	{
				$cwwsection_40{$wsection}++;
				$r = $cwwsection_40{$wsection};
			}
		case  20	{
				$cwwsection_20{$wsection}++;
				$r = $cwwsection_20{$wsection};
			}
		case  15	{
				$cwwsection_15{$wsection}++;
				$r = $cwwsection_15{$wsection};
			}
		case  10	{
				$cwwsection_10{$wsection}++;
				$r = $cwwsection_10{$wsection};
			}
		case  "all"	{
				$cwwsection_all{$wsection}++;
				$r = $cwwsection_all{$wsection};
			}
	}
	return $r;
}
#################################################
sub countcwwsections {
#################################################
my $count = 0;
my @out = ();
	foreach my $key (keys %cwwsection_160) {
		$count ++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %cwwsection_80) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %cwwsection_40) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %cwwsection_20) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %cwwsection_15) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %cwwsection_10) {
		$count++;
	}
	push @out, $count;
	
	return @out;
}
#####################################
sub init_cwwsections {
#####################################
 %cwwsection_all = ();
 %cwwsection_10 = ();
 %cwwsection_15 = ();
 %cwwsection_20 = ();
 %cwwsection_40 = ();
 %cwection_80 = ();
 %cwwsection_160 = ();
}

} # end block #########################################

{ # start block#########################################

my %ssbwsection_all;
my %ssbwsection_10;
my %ssbwsection_15;
my %ssbwsection_20;
my %ssbwsection_40;
my %ssbwsection_80;
my %ssbwsection_160;

#################################################
sub addssbwsection {
#################################################
	my ($wsection, $band) = @_;

	if ($wsection =~ /([A-Z]).*/) {
		; # continue
	} else { return 0; } # is serial nr.

	switch($band) {
		case 160	{
				$ssbwsection_160{$wsection}++;
				$r = $ssbwsection_160{$wsection};
			}
		case  80	{
				$ssbwsection_80{$wsection}++;
				$r = $ssbwsection_80{$wsection};
			}
		case  40	{
				$ssbwsection_40{$wsection}++;
				$r = $ssbwsection_40{$wsection};
			}
		case  20	{
				$ssbwsection_20{$wsection}++;
				$r = $ssbwsection_20{$wsection};
			}
		case  15	{
				$ssbwsection_15{$wsection}++;
				$r = $ssbwsection_15{$wsection};
			}
		case  10	{
				$ssbwsection_10{$wsection}++;
				$r = $ssbwsection_10{$wsection};
			}
		case  "all"	{
				$ssbwsection_all{$wsection}++;
				$r = $ssbwsection_all{$wsection};
			}
	}
	return $r;
}
#################################################
sub countssbwsections {
#################################################
my $count = 0;
my @out = ();
	foreach my $key (keys %ssbwsection_160) {
		$count ++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %ssbwsection_80) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %ssbwsection_40) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %ssbwsection_20) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %ssbwsection_15) {
		$count++;
	}
	push @out, $count;
	$count = 0;
	foreach my $key (keys %ssbwsection_10) {
		$count++;
	}
	push @out, $count;
	
	return @out;
}
#######################################
sub init_ssbwsections {
#######################################
 %ssbwsection_all = ();
 %ssbwsection_10 = ();
 %ssbwsection_15 = ();
 %ssbwsection_20 = ();
 %ssbwsection_40 = ();
 %ssbwsection_80 = ();
 %ssbwsection_160 = ();
}


} # end block #########################################


#################################################
sub testwsections {
#################################################

	while (1) {
		print "\nEnter wsection:";
		my $wsection = <STDIN>;
		chomp $wsection;
		if ($wsection eq "q") {
			exit;
		} else {
			if (wsection_valid ($wsection, %valid_wsections)) {
				print "$wsection is o.k.!\n";
			} else {
				print "Not found!\n";
			}
		}
	}
}
} # end outer block
1;

