#! /usr/bin/perl -w


# Ham Radio Country info module countries.pm by PA0R.

# This program is published under the GPL license.
#   Copyright (C) 2005, 2006
#       Rein Couperus PA0R (rein@couperus.com)
# 
# *    countries.pm is free software; you can redistribute it and/or modify
# *    it under the terms of the GNU General Public License as published by
# *    the Free Software Foundation; either version 2 of the License, or
# *    (at your option) any later version.
# *
# *    countries.pm is distributed in the hope that it will be useful,
# *    but WITHOUT ANY WARRANTY; without even the implied warranty of
# *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# *    GNU General Public License for more details.
# *
# *    You should have received a copy of the GNU General Public License
# *    along with this program; if not, write to the Free Software
# *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

# Date: 04-04-06

#####################################################
# addcountry($countryindex, $band)
# delcountry($countryindex, $band)
# checkcountry($countryindex, $band)
# @count = countcountry();
#####################################################
use Switch;

{ # start block

for ($i = 0; $i < 400; $i++) {
	$countries_160[$i] = 0;
	$countries_80[$i] = 0;
	$countries_40[$i] = 0;
	$countries_20[$i] = 0;
	$countries_15[$i] = 0;
	$countries_10[$i] = 0;
	$countries_all[$i] = 0;
}

#####################################################
sub init_country {
#####################################################

for ($i = 0; $i < 400; $i++) {
	$countries_160[$i] = 0;
	$countries_80[$i] = 0;
	$countries_40[$i] = 0;
	$countries_20[$i] = 0;
	$countries_15[$i] = 0;
	$countries_10[$i] = 0;
	$countries_all[$i] = 0;
}
}
#####################################################
sub addcountry {
#####################################################

	my ($country, $band) = @_;

	switch ($band) {
		case 160 { 
			$countries_160[$country]++;
			$countries_all[$country]++;
			return $countries_160[$country];
		}
		case 80 { 
			$countries_80[$country]++;
			$countries_all[$country]++;
			return $countries_80[$country];
		}
		case 40 { 
			$countries_40[$country]++;
			$countries_all[$country]++;
			return $countries_40[$country];
		}
		case 20 { 
			$countries_20[$country]++;
			$countries_all[$country]++;
			return $countries_20[$country];
		}
		case 15 { 
			$countries_15[$country]++;
			$countries_all[$country]++;
			return $countries_15[$country];
		}
		case 10 { 
			$countries_10[$country]++;
			$countries_all[$country]++;
			return $countries_10[$country];
		}
	}
	
}

#####################################################
sub delcountry {
#####################################################

	my ($country, $band) = @_;
	
	switch ($band) {
		case 160 { 
			$countries_160[$country]--;
			$countries_all[$country]--;
			return $countries_160[$country];
		}
		case 80 { 
			$countries_80[$country]--;
			$countries_all[$country]--;
			return $countries_80[$country];
		}
		case 40 { 
			$countries_40[$country]--;
			$countries_all[$country]--;
			return $countries_40[$country];
		}
		case 20 { 
			$countries_20[$country]--;
			$countries_all[$country]--;
			return $countries_20[$country];
		}
		case 15 { 
			$countries_15[$country]--;
			$countries_all[$country]--;
			return $countries_15[$country];
		}
		case 10 { 
			$countries_10[$country]--;
			$countries_all[$country]--;
			return $countries_10[$country];
		}
	}
}

#####################################################
sub checkcountry {
#####################################################
	my ($country, $band) = @_;
	
	switch($band) {
		case "160" { return $countries_160[$country]; }	
		case " 80" { return $countries_80[$country]; }	
		case " 40" { return $countries_40[$country]; }	
		case " 20" { return $countries_20[$country]; }	
		case " 15" { return $countries_15[$country]; }	
		case " 10" { return $countries_10[$country]; }	
		case " 99" { return $countries_all[$country]; }
		else { return 0 }
	}
}

#####################################################
sub count_country {
#####################################################
my $count = 0;
my @out = ();
my $val = 0;
	foreach $val (@countries_160) {
		if ($val) {$count++; }
	}
	push @out, $count;
	$count = 0;
	foreach $val (@countries_80) {
		if ($val) {$count++; }
	}
	push @out, $count;
	$count = 0;
	foreach $val (@countries_40) {
		if ($val) {$count++; }
	}
	push @out, $count;
	$count = 0;
	foreach $val (@countries_20) {
		if ($val) {$count++; }
	}
	push @out, $count;
	$count = 0;
	foreach $val (@countries_15) {
		if ($val) {$count++; }
	}
	push @out, $count;
	$count = 0;
	foreach $val (@countries_10) {
		if ($val) {$count++; }
	}
	push @out, $count;
	$count = 0;
	foreach $val (@countries_all) {
		if ($val) {$count++; }
	}
	push @out, $count;
	
	return @out;

}

} # end block
1;
