from Proxy import ProxyManager
from Products.PlugIns import defaultConstructors, PlugInContainer
from Providers import Provider, NullProvider
from Globals import default__class_init__
from string import split,strip
from Acquisition import aq_base
from Expressions import *
from ZClasses.Method import MWp
from OFS.Folder import Folder
import sys
from zLOG import LOG, WARNING

NOT_FOUND = []

eaKey = 'ZPatterns.AttributeProviders', 'ExternalAttributes'


























class AttributeProvider(Provider):
    """
    AttributeProvider example class.  This attribute provider assumes that
    the object containing the attributes is persistent and can save
    whatever is desired.  All of its methods would need to be redefined
    for providers that implement fixed-schema and/or non-persistence-based
    attributes.
    """
    __plugin_kind__ = 'Attribute Provider'

    def namesForRegistration(self,container):
        """
Return a tuple (readnames,writenames) where each is a sequence of attribute
names which this attribute provider supports reading and writing, respectively.
'*' may be included in either or both sequences, which means the provider will
be called if a more specific provider could not be found for a given attribute.
This is so that attribute providers can potentially create attributes
dynamically based on the requested name.
        """
        return {
            'provides':('attributes',),
            'setattr': self.Attributes, 'delattr': self.Attributes
        }

    def _AttributeFor(self,client,name,default=None):
        """
        Since persistent attributes are stored in the object, if we get
        here, then we are trying to get something that doesn't exist!
        """
        return default

    def _SetAttributeFor(self,client,name,value):
        """Set the attribute and return true if successful"""
        client.__dict__[name]=value; client._p_changed = 1
        return 1

    def _DelAttributeFor(self,client,name):
        """Delete the attribute and return true if successful"""
        if client._v_changedAttrs_[name] is NOT_FOUND: del client._v_changedAttrs_[name]        
        return 1    # Nothing else to do, since DataSkin has already deleted persistent attr

    # Class Metadata
    
    meta_type='Persistent Internal Attribute Provider'
    
    Attributes = ('*',)

    _properties=(
        {'id':'title', 'type': 'string', 'mode': 'w'},
        {'id':'Attributes', 'type': 'tokens', 'mode': 'w'},
    )































class ExternalAttributeProvider(AttributeProvider):
    """
    This attribute provider stores persistent attributes outside the object
    itself, in its persistent 'slot'.  This allows persistent attributes to
    be used even with non-persistent DataSkins (e.g. those which are only
    virtually stored in a Rack.
    """

    def _AttributeFor(self,client,name,default=None):
        return client._v_readableSlot.get(eaKey,{}).get(name,default)

    def _SetAttributeFor(self,client,name,value):
        """Set the attribute and return true if successful"""
        attrs = client._v_readableSlot.get(eaKey,{}); attrs[name]=value
        client._v_writeableSlot[eaKey] = attrs
        return 1

    def _DelAttributeFor(self,client,name):
        """Delete the attribute and return true if successful"""
        if client._v_changedAttrs_[name] is NOT_FOUND: del client._v_changedAttrs_[name]
        attrs = client._v_readableSlot.get(eaKey,{})
        if attrs.has_key(name):
            del attrs[name]
            client._v_writeableSlot[eaKey] = attrs
            return 1

    # Class Metadata
    
    meta_type='Persistent External Attribute Provider'


    def namesForRegistration(self,container):
        return {
            'provides':('attributes',), 'getattr': self.Attributes,
            'setattr': self.Attributes, 'delattr': self.Attributes
        }





class ClassExtender(NullProvider,PlugInContainer):

    """Thing that provides its contents as attributes"""
    
    __plugin_kind__ = 'Attribute Provider'

    __plugin_groups__ = ()

    meta_type='DataSkin Class Extender'

    manage_options_right = tuple(
        Folder.manage_options[1:-3]+(
            {'label':'Security','action':'manage_access',
             'help':('OFSP','Security.stx'),},
        )+Folder.manage_options[-2:]
    )

    def namesForRegistration(self,container):
        return {
            'provides':('attributes',),
            'getattr': self.objectIds(),
        }

    def _AttributeFor(self,client,name,default=None):
        return MWp(self.__dict__.get(name,default))

    def _SetAttributeFor(self,client,name,value):
        pass

    def _DelAttributeFor(self,client,name):
        pass

    def _setObject(self,id,object,roles=None,user=None, set_owner=1):
        r = PlugInContainer._setObject.im_func(self,id,object,roles,user,set_owner)
        self.aq_inner.aq_parent.manage_refreshPlugIns()
        return r

    def _delObject(self, id, dp=1):
        PlugInContainer._delObject.im_func(self,id,dp)
        self.aq_inner.aq_parent.manage_refreshPlugIns()

    # Permission mapping stuff

    def permissionMappingPossibleValues(self):
        return self.possible_permissions()

    _isBeingUsedAsAMethod_=1

    def _isBeingUsedAsAMethod(self, REQUEST=None, wannaBe=0):
        if REQUEST is not None and wannaBe: REQUEST.response.notFoundError()
        return 0































class GAPMixin:

    def namesForRegistration(self,container):
        """XXX"""
            
        return {
            'provides':('attributes',),
            'getattr': map(lambda x: x[0], self.Attributes)
        }

    Attributes = ()
    Defaults = ()
    IsQuery = None




























    def _AttributeFor(self,client,name,default=None):

        try:
            t = NamespaceStack()
            pushProxy(self)

            try:            
                data = {'self':client, 'ATTRIBUTE_NAME':name, 'NOT_FOUND':default}

                if self._fromex is not None:
                    t._push(InstanceDict(self, t))
                    t._push(data)
                
                    try:
                        result = data['RESULT'] = self._fromex.eval(t)
                    finally:
                        t._pop(2)

                    if self.IsQuery:
                        if len(result):
                            result=result[0]
                        else:
                            result=default

                else:
                    # use 'self' as result
                    result = data['RESULT'] = client


                if result is default:
                    exprlist = self.Defaults
                else:
                    exprlist = self.Attributes
            
                if not exprlist:
                    return default





                t._push(InstanceDict(result, t))
                t._push(data)
        
                try:
                    c = client._getCache()
                    for a,e in exprlist:
                        c[a] = e.eval(t)
                finally:
                    t._pop(2)

            finally:
                popProxy(self)
            
            return c.get(name,default)

        except:
            LOG('ZPatterns',WARNING,('Error computing attribute %s' % name),
                '', sys.exc_info(), 1)
            return default






















class GenericAttributeProvider(GAPMixin,AttributeProvider,ProxyManager):
    """
    XXX Explain this
    """

    manage_options = AttributeProvider.manage_options + ProxyManager.manage_options

    def _propertiesChanged(self):
    
        self.Attributes = []

        if self.fromexpr:
            self._fromex = Expression(self.fromexpr)
        else:
            self._fromex = None
            
        for l in filter(None,map(strip,self.attrsexprs)):
            if '=' in l:
                a,e = split(l,'=',1)
                self.Attributes.append(a,Expression(e))
            else:
                self.Attributes.append(l,Name(l,0))

    # Class Metadata
    
    meta_type='Generic Attribute Provider'
    
    fromexpr=''
    attrsexprs=[]

    _properties=(
        {'id':'title', 'type': 'string', 'mode': 'w'},
        {'id':'fromexpr', 'type': 'string', 'mode': 'w'},
        {'id':'attrsexprs', 'type': 'lines', 'mode': 'w'},
    )

ExprGetterAttributeProvider = GenericAttributeProvider




def initialize(context):

    context.registerPlugInClass(
        AttributeProvider,
        permission = 'Add Attribute Providers',
        constructors = defaultConstructors(AttributeProvider,globals()),
        icon = 'www/attrprov.gif'
    )

    context.registerPlugInClass(
        ClassExtender,
        permission = 'Add DataSkin Class Extenders',
        constructors = defaultConstructors(ClassExtender,globals()),
        icon = 'www/ClassExtender.gif'
    )

    context.registerPlugInClass(
        ExternalAttributeProvider,
        permission = 'Add Attribute Providers',
        constructors = defaultConstructors(ExternalAttributeProvider,globals()),
        icon = 'www/PEAP.gif'
    )

    return

    # disabled
    context.registerPlugInClass(
        GenericAttributeProvider,
        permission = 'Add Generic Attribute Providers',
        constructors = defaultConstructors(GenericAttributeProvider,
                        globals()),
        icon = 'www/exprgetter.gif'
    )


