#include <Carbon/Carbon.h>
#include "FL/Fl.H"
#include "FL/fl_draw.H"
#include "FL/x.H"

static int MG_doing_copy = 0;

//included functions
void MyCopyPictToClipboard (PicHandle mypicture);
void CtoP(const void *in, void *out);

void MG_fl_draw(const char *txt, int x, int y)
{
	if(txt == NULL) return;
	if(!MG_doing_copy){
		fl_draw(txt, x, y);
		return;
		}
	unsigned char copy[strlen(txt) + 1];
	CtoP(txt, copy);
	MoveTo(x, y);
	DrawString(copy);
}

void MG_fl_line(int x, int y, int x1, int y1)
{
	if(!MG_doing_copy){
		fl_line(x, y, x1, y1);
		return;
	}
	MoveTo(x, y);
	LineTo(x1, y1);
}

void MG_fl_rect(int x, int y, int w, int h)
{
	if(!MG_doing_copy){
		fl_rect(x, y, w, h);
		return;
	}
	MoveTo(x, y);
	LineTo(x, y+h-1);
	LineTo(x+w-1, y+h-1);
	LineTo(x+w-1, y);
	LineTo(x, y);
}

void MG_fl_font(int fontrank, int size)
{
	if(!MG_doing_copy){
		fl_font(fontrank, size);
		return;
	}
	Style mystyle = normal;
	int macfont, fontstyle;
	if(fontrank < FL_SYMBOL) {
		fontstyle = fontrank % 4;
		fontrank -= fontstyle;
		}
	 if(fontrank == FL_COURIER)
		 macfont=kFontIDCourier/*22*/;
	 else if(fontrank == FL_HELVETICA)
		 macfont=kFontIDHelvetica/*21*/;
	 else if(fontrank == FL_TIMES)
		 macfont=kFontIDTimes/*20*/;
	 else if(fontrank == FL_SYMBOL)
		 macfont=kFontIDSymbol/*23*/;
	 else
		 macfont=21; 
	if(fontrank < FL_SYMBOL) {
		if(fontstyle == 0) mystyle = normal;
		else if(fontstyle == 1) mystyle = bold;
		else if(fontstyle == 2) mystyle = italic;
		else if(fontstyle == 3) mystyle = bold+italic;
		}
	TextFont(macfont);
	TextSize(size);
    TextFace(mystyle);
}

void MG_fl_color(Fl_Color color)
{
	if(!MG_doing_copy){
		fl_color(color);
		return;
	}
	unsigned char r, g, b;
	Fl::get_color(color, r, g, b);
	RGBColor maccolor;
	maccolor.red = r << 8;
	maccolor.green = g << 8;
	maccolor.blue = b << 8;
	RGBForeColor(&maccolor);
}

float MG_fl_width(char *txt, int l)
{
	if(!MG_doing_copy){
		return fl_width(txt, l);
	}
	return (float)TextWidth( txt, 0, l );
}

float MG_fl_width(char *txt)
{
	return MG_fl_width(txt, strlen(txt));
}

void *MG_PrepareCopy(int w, int h)
{
	Rect myrect;
	myrect.top=0;
	myrect.left=0;
	myrect.right=w;
	myrect.bottom=h;
#ifdef __APPLE_QUARTZ__
	Fl_X::q_release_context();
#endif
	PicHandle mypicture = OpenPicture(&myrect);
	ClipRect(&myrect);
	PenNormal();
	MG_doing_copy = 1;
	return mypicture;
}


void MG_CompleteCopy(void *mypicture)
{
	ClosePicture();
	MG_doing_copy = 0;
	MyCopyPictToClipboard((PicHandle)mypicture);
	KillPicture((PicHandle)mypicture);
}


static size_t MyPutBytes (void* info, const void* buffer, size_t count)
{
    CFDataAppendBytes ((CFMutableDataRef) info, (const UInt8 *)buffer, count);
    return count;
}

QDPictRef MyPictToQDPict(PicHandle mypicture)
{
	CFIndex pictlen;
	CGDataProviderRef provider;
	/* conversion picture to QDPict */
	pictlen = GetHandleSize( (Handle)  mypicture);
	HLock( (Handle) mypicture);
	provider = CGDataProviderCreateWithData (NULL, *mypicture, pictlen, NULL);
	HUnlock( (Handle) mypicture);
    if (provider != NULL) {
        QDPictRef myqdpict = QDPictCreateWithProvider (provider);
		CFRelease(provider);
		return myqdpict;
	}
	else return NULL;
}

void MyCopyPictToClipboard (PicHandle mypicture)
{
    static CGDataConsumerCallbacks callbacks = { MyPutBytes, NULL };
	CFDataRef  data = NULL;
	PasteboardRef clipboard = NULL;
	CFIndex pictlen;
	QDPictRef myqdpict;	
	
	pictlen = GetHandleSize( (Handle)  mypicture);
	PasteboardCreate (kPasteboardClipboard, &clipboard);
	PasteboardClear(clipboard);
	HLock( (Handle) mypicture);
	data = CFDataCreate( kCFAllocatorDefault, (UInt8*)*mypicture, pictlen );
	HUnlock( (Handle) mypicture);
	PasteboardPutItemFlavor(clipboard, (PasteboardItemID)1, 
							/* kUTTypePICT */ CFSTR("com.apple.pict"),
							data,
							kPasteboardFlavorNoFlags );
    CFRelease (data);    
	
	myqdpict = MyPictToQDPict(mypicture);
	data = CFDataCreateMutable (kCFAllocatorDefault, 0);
    if (data != NULL)
    {
        CGDataConsumerRef consumer = NULL;
        consumer = CGDataConsumerCreate ((void*) data, &callbacks);
        if (consumer != NULL) 
        {
            CGContextRef context = NULL;
            CGRect bounds = QDPictGetBounds (myqdpict);
            bounds.origin.x = 0;
            bounds.origin.y = 0;
            context = CGPDFContextCreate (consumer, &bounds, NULL);
            CGDataConsumerRelease (consumer);
            if (context != NULL) 
            {
                /* convert PICT to PDF */
                CGContextBeginPage (context, &bounds);
                (void) QDPictDrawToCGContext (context, bounds, myqdpict);
                CGContextEndPage (context);
                CGContextRelease (context);
				
                /* copy PDF to clipboard */
                (void) PasteboardPutItemFlavor (clipboard, 
												(PasteboardItemID)1, 
												/* kUTTypePDF */ CFSTR("com.adobe.pdf"), 
												data, kPasteboardFlavorNoFlags);
            }
        }
		CFRelease (data); 
    }
	CFRelease (clipboard);
	if(myqdpict != NULL) QDPictRelease(myqdpict);
}

/* 
//the following would copy PDF data to the clipboard using Quartz draw commands
 
extern CGContext *fl_gc;
struct gc_data {
	CGContext *oldflgc;
	CFMutableDataRef data;
};
void *MG_PrepareCopy(int w, int h)
{
    static CGDataConsumerCallbacks callbacks = { MyPutBytes, NULL };
	static struct gc_data retval;
    CGContextRef context;
    CGRect bounds;
    bounds.origin.x = 0;
    bounds.origin.y = 0;
    bounds.size.width = w;
    bounds.size.height = h;
	
	CFMutableDataRef mydata = CFDataCreateMutable(NULL, 0);
	CGDataConsumerRef myconsumer = CGDataConsumerCreate ((void*) mydata, &callbacks);
    context = CGPDFContextCreate (myconsumer, &bounds, NULL);
	CGDataConsumerRelease (myconsumer);
    if (context == NULL) return NULL;
	retval.oldflgc = fl_gc;
	retval.data = mydata;
	fl_gc = context;
	CGPDFContextBeginPage (fl_gc, NULL);
	CGContextTranslateCTM(fl_gc, 0.5, h-0.5f);
	CGContextScaleCTM(fl_gc, 1.0f, -1.0f);
	return &retval;
}

void MG_CompleteCopy(void *mydata)
{
	struct gc_data *retval = (struct gc_data *)mydata;
	PasteboardRef clipboard = NULL;
	CGPDFContextEndPage (fl_gc);
	CGContextRelease (fl_gc);
//	 copy PDF to clipboard 
	PasteboardCreate (kPasteboardClipboard, &clipboard);
	PasteboardClear(clipboard);
	(void) PasteboardPutItemFlavor (clipboard, (PasteboardItemID)1, 
									CFSTR("com.adobe.pdf"), // kUTTypePDF
									retval->data, kPasteboardFlavorNoFlags);
//	CFDataRef bidon = CFDataCreate(NULL, (const UInt8 *)"image", 6);
//	OSStatus err= PasteboardPutItemFlavor (clipboard, (PasteboardItemID)1, 
//									CFSTR("public.utf8-plain-text"), 
//									bidon, kPasteboardFlavorNoFlags); 
	CFRelease (retval->data); 
	CFRelease (clipboard);
	fl_gc = retval->oldflgc;
}
*/

void CtoP(const void *in, void *out)
{
	char *vout = (char *)out;
	int l;
	if(in == NULL) l = 0;
	else	{
		l = strlen( (char *)in );
		memcpy(vout + 1, in, l);
	}
	vout[0] = l;
}
