# Topton N100 (X2F)2 Firewall Appliance

This page describes how to run coreboot on the Topton N100.

```{eval-rst}
+---------------+---------------------------------+----------------------+
| Binary file   | Apply                           | Required / Optional  |
+===============+=================================+======================+
| IFD           | Intel Flash Descriptor          | Required (see below) |
+---------------+---------------------------------+----------------------+
| ME            | Intel Management Engine         | Required (see below) |
+---------------+---------------------------------+----------------------+
| FSP-M & FSP-S | Intel Firmware Support Package  | Required             |
+---------------+---------------------------------+----------------------+
```

## Flashing coreboot

**WARNING:** There are multiple devices from the same vendor with
similar name, using different board layout, capabilities and EC/SuperIO.

Likewise, there are other vendors selling their devices with
the same mainboard. According to the sticker on the box: `H30W-N100-226`.

Please **DO NOT cross-flash firmware on "similar-looking" device**.
Doing so **may kill your device**. You have been warned :)

### Internally

Vendor of this motherboard hasn't locked any flash regions, resulting
in internal programmers such as [flashrom]/[flashprog] having full access
to the SPI chip. Assuming that user had booted Linux with `iomem=relaxed`,
they can:
- Flash coreboot from stock firmware
- Flash stock firmware from coreboot
- Update coreboot build to a newer version

	Without opening the case and connecting the SPI flasher.

Note: some users have reported bricked devices when using [flashrom] to
flash the board, so the current recommendation is to use [flashprog]
v1.3.0 or newer.

Since we only need to flash the `bios` region of the flash chip, there is
no need to extract the `ifd` or `me` regions from your backup of the stock
firmware. One can flash the `bios` region only using the following command:
`flashprog -p internal --ifd -i bios -w ./build/coreboot.rom -N`

The `-N` tells [flashprog`] to skip verification on the other regions of the
flash chip which are not being written.

### Externally

SPI chip on this mainboard is located near the SoC, on the other side
of the board (upper-right corner).
Please note that SPI voltage on this board is standard 3.3V, despite
using mobile SoC.
Vendor populated this board with Winbond W25Q128JV chip in SOIC-8 package.

Flashing coreboot using an external programmer is exactly the same as
using an internal programmer, other than the `programmer` argument:
`flashprog -p <programmer> --ifd -i bios -w ./build/coreboot.rom -N`

## Functionality

### Tested and working

- All USB ports (including mPCIe)
- All NICs (4x Intel I226-V 2.5GbE)
- All display outputs (HDMI, DisplayPort)
- M.2 NVME (PCIe x2 electrically)
- mPCIe WiFi
- SATA port
- Intel PTT (fTPM 2.0)
- PC Speaker (goes beep-boop)
- Serial console on the front of the device (RS232 in RJ45 form-factor),
"Cisco-style"
- PCIe passtrough (NICs to VMs, such as OpenWrt using libvirt)

- Payload: EDK2, LinuxBoot
- OS: Alpine Linux, Windows 11

### Untested, broken

- 5G modem on special M.2-like connector (lack hardware for it).
- Suspend in Windows 11
(might work, but Windows has been tested from USB drive).

## Specification
```{eval-rst}
+--------+-------------------------------+
| SoC    | Intel AlderLake N100 (IoT)    |
+--------+-------------------------------+
| Memory | DDR5 SO-DIMM (single-channel) |
+--------+-------------------------------+
| EC     | ITE IT8625E                   |
+--------+-------------------------------+
| SPI    | Winbond W25Q128 (16MiB 3.3V)  |
+--------+-------------------------------+
| NIC    | 4x Intel I226-V (2.5GbE)      |
+--------+-------------------------------+
```

[flashprog]: https://flashprog.org/wiki/Flashprog
[flashrom]: https://flashrom.org/
