---
c: Copyright (C) Daniel Stenberg, <daniel@haxx.se>, et al.
SPDX-License-Identifier: curl
Title: CURLINFO_REDIRECT_URL
Section: 3
Source: libcurl
See-also:
  - CURLINFO_REDIRECT_COUNT (3)
  - CURLINFO_REDIRECT_TIME_T (3)
  - CURLOPT_FOLLOWLOCATION (3)
  - curl_easy_getinfo (3)
  - curl_easy_setopt (3)
Protocol:
  - HTTP
Added-in: 7.18.2
---

# NAME

CURLINFO_REDIRECT_URL - URL a redirect would go to

# SYNOPSIS

~~~c
#include <curl/curl.h>

CURLcode curl_easy_getinfo(CURL *handle, CURLINFO_REDIRECT_URL, char **urlp);
~~~

# DESCRIPTION

Pass a pointer to a char pointer to receive the URL a redirect *would* take
you to if you would enable CURLOPT_FOLLOWLOCATION(3). This can come handy if
you think using the built-in libcurl redirect logic is not good enough for you
but you would still prefer to avoid implementing all the magic of figuring out
the new URL.

This URL is also set if the CURLOPT_MAXREDIRS(3) limit prevented a redirect to
happen (since 7.54.1).

# %PROTOCOLS%

# EXAMPLE

~~~c
int main(void)
{
  CURL *curl = curl_easy_init();
  if(curl) {
    CURLcode result;
    curl_easy_setopt(curl, CURLOPT_URL, "https://example.com");
    result = curl_easy_perform(curl);
    if(result == CURLE_OK) {
      char *url = NULL;
      curl_easy_getinfo(curl, CURLINFO_REDIRECT_URL, &url);
      if(url)
        printf("Redirect to: %s\n", url);
    }
    curl_easy_cleanup(curl);
  }
}
~~~

# %AVAILABILITY%

# RETURN VALUE

curl_easy_getinfo(3) returns a CURLcode indicating success or error.

CURLE_OK (0) means everything was OK, non-zero means an error occurred, see
libcurl-errors(3).
