//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/authorization/armauthorization/v3"
	"net/http"
	"net/url"
	"regexp"
)

// AccessReviewHistoryDefinitionInstancesServer is a fake server for instances of the armauthorization.AccessReviewHistoryDefinitionInstancesClient type.
type AccessReviewHistoryDefinitionInstancesServer struct {
	// NewListPager is the fake for method AccessReviewHistoryDefinitionInstancesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(historyDefinitionID string, options *armauthorization.AccessReviewHistoryDefinitionInstancesClientListOptions) (resp azfake.PagerResponder[armauthorization.AccessReviewHistoryDefinitionInstancesClientListResponse])
}

// NewAccessReviewHistoryDefinitionInstancesServerTransport creates a new instance of AccessReviewHistoryDefinitionInstancesServerTransport with the provided implementation.
// The returned AccessReviewHistoryDefinitionInstancesServerTransport instance is connected to an instance of armauthorization.AccessReviewHistoryDefinitionInstancesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAccessReviewHistoryDefinitionInstancesServerTransport(srv *AccessReviewHistoryDefinitionInstancesServer) *AccessReviewHistoryDefinitionInstancesServerTransport {
	return &AccessReviewHistoryDefinitionInstancesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armauthorization.AccessReviewHistoryDefinitionInstancesClientListResponse]](),
	}
}

// AccessReviewHistoryDefinitionInstancesServerTransport connects instances of armauthorization.AccessReviewHistoryDefinitionInstancesClient to instances of AccessReviewHistoryDefinitionInstancesServer.
// Don't use this type directly, use NewAccessReviewHistoryDefinitionInstancesServerTransport instead.
type AccessReviewHistoryDefinitionInstancesServerTransport struct {
	srv          *AccessReviewHistoryDefinitionInstancesServer
	newListPager *tracker[azfake.PagerResponder[armauthorization.AccessReviewHistoryDefinitionInstancesClientListResponse]]
}

// Do implements the policy.Transporter interface for AccessReviewHistoryDefinitionInstancesServerTransport.
func (a *AccessReviewHistoryDefinitionInstancesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AccessReviewHistoryDefinitionInstancesClient.NewListPager":
		resp, err = a.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AccessReviewHistoryDefinitionInstancesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/accessReviewHistoryDefinitions/(?P<historyDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		historyDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("historyDefinitionId")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListPager(historyDefinitionIDParam, nil)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armauthorization.AccessReviewHistoryDefinitionInstancesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}
