//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armbillingbenefits

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ReservationOrderAliasClient contains the methods for the ReservationOrderAlias group.
// Don't use this type directly, use NewReservationOrderAliasClient() instead.
type ReservationOrderAliasClient struct {
	internal *arm.Client
}

// NewReservationOrderAliasClient creates a new instance of ReservationOrderAliasClient with the specified values.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewReservationOrderAliasClient(credential azcore.TokenCredential, options *arm.ClientOptions) (*ReservationOrderAliasClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ReservationOrderAliasClient{
		internal: cl,
	}
	return client, nil
}

// BeginCreate - Create a reservation order alias.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01
//   - reservationOrderAliasName - Name of the reservation order alias
//   - body - Request body for creating a reservation order alias
//   - options - ReservationOrderAliasClientBeginCreateOptions contains the optional parameters for the ReservationOrderAliasClient.BeginCreate
//     method.
func (client *ReservationOrderAliasClient) BeginCreate(ctx context.Context, reservationOrderAliasName string, body ReservationOrderAliasRequest, options *ReservationOrderAliasClientBeginCreateOptions) (*runtime.Poller[ReservationOrderAliasClientCreateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.create(ctx, reservationOrderAliasName, body, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[ReservationOrderAliasClientCreateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[ReservationOrderAliasClientCreateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Create - Create a reservation order alias.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01
func (client *ReservationOrderAliasClient) create(ctx context.Context, reservationOrderAliasName string, body ReservationOrderAliasRequest, options *ReservationOrderAliasClientBeginCreateOptions) (*http.Response, error) {
	var err error
	const operationName = "ReservationOrderAliasClient.BeginCreate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, reservationOrderAliasName, body, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createCreateRequest creates the Create request.
func (client *ReservationOrderAliasClient) createCreateRequest(ctx context.Context, reservationOrderAliasName string, body ReservationOrderAliasRequest, options *ReservationOrderAliasClientBeginCreateOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.BillingBenefits/reservationOrderAliases/{reservationOrderAliasName}"
	if reservationOrderAliasName == "" {
		return nil, errors.New("parameter reservationOrderAliasName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{reservationOrderAliasName}", url.PathEscape(reservationOrderAliasName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// Get - Get a reservation order alias.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-11-01
//   - reservationOrderAliasName - Name of the reservation order alias
//   - options - ReservationOrderAliasClientGetOptions contains the optional parameters for the ReservationOrderAliasClient.Get
//     method.
func (client *ReservationOrderAliasClient) Get(ctx context.Context, reservationOrderAliasName string, options *ReservationOrderAliasClientGetOptions) (ReservationOrderAliasClientGetResponse, error) {
	var err error
	const operationName = "ReservationOrderAliasClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, reservationOrderAliasName, options)
	if err != nil {
		return ReservationOrderAliasClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ReservationOrderAliasClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ReservationOrderAliasClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ReservationOrderAliasClient) getCreateRequest(ctx context.Context, reservationOrderAliasName string, options *ReservationOrderAliasClientGetOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.BillingBenefits/reservationOrderAliases/{reservationOrderAliasName}"
	if reservationOrderAliasName == "" {
		return nil, errors.New("parameter reservationOrderAliasName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{reservationOrderAliasName}", url.PathEscape(reservationOrderAliasName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-11-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ReservationOrderAliasClient) getHandleResponse(resp *http.Response) (ReservationOrderAliasClientGetResponse, error) {
	result := ReservationOrderAliasClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ReservationOrderAliasResponse); err != nil {
		return ReservationOrderAliasClientGetResponse{}, err
	}
	return result, nil
}
