//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armkubernetesconfiguration

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AzureBlobDefinition.
func (a AzureBlobDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountKey", a.AccountKey)
	populate(objectMap, "containerName", a.ContainerName)
	populate(objectMap, "localAuthRef", a.LocalAuthRef)
	populate(objectMap, "managedIdentity", a.ManagedIdentity)
	populate(objectMap, "sasToken", a.SasToken)
	populate(objectMap, "servicePrincipal", a.ServicePrincipal)
	populate(objectMap, "syncIntervalInSeconds", a.SyncIntervalInSeconds)
	populate(objectMap, "timeoutInSeconds", a.TimeoutInSeconds)
	populate(objectMap, "url", a.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobDefinition.
func (a *AzureBlobDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountKey":
			err = unpopulate(val, "AccountKey", &a.AccountKey)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &a.ContainerName)
			delete(rawMsg, key)
		case "localAuthRef":
			err = unpopulate(val, "LocalAuthRef", &a.LocalAuthRef)
			delete(rawMsg, key)
		case "managedIdentity":
			err = unpopulate(val, "ManagedIdentity", &a.ManagedIdentity)
			delete(rawMsg, key)
		case "sasToken":
			err = unpopulate(val, "SasToken", &a.SasToken)
			delete(rawMsg, key)
		case "servicePrincipal":
			err = unpopulate(val, "ServicePrincipal", &a.ServicePrincipal)
			delete(rawMsg, key)
		case "syncIntervalInSeconds":
			err = unpopulate(val, "SyncIntervalInSeconds", &a.SyncIntervalInSeconds)
			delete(rawMsg, key)
		case "timeoutInSeconds":
			err = unpopulate(val, "TimeoutInSeconds", &a.TimeoutInSeconds)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &a.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureBlobPatchDefinition.
func (a AzureBlobPatchDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accountKey", a.AccountKey)
	populate(objectMap, "containerName", a.ContainerName)
	populate(objectMap, "localAuthRef", a.LocalAuthRef)
	populate(objectMap, "managedIdentity", a.ManagedIdentity)
	populate(objectMap, "sasToken", a.SasToken)
	populate(objectMap, "servicePrincipal", a.ServicePrincipal)
	populate(objectMap, "syncIntervalInSeconds", a.SyncIntervalInSeconds)
	populate(objectMap, "timeoutInSeconds", a.TimeoutInSeconds)
	populate(objectMap, "url", a.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureBlobPatchDefinition.
func (a *AzureBlobPatchDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accountKey":
			err = unpopulate(val, "AccountKey", &a.AccountKey)
			delete(rawMsg, key)
		case "containerName":
			err = unpopulate(val, "ContainerName", &a.ContainerName)
			delete(rawMsg, key)
		case "localAuthRef":
			err = unpopulate(val, "LocalAuthRef", &a.LocalAuthRef)
			delete(rawMsg, key)
		case "managedIdentity":
			err = unpopulate(val, "ManagedIdentity", &a.ManagedIdentity)
			delete(rawMsg, key)
		case "sasToken":
			err = unpopulate(val, "SasToken", &a.SasToken)
			delete(rawMsg, key)
		case "servicePrincipal":
			err = unpopulate(val, "ServicePrincipal", &a.ServicePrincipal)
			delete(rawMsg, key)
		case "syncIntervalInSeconds":
			err = unpopulate(val, "SyncIntervalInSeconds", &a.SyncIntervalInSeconds)
			delete(rawMsg, key)
		case "timeoutInSeconds":
			err = unpopulate(val, "TimeoutInSeconds", &a.TimeoutInSeconds)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &a.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BucketDefinition.
func (b BucketDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessKey", b.AccessKey)
	populate(objectMap, "bucketName", b.BucketName)
	populate(objectMap, "insecure", b.Insecure)
	populate(objectMap, "localAuthRef", b.LocalAuthRef)
	populate(objectMap, "syncIntervalInSeconds", b.SyncIntervalInSeconds)
	populate(objectMap, "timeoutInSeconds", b.TimeoutInSeconds)
	populate(objectMap, "url", b.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BucketDefinition.
func (b *BucketDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessKey":
			err = unpopulate(val, "AccessKey", &b.AccessKey)
			delete(rawMsg, key)
		case "bucketName":
			err = unpopulate(val, "BucketName", &b.BucketName)
			delete(rawMsg, key)
		case "insecure":
			err = unpopulate(val, "Insecure", &b.Insecure)
			delete(rawMsg, key)
		case "localAuthRef":
			err = unpopulate(val, "LocalAuthRef", &b.LocalAuthRef)
			delete(rawMsg, key)
		case "syncIntervalInSeconds":
			err = unpopulate(val, "SyncIntervalInSeconds", &b.SyncIntervalInSeconds)
			delete(rawMsg, key)
		case "timeoutInSeconds":
			err = unpopulate(val, "TimeoutInSeconds", &b.TimeoutInSeconds)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &b.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type BucketPatchDefinition.
func (b BucketPatchDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "accessKey", b.AccessKey)
	populate(objectMap, "bucketName", b.BucketName)
	populate(objectMap, "insecure", b.Insecure)
	populate(objectMap, "localAuthRef", b.LocalAuthRef)
	populate(objectMap, "syncIntervalInSeconds", b.SyncIntervalInSeconds)
	populate(objectMap, "timeoutInSeconds", b.TimeoutInSeconds)
	populate(objectMap, "url", b.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type BucketPatchDefinition.
func (b *BucketPatchDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", b, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "accessKey":
			err = unpopulate(val, "AccessKey", &b.AccessKey)
			delete(rawMsg, key)
		case "bucketName":
			err = unpopulate(val, "BucketName", &b.BucketName)
			delete(rawMsg, key)
		case "insecure":
			err = unpopulate(val, "Insecure", &b.Insecure)
			delete(rawMsg, key)
		case "localAuthRef":
			err = unpopulate(val, "LocalAuthRef", &b.LocalAuthRef)
			delete(rawMsg, key)
		case "syncIntervalInSeconds":
			err = unpopulate(val, "SyncIntervalInSeconds", &b.SyncIntervalInSeconds)
			delete(rawMsg, key)
		case "timeoutInSeconds":
			err = unpopulate(val, "TimeoutInSeconds", &b.TimeoutInSeconds)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &b.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", b, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ComplianceStatus.
func (c ComplianceStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "complianceState", c.ComplianceState)
	populateDateTimeRFC3339(objectMap, "lastConfigApplied", c.LastConfigApplied)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "messageLevel", c.MessageLevel)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ComplianceStatus.
func (c *ComplianceStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "complianceState":
			err = unpopulate(val, "ComplianceState", &c.ComplianceState)
			delete(rawMsg, key)
		case "lastConfigApplied":
			err = unpopulateDateTimeRFC3339(val, "LastConfigApplied", &c.LastConfigApplied)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "messageLevel":
			err = unpopulate(val, "MessageLevel", &c.MessageLevel)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorAdditionalInfo.
func (e ErrorAdditionalInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateAny(objectMap, "info", e.Info)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorAdditionalInfo.
func (e *ErrorAdditionalInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "info":
			err = unpopulate(val, "Info", &e.Info)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorDetail.
func (e ErrorDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "additionalInfo", e.AdditionalInfo)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "details", e.Details)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "target", e.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorDetail.
func (e *ErrorDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "additionalInfo":
			err = unpopulate(val, "AdditionalInfo", &e.AdditionalInfo)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &e.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &e.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorResponse.
func (e ErrorResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", e.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorResponse.
func (e *ErrorResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &e.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Extension.
func (e Extension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "identity", e.Identity)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "plan", e.Plan)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "systemData", e.SystemData)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Extension.
func (e *Extension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &e.Identity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "plan":
			err = unpopulate(val, "Plan", &e.Plan)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &e.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtensionProperties.
func (e ExtensionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aksAssignedIdentity", e.AksAssignedIdentity)
	populate(objectMap, "autoUpgradeMinorVersion", e.AutoUpgradeMinorVersion)
	populate(objectMap, "configurationProtectedSettings", e.ConfigurationProtectedSettings)
	populate(objectMap, "configurationSettings", e.ConfigurationSettings)
	populate(objectMap, "currentVersion", e.CurrentVersion)
	populate(objectMap, "customLocationSettings", e.CustomLocationSettings)
	populate(objectMap, "errorInfo", e.ErrorInfo)
	populate(objectMap, "extensionType", e.ExtensionType)
	populate(objectMap, "isSystemExtension", e.IsSystemExtension)
	populate(objectMap, "packageUri", e.PackageURI)
	populate(objectMap, "provisioningState", e.ProvisioningState)
	populate(objectMap, "releaseTrain", e.ReleaseTrain)
	populate(objectMap, "scope", e.Scope)
	populate(objectMap, "statuses", e.Statuses)
	populate(objectMap, "version", e.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtensionProperties.
func (e *ExtensionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aksAssignedIdentity":
			err = unpopulate(val, "AksAssignedIdentity", &e.AksAssignedIdentity)
			delete(rawMsg, key)
		case "autoUpgradeMinorVersion":
			err = unpopulate(val, "AutoUpgradeMinorVersion", &e.AutoUpgradeMinorVersion)
			delete(rawMsg, key)
		case "configurationProtectedSettings":
			err = unpopulate(val, "ConfigurationProtectedSettings", &e.ConfigurationProtectedSettings)
			delete(rawMsg, key)
		case "configurationSettings":
			err = unpopulate(val, "ConfigurationSettings", &e.ConfigurationSettings)
			delete(rawMsg, key)
		case "currentVersion":
			err = unpopulate(val, "CurrentVersion", &e.CurrentVersion)
			delete(rawMsg, key)
		case "customLocationSettings":
			err = unpopulate(val, "CustomLocationSettings", &e.CustomLocationSettings)
			delete(rawMsg, key)
		case "errorInfo":
			err = unpopulate(val, "ErrorInfo", &e.ErrorInfo)
			delete(rawMsg, key)
		case "extensionType":
			err = unpopulate(val, "ExtensionType", &e.ExtensionType)
			delete(rawMsg, key)
		case "isSystemExtension":
			err = unpopulate(val, "IsSystemExtension", &e.IsSystemExtension)
			delete(rawMsg, key)
		case "packageUri":
			err = unpopulate(val, "PackageURI", &e.PackageURI)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &e.ProvisioningState)
			delete(rawMsg, key)
		case "releaseTrain":
			err = unpopulate(val, "ReleaseTrain", &e.ReleaseTrain)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &e.Scope)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &e.Statuses)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &e.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtensionPropertiesAksAssignedIdentity.
func (e ExtensionPropertiesAksAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", e.PrincipalID)
	populate(objectMap, "tenantId", e.TenantID)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtensionPropertiesAksAssignedIdentity.
func (e *ExtensionPropertiesAksAssignedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &e.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &e.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtensionStatus.
func (e ExtensionStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", e.Code)
	populate(objectMap, "displayStatus", e.DisplayStatus)
	populate(objectMap, "level", e.Level)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "time", e.Time)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtensionStatus.
func (e *ExtensionStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "displayStatus":
			err = unpopulate(val, "DisplayStatus", &e.DisplayStatus)
			delete(rawMsg, key)
		case "level":
			err = unpopulate(val, "Level", &e.Level)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "time":
			err = unpopulate(val, "Time", &e.Time)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtensionsList.
func (e ExtensionsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtensionsList.
func (e *ExtensionsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FluxConfiguration.
func (f FluxConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "systemData", f.SystemData)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FluxConfiguration.
func (f *FluxConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &f.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FluxConfigurationPatch.
func (f FluxConfigurationPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", f.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FluxConfigurationPatch.
func (f *FluxConfigurationPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FluxConfigurationPatchProperties.
func (f FluxConfigurationPatchProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureBlob", f.AzureBlob)
	populate(objectMap, "bucket", f.Bucket)
	populate(objectMap, "configurationProtectedSettings", f.ConfigurationProtectedSettings)
	populate(objectMap, "gitRepository", f.GitRepository)
	populate(objectMap, "kustomizations", f.Kustomizations)
	populate(objectMap, "sourceKind", f.SourceKind)
	populate(objectMap, "suspend", f.Suspend)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FluxConfigurationPatchProperties.
func (f *FluxConfigurationPatchProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureBlob":
			err = unpopulate(val, "AzureBlob", &f.AzureBlob)
			delete(rawMsg, key)
		case "bucket":
			err = unpopulate(val, "Bucket", &f.Bucket)
			delete(rawMsg, key)
		case "configurationProtectedSettings":
			err = unpopulate(val, "ConfigurationProtectedSettings", &f.ConfigurationProtectedSettings)
			delete(rawMsg, key)
		case "gitRepository":
			err = unpopulate(val, "GitRepository", &f.GitRepository)
			delete(rawMsg, key)
		case "kustomizations":
			err = unpopulate(val, "Kustomizations", &f.Kustomizations)
			delete(rawMsg, key)
		case "sourceKind":
			err = unpopulate(val, "SourceKind", &f.SourceKind)
			delete(rawMsg, key)
		case "suspend":
			err = unpopulate(val, "Suspend", &f.Suspend)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FluxConfigurationProperties.
func (f FluxConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureBlob", f.AzureBlob)
	populate(objectMap, "bucket", f.Bucket)
	populate(objectMap, "complianceState", f.ComplianceState)
	populate(objectMap, "configurationProtectedSettings", f.ConfigurationProtectedSettings)
	populate(objectMap, "errorMessage", f.ErrorMessage)
	populate(objectMap, "gitRepository", f.GitRepository)
	populate(objectMap, "kustomizations", f.Kustomizations)
	populate(objectMap, "namespace", f.Namespace)
	populate(objectMap, "provisioningState", f.ProvisioningState)
	populate(objectMap, "reconciliationWaitDuration", f.ReconciliationWaitDuration)
	populate(objectMap, "repositoryPublicKey", f.RepositoryPublicKey)
	populate(objectMap, "scope", f.Scope)
	populate(objectMap, "sourceKind", f.SourceKind)
	populate(objectMap, "sourceSyncedCommitId", f.SourceSyncedCommitID)
	populateDateTimeRFC3339(objectMap, "sourceUpdatedAt", f.SourceUpdatedAt)
	populateDateTimeRFC3339(objectMap, "statusUpdatedAt", f.StatusUpdatedAt)
	populate(objectMap, "statuses", f.Statuses)
	populate(objectMap, "suspend", f.Suspend)
	populate(objectMap, "waitForReconciliation", f.WaitForReconciliation)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FluxConfigurationProperties.
func (f *FluxConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureBlob":
			err = unpopulate(val, "AzureBlob", &f.AzureBlob)
			delete(rawMsg, key)
		case "bucket":
			err = unpopulate(val, "Bucket", &f.Bucket)
			delete(rawMsg, key)
		case "complianceState":
			err = unpopulate(val, "ComplianceState", &f.ComplianceState)
			delete(rawMsg, key)
		case "configurationProtectedSettings":
			err = unpopulate(val, "ConfigurationProtectedSettings", &f.ConfigurationProtectedSettings)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &f.ErrorMessage)
			delete(rawMsg, key)
		case "gitRepository":
			err = unpopulate(val, "GitRepository", &f.GitRepository)
			delete(rawMsg, key)
		case "kustomizations":
			err = unpopulate(val, "Kustomizations", &f.Kustomizations)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &f.Namespace)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &f.ProvisioningState)
			delete(rawMsg, key)
		case "reconciliationWaitDuration":
			err = unpopulate(val, "ReconciliationWaitDuration", &f.ReconciliationWaitDuration)
			delete(rawMsg, key)
		case "repositoryPublicKey":
			err = unpopulate(val, "RepositoryPublicKey", &f.RepositoryPublicKey)
			delete(rawMsg, key)
		case "scope":
			err = unpopulate(val, "Scope", &f.Scope)
			delete(rawMsg, key)
		case "sourceKind":
			err = unpopulate(val, "SourceKind", &f.SourceKind)
			delete(rawMsg, key)
		case "sourceSyncedCommitId":
			err = unpopulate(val, "SourceSyncedCommitID", &f.SourceSyncedCommitID)
			delete(rawMsg, key)
		case "sourceUpdatedAt":
			err = unpopulateDateTimeRFC3339(val, "SourceUpdatedAt", &f.SourceUpdatedAt)
			delete(rawMsg, key)
		case "statusUpdatedAt":
			err = unpopulateDateTimeRFC3339(val, "StatusUpdatedAt", &f.StatusUpdatedAt)
			delete(rawMsg, key)
		case "statuses":
			err = unpopulate(val, "Statuses", &f.Statuses)
			delete(rawMsg, key)
		case "suspend":
			err = unpopulate(val, "Suspend", &f.Suspend)
			delete(rawMsg, key)
		case "waitForReconciliation":
			err = unpopulate(val, "WaitForReconciliation", &f.WaitForReconciliation)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FluxConfigurationsList.
func (f FluxConfigurationsList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FluxConfigurationsList.
func (f *FluxConfigurationsList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GitRepositoryDefinition.
func (g GitRepositoryDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "httpsCACert", g.HTTPSCACert)
	populate(objectMap, "httpsUser", g.HTTPSUser)
	populate(objectMap, "localAuthRef", g.LocalAuthRef)
	populate(objectMap, "repositoryRef", g.RepositoryRef)
	populate(objectMap, "sshKnownHosts", g.SSHKnownHosts)
	populate(objectMap, "syncIntervalInSeconds", g.SyncIntervalInSeconds)
	populate(objectMap, "timeoutInSeconds", g.TimeoutInSeconds)
	populate(objectMap, "url", g.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GitRepositoryDefinition.
func (g *GitRepositoryDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "httpsCACert":
			err = unpopulate(val, "HTTPSCACert", &g.HTTPSCACert)
			delete(rawMsg, key)
		case "httpsUser":
			err = unpopulate(val, "HTTPSUser", &g.HTTPSUser)
			delete(rawMsg, key)
		case "localAuthRef":
			err = unpopulate(val, "LocalAuthRef", &g.LocalAuthRef)
			delete(rawMsg, key)
		case "repositoryRef":
			err = unpopulate(val, "RepositoryRef", &g.RepositoryRef)
			delete(rawMsg, key)
		case "sshKnownHosts":
			err = unpopulate(val, "SSHKnownHosts", &g.SSHKnownHosts)
			delete(rawMsg, key)
		case "syncIntervalInSeconds":
			err = unpopulate(val, "SyncIntervalInSeconds", &g.SyncIntervalInSeconds)
			delete(rawMsg, key)
		case "timeoutInSeconds":
			err = unpopulate(val, "TimeoutInSeconds", &g.TimeoutInSeconds)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &g.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GitRepositoryPatchDefinition.
func (g GitRepositoryPatchDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "httpsCACert", g.HTTPSCACert)
	populate(objectMap, "httpsUser", g.HTTPSUser)
	populate(objectMap, "localAuthRef", g.LocalAuthRef)
	populate(objectMap, "repositoryRef", g.RepositoryRef)
	populate(objectMap, "sshKnownHosts", g.SSHKnownHosts)
	populate(objectMap, "syncIntervalInSeconds", g.SyncIntervalInSeconds)
	populate(objectMap, "timeoutInSeconds", g.TimeoutInSeconds)
	populate(objectMap, "url", g.URL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GitRepositoryPatchDefinition.
func (g *GitRepositoryPatchDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "httpsCACert":
			err = unpopulate(val, "HTTPSCACert", &g.HTTPSCACert)
			delete(rawMsg, key)
		case "httpsUser":
			err = unpopulate(val, "HTTPSUser", &g.HTTPSUser)
			delete(rawMsg, key)
		case "localAuthRef":
			err = unpopulate(val, "LocalAuthRef", &g.LocalAuthRef)
			delete(rawMsg, key)
		case "repositoryRef":
			err = unpopulate(val, "RepositoryRef", &g.RepositoryRef)
			delete(rawMsg, key)
		case "sshKnownHosts":
			err = unpopulate(val, "SSHKnownHosts", &g.SSHKnownHosts)
			delete(rawMsg, key)
		case "syncIntervalInSeconds":
			err = unpopulate(val, "SyncIntervalInSeconds", &g.SyncIntervalInSeconds)
			delete(rawMsg, key)
		case "timeoutInSeconds":
			err = unpopulate(val, "TimeoutInSeconds", &g.TimeoutInSeconds)
			delete(rawMsg, key)
		case "url":
			err = unpopulate(val, "URL", &g.URL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HelmOperatorProperties.
func (h HelmOperatorProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "chartValues", h.ChartValues)
	populate(objectMap, "chartVersion", h.ChartVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HelmOperatorProperties.
func (h *HelmOperatorProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "chartValues":
			err = unpopulate(val, "ChartValues", &h.ChartValues)
			delete(rawMsg, key)
		case "chartVersion":
			err = unpopulate(val, "ChartVersion", &h.ChartVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HelmReleasePropertiesDefinition.
func (h HelmReleasePropertiesDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "failureCount", h.FailureCount)
	populate(objectMap, "helmChartRef", h.HelmChartRef)
	populate(objectMap, "installFailureCount", h.InstallFailureCount)
	populate(objectMap, "lastRevisionApplied", h.LastRevisionApplied)
	populate(objectMap, "upgradeFailureCount", h.UpgradeFailureCount)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HelmReleasePropertiesDefinition.
func (h *HelmReleasePropertiesDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "failureCount":
			err = unpopulate(val, "FailureCount", &h.FailureCount)
			delete(rawMsg, key)
		case "helmChartRef":
			err = unpopulate(val, "HelmChartRef", &h.HelmChartRef)
			delete(rawMsg, key)
		case "installFailureCount":
			err = unpopulate(val, "InstallFailureCount", &h.InstallFailureCount)
			delete(rawMsg, key)
		case "lastRevisionApplied":
			err = unpopulate(val, "LastRevisionApplied", &h.LastRevisionApplied)
			delete(rawMsg, key)
		case "upgradeFailureCount":
			err = unpopulate(val, "UpgradeFailureCount", &h.UpgradeFailureCount)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Identity.
func (i Identity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "principalId", i.PrincipalID)
	populate(objectMap, "tenantId", i.TenantID)
	objectMap["type"] = "SystemAssigned"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Identity.
func (i *Identity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "principalId":
			err = unpopulate(val, "PrincipalID", &i.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &i.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &i.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KustomizationDefinition.
func (k KustomizationDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", k.DependsOn)
	populate(objectMap, "force", k.Force)
	populate(objectMap, "name", k.Name)
	populate(objectMap, "path", k.Path)
	populate(objectMap, "postBuild", k.PostBuild)
	populate(objectMap, "prune", k.Prune)
	populate(objectMap, "retryIntervalInSeconds", k.RetryIntervalInSeconds)
	populate(objectMap, "syncIntervalInSeconds", k.SyncIntervalInSeconds)
	populate(objectMap, "timeoutInSeconds", k.TimeoutInSeconds)
	populate(objectMap, "wait", k.Wait)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KustomizationDefinition.
func (k *KustomizationDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &k.DependsOn)
			delete(rawMsg, key)
		case "force":
			err = unpopulate(val, "Force", &k.Force)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &k.Name)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &k.Path)
			delete(rawMsg, key)
		case "postBuild":
			err = unpopulate(val, "PostBuild", &k.PostBuild)
			delete(rawMsg, key)
		case "prune":
			err = unpopulate(val, "Prune", &k.Prune)
			delete(rawMsg, key)
		case "retryIntervalInSeconds":
			err = unpopulate(val, "RetryIntervalInSeconds", &k.RetryIntervalInSeconds)
			delete(rawMsg, key)
		case "syncIntervalInSeconds":
			err = unpopulate(val, "SyncIntervalInSeconds", &k.SyncIntervalInSeconds)
			delete(rawMsg, key)
		case "timeoutInSeconds":
			err = unpopulate(val, "TimeoutInSeconds", &k.TimeoutInSeconds)
			delete(rawMsg, key)
		case "wait":
			err = unpopulate(val, "Wait", &k.Wait)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KustomizationPatchDefinition.
func (k KustomizationPatchDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dependsOn", k.DependsOn)
	populate(objectMap, "force", k.Force)
	populate(objectMap, "path", k.Path)
	populate(objectMap, "postBuild", k.PostBuild)
	populate(objectMap, "prune", k.Prune)
	populate(objectMap, "retryIntervalInSeconds", k.RetryIntervalInSeconds)
	populate(objectMap, "syncIntervalInSeconds", k.SyncIntervalInSeconds)
	populate(objectMap, "timeoutInSeconds", k.TimeoutInSeconds)
	populate(objectMap, "wait", k.Wait)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KustomizationPatchDefinition.
func (k *KustomizationPatchDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dependsOn":
			err = unpopulate(val, "DependsOn", &k.DependsOn)
			delete(rawMsg, key)
		case "force":
			err = unpopulate(val, "Force", &k.Force)
			delete(rawMsg, key)
		case "path":
			err = unpopulate(val, "Path", &k.Path)
			delete(rawMsg, key)
		case "postBuild":
			err = unpopulate(val, "PostBuild", &k.PostBuild)
			delete(rawMsg, key)
		case "prune":
			err = unpopulate(val, "Prune", &k.Prune)
			delete(rawMsg, key)
		case "retryIntervalInSeconds":
			err = unpopulate(val, "RetryIntervalInSeconds", &k.RetryIntervalInSeconds)
			delete(rawMsg, key)
		case "syncIntervalInSeconds":
			err = unpopulate(val, "SyncIntervalInSeconds", &k.SyncIntervalInSeconds)
			delete(rawMsg, key)
		case "timeoutInSeconds":
			err = unpopulate(val, "TimeoutInSeconds", &k.TimeoutInSeconds)
			delete(rawMsg, key)
		case "wait":
			err = unpopulate(val, "Wait", &k.Wait)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedIdentityDefinition.
func (m ManagedIdentityDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", m.ClientID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIdentityDefinition.
func (m *ManagedIdentityDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &m.ClientID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedIdentityPatchDefinition.
func (m ManagedIdentityPatchDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", m.ClientID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedIdentityPatchDefinition.
func (m *ManagedIdentityPatchDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &m.ClientID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ObjectReferenceDefinition.
func (o ObjectReferenceDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "namespace", o.Namespace)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ObjectReferenceDefinition.
func (o *ObjectReferenceDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &o.Namespace)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ObjectStatusConditionDefinition.
func (o ObjectStatusConditionDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "lastTransitionTime", o.LastTransitionTime)
	populate(objectMap, "message", o.Message)
	populate(objectMap, "reason", o.Reason)
	populate(objectMap, "status", o.Status)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ObjectStatusConditionDefinition.
func (o *ObjectStatusConditionDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "lastTransitionTime":
			err = unpopulateDateTimeRFC3339(val, "LastTransitionTime", &o.LastTransitionTime)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &o.Message)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &o.Reason)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ObjectStatusDefinition.
func (o ObjectStatusDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appliedBy", o.AppliedBy)
	populate(objectMap, "complianceState", o.ComplianceState)
	populate(objectMap, "helmReleaseProperties", o.HelmReleaseProperties)
	populate(objectMap, "kind", o.Kind)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "namespace", o.Namespace)
	populate(objectMap, "statusConditions", o.StatusConditions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ObjectStatusDefinition.
func (o *ObjectStatusDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appliedBy":
			err = unpopulate(val, "AppliedBy", &o.AppliedBy)
			delete(rawMsg, key)
		case "complianceState":
			err = unpopulate(val, "ComplianceState", &o.ComplianceState)
			delete(rawMsg, key)
		case "helmReleaseProperties":
			err = unpopulate(val, "HelmReleaseProperties", &o.HelmReleaseProperties)
			delete(rawMsg, key)
		case "kind":
			err = unpopulate(val, "Kind", &o.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &o.Namespace)
			delete(rawMsg, key)
		case "statusConditions":
			err = unpopulate(val, "StatusConditions", &o.StatusConditions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationStatusList.
func (o OperationStatusList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationStatusList.
func (o *OperationStatusList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationStatusResult.
func (o OperationStatusResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", o.Error)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "status", o.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationStatusResult.
func (o *OperationStatusResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &o.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PatchExtension.
func (p PatchExtension) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PatchExtension.
func (p *PatchExtension) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PatchExtensionProperties.
func (p PatchExtensionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "autoUpgradeMinorVersion", p.AutoUpgradeMinorVersion)
	populate(objectMap, "configurationProtectedSettings", p.ConfigurationProtectedSettings)
	populate(objectMap, "configurationSettings", p.ConfigurationSettings)
	populate(objectMap, "releaseTrain", p.ReleaseTrain)
	populate(objectMap, "version", p.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PatchExtensionProperties.
func (p *PatchExtensionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "autoUpgradeMinorVersion":
			err = unpopulate(val, "AutoUpgradeMinorVersion", &p.AutoUpgradeMinorVersion)
			delete(rawMsg, key)
		case "configurationProtectedSettings":
			err = unpopulate(val, "ConfigurationProtectedSettings", &p.ConfigurationProtectedSettings)
			delete(rawMsg, key)
		case "configurationSettings":
			err = unpopulate(val, "ConfigurationSettings", &p.ConfigurationSettings)
			delete(rawMsg, key)
		case "releaseTrain":
			err = unpopulate(val, "ReleaseTrain", &p.ReleaseTrain)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &p.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Plan.
func (p Plan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "product", p.Product)
	populate(objectMap, "promotionCode", p.PromotionCode)
	populate(objectMap, "publisher", p.Publisher)
	populate(objectMap, "version", p.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Plan.
func (p *Plan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "product":
			err = unpopulate(val, "Product", &p.Product)
			delete(rawMsg, key)
		case "promotionCode":
			err = unpopulate(val, "PromotionCode", &p.PromotionCode)
			delete(rawMsg, key)
		case "publisher":
			err = unpopulate(val, "Publisher", &p.Publisher)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &p.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PostBuildDefinition.
func (p PostBuildDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "substitute", p.Substitute)
	populate(objectMap, "substituteFrom", p.SubstituteFrom)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PostBuildDefinition.
func (p *PostBuildDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "substitute":
			err = unpopulate(val, "Substitute", &p.Substitute)
			delete(rawMsg, key)
		case "substituteFrom":
			err = unpopulate(val, "SubstituteFrom", &p.SubstituteFrom)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProxyResource.
func (p ProxyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProxyResource.
func (p *ProxyResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RepositoryRefDefinition.
func (r RepositoryRefDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "branch", r.Branch)
	populate(objectMap, "commit", r.Commit)
	populate(objectMap, "semver", r.Semver)
	populate(objectMap, "tag", r.Tag)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RepositoryRefDefinition.
func (r *RepositoryRefDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "branch":
			err = unpopulate(val, "Branch", &r.Branch)
			delete(rawMsg, key)
		case "commit":
			err = unpopulate(val, "Commit", &r.Commit)
			delete(rawMsg, key)
		case "semver":
			err = unpopulate(val, "Semver", &r.Semver)
			delete(rawMsg, key)
		case "tag":
			err = unpopulate(val, "Tag", &r.Tag)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Resource.
func (r *Resource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderOperation.
func (r ResourceProviderOperation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", r.Display)
	populate(objectMap, "isDataAction", r.IsDataAction)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "origin", r.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderOperation.
func (r *ResourceProviderOperation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &r.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &r.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &r.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderOperationDisplay.
func (r ResourceProviderOperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", r.Description)
	populate(objectMap, "operation", r.Operation)
	populate(objectMap, "provider", r.Provider)
	populate(objectMap, "resource", r.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderOperationDisplay.
func (r *ResourceProviderOperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &r.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &r.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &r.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &r.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceProviderOperationList.
func (r ResourceProviderOperationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceProviderOperationList.
func (r *ResourceProviderOperationList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Scope.
func (s Scope) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "cluster", s.Cluster)
	populate(objectMap, "namespace", s.Namespace)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Scope.
func (s *Scope) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "cluster":
			err = unpopulate(val, "Cluster", &s.Cluster)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &s.Namespace)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScopeCluster.
func (s ScopeCluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "releaseNamespace", s.ReleaseNamespace)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScopeCluster.
func (s *ScopeCluster) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "releaseNamespace":
			err = unpopulate(val, "ReleaseNamespace", &s.ReleaseNamespace)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ScopeNamespace.
func (s ScopeNamespace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "targetNamespace", s.TargetNamespace)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ScopeNamespace.
func (s *ScopeNamespace) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "targetNamespace":
			err = unpopulate(val, "TargetNamespace", &s.TargetNamespace)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServicePrincipalDefinition.
func (s ServicePrincipalDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientCertificate", s.ClientCertificate)
	populate(objectMap, "clientCertificatePassword", s.ClientCertificatePassword)
	populate(objectMap, "clientCertificateSendChain", s.ClientCertificateSendChain)
	populate(objectMap, "clientId", s.ClientID)
	populate(objectMap, "clientSecret", s.ClientSecret)
	populate(objectMap, "tenantId", s.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServicePrincipalDefinition.
func (s *ServicePrincipalDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientCertificate":
			err = unpopulate(val, "ClientCertificate", &s.ClientCertificate)
			delete(rawMsg, key)
		case "clientCertificatePassword":
			err = unpopulate(val, "ClientCertificatePassword", &s.ClientCertificatePassword)
			delete(rawMsg, key)
		case "clientCertificateSendChain":
			err = unpopulate(val, "ClientCertificateSendChain", &s.ClientCertificateSendChain)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &s.ClientID)
			delete(rawMsg, key)
		case "clientSecret":
			err = unpopulate(val, "ClientSecret", &s.ClientSecret)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &s.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServicePrincipalPatchDefinition.
func (s ServicePrincipalPatchDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientCertificate", s.ClientCertificate)
	populate(objectMap, "clientCertificatePassword", s.ClientCertificatePassword)
	populate(objectMap, "clientCertificateSendChain", s.ClientCertificateSendChain)
	populate(objectMap, "clientId", s.ClientID)
	populate(objectMap, "clientSecret", s.ClientSecret)
	populate(objectMap, "tenantId", s.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServicePrincipalPatchDefinition.
func (s *ServicePrincipalPatchDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientCertificate":
			err = unpopulate(val, "ClientCertificate", &s.ClientCertificate)
			delete(rawMsg, key)
		case "clientCertificatePassword":
			err = unpopulate(val, "ClientCertificatePassword", &s.ClientCertificatePassword)
			delete(rawMsg, key)
		case "clientCertificateSendChain":
			err = unpopulate(val, "ClientCertificateSendChain", &s.ClientCertificateSendChain)
			delete(rawMsg, key)
		case "clientId":
			err = unpopulate(val, "ClientID", &s.ClientID)
			delete(rawMsg, key)
		case "clientSecret":
			err = unpopulate(val, "ClientSecret", &s.ClientSecret)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &s.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlConfiguration.
func (s SourceControlConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlConfiguration.
func (s *SourceControlConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlConfigurationList.
func (s SourceControlConfigurationList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlConfigurationList.
func (s *SourceControlConfigurationList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SourceControlConfigurationProperties.
func (s SourceControlConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "complianceStatus", s.ComplianceStatus)
	populate(objectMap, "configurationProtectedSettings", s.ConfigurationProtectedSettings)
	populate(objectMap, "enableHelmOperator", s.EnableHelmOperator)
	populate(objectMap, "helmOperatorProperties", s.HelmOperatorProperties)
	populate(objectMap, "operatorInstanceName", s.OperatorInstanceName)
	populate(objectMap, "operatorNamespace", s.OperatorNamespace)
	populate(objectMap, "operatorParams", s.OperatorParams)
	populate(objectMap, "operatorScope", s.OperatorScope)
	populate(objectMap, "operatorType", s.OperatorType)
	populate(objectMap, "provisioningState", s.ProvisioningState)
	populate(objectMap, "repositoryPublicKey", s.RepositoryPublicKey)
	populate(objectMap, "repositoryUrl", s.RepositoryURL)
	populate(objectMap, "sshKnownHostsContents", s.SSHKnownHostsContents)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SourceControlConfigurationProperties.
func (s *SourceControlConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "complianceStatus":
			err = unpopulate(val, "ComplianceStatus", &s.ComplianceStatus)
			delete(rawMsg, key)
		case "configurationProtectedSettings":
			err = unpopulate(val, "ConfigurationProtectedSettings", &s.ConfigurationProtectedSettings)
			delete(rawMsg, key)
		case "enableHelmOperator":
			err = unpopulate(val, "EnableHelmOperator", &s.EnableHelmOperator)
			delete(rawMsg, key)
		case "helmOperatorProperties":
			err = unpopulate(val, "HelmOperatorProperties", &s.HelmOperatorProperties)
			delete(rawMsg, key)
		case "operatorInstanceName":
			err = unpopulate(val, "OperatorInstanceName", &s.OperatorInstanceName)
			delete(rawMsg, key)
		case "operatorNamespace":
			err = unpopulate(val, "OperatorNamespace", &s.OperatorNamespace)
			delete(rawMsg, key)
		case "operatorParams":
			err = unpopulate(val, "OperatorParams", &s.OperatorParams)
			delete(rawMsg, key)
		case "operatorScope":
			err = unpopulate(val, "OperatorScope", &s.OperatorScope)
			delete(rawMsg, key)
		case "operatorType":
			err = unpopulate(val, "OperatorType", &s.OperatorType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &s.ProvisioningState)
			delete(rawMsg, key)
		case "repositoryPublicKey":
			err = unpopulate(val, "RepositoryPublicKey", &s.RepositoryPublicKey)
			delete(rawMsg, key)
		case "repositoryUrl":
			err = unpopulate(val, "RepositoryURL", &s.RepositoryURL)
			delete(rawMsg, key)
		case "sshKnownHostsContents":
			err = unpopulate(val, "SSHKnownHostsContents", &s.SSHKnownHostsContents)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SubstituteFromDefinition.
func (s SubstituteFromDefinition) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "kind", s.Kind)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "optional", s.Optional)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SubstituteFromDefinition.
func (s *SubstituteFromDefinition) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kind":
			err = unpopulate(val, "Kind", &s.Kind)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "optional":
			err = unpopulate(val, "Optional", &s.Optional)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateAny(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
