// Copyright (c) Meta Platforms, Inc. and affiliates.

#ifndef ZSTRONG_TRANSFORMS_DISPATCHN_BYTAG_ENCODE_DISPATCHN_BYTAG_BINDING_H
#define ZSTRONG_TRANSFORMS_DISPATCHN_BYTAG_ENCODE_DISPATCHN_BYTAG_BINDING_H

#include "openzl/codecs/dispatchN_byTag/graph_dispatchN_byTag.h" // GRAPH_DIPATCHNBYTAG
#include "openzl/shared/portability.h"
#include "openzl/zl_ctransform.h" // ZL_Encoder

ZL_BEGIN_C_DECLS

#if 0
// For information : already declared in zs2_public_nodes.h

ZL_NodeID ZL_Compressor_registerDispatchNode(
        ZL_Compressor* cgraph,
        ZL_DispatchParserFn f,
        void const* opaque);
#endif

/* EI_dispatchN_byTag() :
 * splits serialized input into 2 numeric + N serialized outputs.
 * Instructions on how to split are generated by a parsing function,
 * which is transmitted through generic parameters
 * on paramID = ZL_DISPATCHNBYTAG_PARSINGF_PID.
 */
ZL_Report
EI_dispatchN_byTag(ZL_Encoder* eictx, const ZL_Input* ins[], size_t nbIns);

#define EI_DISPATCHNBYTAG(id)                                             \
    {                                                                     \
        .gd = GRAPH_DIPATCHNBYTAG(id), .transform_f = EI_dispatchN_byTag, \
        .name = "!zl.dispatchN_byTag"                                     \
    }

ZL_END_C_DECLS

#endif // ZSTRONG_TRANSFORMS_DISPATCHN_BYTAG_ENCODE_DISPATCHN_BYTAG_BINDING_H
