/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (C) STMicroelectronics 2023 - All Rights Reserved
 * Author: Gabriel Fernandez <gabriel.fernandez@foss.st.com> for STMicroelectronics.
 */

#ifndef STM32MP25_RCC_H
#define STM32MP25_RCC_H

#define RCC_SECCFGR0				0x0
#define RCC_SECCFGR1				0x4
#define RCC_SECCFGR2				0x8
#define RCC_SECCFGR3				0xC
#define RCC_PRIVCFGR0				0x10
#define RCC_PRIVCFGR1				0x14
#define RCC_PRIVCFGR2				0x18
#define RCC_PRIVCFGR3				0x1C
#define RCC_RCFGLOCKR0				0x20
#define RCC_RCFGLOCKR1				0x24
#define RCC_RCFGLOCKR2				0x28
#define RCC_RCFGLOCKR3				0x2C
#define RCC_R0CIDCFGR				0x30
#define RCC_R0SEMCR				0x34
#define RCC_R1CIDCFGR				0x38
#define RCC_R1SEMCR				0x3C
#define RCC_R2CIDCFGR				0x40
#define RCC_R2SEMCR				0x44
#define RCC_R3CIDCFGR				0x48
#define RCC_R3SEMCR				0x4C
#define RCC_R4CIDCFGR				0x50
#define RCC_R4SEMCR				0x54
#define RCC_R5CIDCFGR				0x58
#define RCC_R5SEMCR				0x5C
#define RCC_R6CIDCFGR				0x60
#define RCC_R6SEMCR				0x64
#define RCC_R7CIDCFGR				0x68
#define RCC_R7SEMCR				0x6C
#define RCC_R8CIDCFGR				0x70
#define RCC_R8SEMCR				0x74
#define RCC_R9CIDCFGR				0x78
#define RCC_R9SEMCR				0x7C
#define RCC_R10CIDCFGR				0x80
#define RCC_R10SEMCR				0x84
#define RCC_R11CIDCFGR				0x88
#define RCC_R11SEMCR				0x8C
#define RCC_R12CIDCFGR				0x90
#define RCC_R12SEMCR				0x94
#define RCC_R13CIDCFGR				0x98
#define RCC_R13SEMCR				0x9C
#define RCC_R14CIDCFGR				0xA0
#define RCC_R14SEMCR				0xA4
#define RCC_R15CIDCFGR				0xA8
#define RCC_R15SEMCR				0xAC
#define RCC_R16CIDCFGR				0xB0
#define RCC_R16SEMCR				0xB4
#define RCC_R17CIDCFGR				0xB8
#define RCC_R17SEMCR				0xBC
#define RCC_R18CIDCFGR				0xC0
#define RCC_R18SEMCR				0xC4
#define RCC_R19CIDCFGR				0xC8
#define RCC_R19SEMCR				0xCC
#define RCC_R20CIDCFGR				0xD0
#define RCC_R20SEMCR				0xD4
#define RCC_R21CIDCFGR				0xD8
#define RCC_R21SEMCR				0xDC
#define RCC_R22CIDCFGR				0xE0
#define RCC_R22SEMCR				0xE4
#define RCC_R23CIDCFGR				0xE8
#define RCC_R23SEMCR				0xEC
#define RCC_R24CIDCFGR				0xF0
#define RCC_R24SEMCR				0xF4
#define RCC_R25CIDCFGR				0xF8
#define RCC_R25SEMCR				0xFC
#define RCC_R26CIDCFGR				0x100
#define RCC_R26SEMCR				0x104
#define RCC_R27CIDCFGR				0x108
#define RCC_R27SEMCR				0x10C
#define RCC_R28CIDCFGR				0x110
#define RCC_R28SEMCR				0x114
#define RCC_R29CIDCFGR				0x118
#define RCC_R29SEMCR				0x11C
#define RCC_R30CIDCFGR				0x120
#define RCC_R30SEMCR				0x124
#define RCC_R31CIDCFGR				0x128
#define RCC_R31SEMCR				0x12C
#define RCC_R32CIDCFGR				0x130
#define RCC_R32SEMCR				0x134
#define RCC_R33CIDCFGR				0x138
#define RCC_R33SEMCR				0x13C
#define RCC_R34CIDCFGR				0x140
#define RCC_R34SEMCR				0x144
#define RCC_R35CIDCFGR				0x148
#define RCC_R35SEMCR				0x14C
#define RCC_R36CIDCFGR				0x150
#define RCC_R36SEMCR				0x154
#define RCC_R37CIDCFGR				0x158
#define RCC_R37SEMCR				0x15C
#define RCC_R38CIDCFGR				0x160
#define RCC_R38SEMCR				0x164
#define RCC_R39CIDCFGR				0x168
#define RCC_R39SEMCR				0x16C
#define RCC_R40CIDCFGR				0x170
#define RCC_R40SEMCR				0x174
#define RCC_R41CIDCFGR				0x178
#define RCC_R41SEMCR				0x17C
#define RCC_R42CIDCFGR				0x180
#define RCC_R42SEMCR				0x184
#define RCC_R43CIDCFGR				0x188
#define RCC_R43SEMCR				0x18C
#define RCC_R44CIDCFGR				0x190
#define RCC_R44SEMCR				0x194
#define RCC_R45CIDCFGR				0x198
#define RCC_R45SEMCR				0x19C
#define RCC_R46CIDCFGR				0x1A0
#define RCC_R46SEMCR				0x1A4
#define RCC_R47CIDCFGR				0x1A8
#define RCC_R47SEMCR				0x1AC
#define RCC_R48CIDCFGR				0x1B0
#define RCC_R48SEMCR				0x1B4
#define RCC_R49CIDCFGR				0x1B8
#define RCC_R49SEMCR				0x1BC
#define RCC_R50CIDCFGR				0x1C0
#define RCC_R50SEMCR				0x1C4
#define RCC_R51CIDCFGR				0x1C8
#define RCC_R51SEMCR				0x1CC
#define RCC_R52CIDCFGR				0x1D0
#define RCC_R52SEMCR				0x1D4
#define RCC_R53CIDCFGR				0x1D8
#define RCC_R53SEMCR				0x1DC
#define RCC_R54CIDCFGR				0x1E0
#define RCC_R54SEMCR				0x1E4
#define RCC_R55CIDCFGR				0x1E8
#define RCC_R55SEMCR				0x1EC
#define RCC_R56CIDCFGR				0x1F0
#define RCC_R56SEMCR				0x1F4
#define RCC_R57CIDCFGR				0x1F8
#define RCC_R57SEMCR				0x1FC
#define RCC_R58CIDCFGR				0x200
#define RCC_R58SEMCR				0x204
#define RCC_R59CIDCFGR				0x208
#define RCC_R59SEMCR				0x20C
#define RCC_R60CIDCFGR				0x210
#define RCC_R60SEMCR				0x214
#define RCC_R61CIDCFGR				0x218
#define RCC_R61SEMCR				0x21C
#define RCC_R62CIDCFGR				0x220
#define RCC_R62SEMCR				0x224
#define RCC_R63CIDCFGR				0x228
#define RCC_R63SEMCR				0x22C
#define RCC_R64CIDCFGR				0x230
#define RCC_R64SEMCR				0x234
#define RCC_R65CIDCFGR				0x238
#define RCC_R65SEMCR				0x23C
#define RCC_R66CIDCFGR				0x240
#define RCC_R66SEMCR				0x244
#define RCC_R67CIDCFGR				0x248
#define RCC_R67SEMCR				0x24C
#define RCC_R68CIDCFGR				0x250
#define RCC_R68SEMCR				0x254
#define RCC_R69CIDCFGR				0x258
#define RCC_R69SEMCR				0x25C
#define RCC_R70CIDCFGR				0x260
#define RCC_R70SEMCR				0x264
#define RCC_R71CIDCFGR				0x268
#define RCC_R71SEMCR				0x26C
#define RCC_R72CIDCFGR				0x270
#define RCC_R72SEMCR				0x274
#define RCC_R73CIDCFGR				0x278
#define RCC_R73SEMCR				0x27C
#define RCC_R74CIDCFGR				0x280
#define RCC_R74SEMCR				0x284
#define RCC_R75CIDCFGR				0x288
#define RCC_R75SEMCR				0x28C
#define RCC_R76CIDCFGR				0x290
#define RCC_R76SEMCR				0x294
#define RCC_R77CIDCFGR				0x298
#define RCC_R77SEMCR				0x29C
#define RCC_R78CIDCFGR				0x2A0
#define RCC_R78SEMCR				0x2A4
#define RCC_R79CIDCFGR				0x2A8
#define RCC_R79SEMCR				0x2AC
#define RCC_R80CIDCFGR				0x2B0
#define RCC_R80SEMCR				0x2B4
#define RCC_R81CIDCFGR				0x2B8
#define RCC_R81SEMCR				0x2BC
#define RCC_R82CIDCFGR				0x2C0
#define RCC_R82SEMCR				0x2C4
#define RCC_R83CIDCFGR				0x2C8
#define RCC_R83SEMCR				0x2CC
#define RCC_R84CIDCFGR				0x2D0
#define RCC_R84SEMCR				0x2D4
#define RCC_R85CIDCFGR				0x2D8
#define RCC_R85SEMCR				0x2DC
#define RCC_R86CIDCFGR				0x2E0
#define RCC_R86SEMCR				0x2E4
#define RCC_R87CIDCFGR				0x2E8
#define RCC_R87SEMCR				0x2EC
#define RCC_R88CIDCFGR				0x2F0
#define RCC_R88SEMCR				0x2F4
#define RCC_R89CIDCFGR				0x2F8
#define RCC_R89SEMCR				0x2FC
#define RCC_R90CIDCFGR				0x300
#define RCC_R90SEMCR				0x304
#define RCC_R91CIDCFGR				0x308
#define RCC_R91SEMCR				0x30C
#define RCC_R92CIDCFGR				0x310
#define RCC_R92SEMCR				0x314
#define RCC_R93CIDCFGR				0x318
#define RCC_R93SEMCR				0x31C
#define RCC_R94CIDCFGR				0x320
#define RCC_R94SEMCR				0x324
#define RCC_R95CIDCFGR				0x328
#define RCC_R95SEMCR				0x32C
#define RCC_R96CIDCFGR				0x330
#define RCC_R96SEMCR				0x334
#define RCC_R97CIDCFGR				0x338
#define RCC_R97SEMCR				0x33C
#define RCC_R98CIDCFGR				0x340
#define RCC_R98SEMCR				0x344
#define RCC_R99CIDCFGR				0x348
#define RCC_R99SEMCR				0x34C
#define RCC_R100CIDCFGR				0x350
#define RCC_R100SEMCR				0x354
#define RCC_R101CIDCFGR				0x358
#define RCC_R101SEMCR				0x35C
#define RCC_R102CIDCFGR				0x360
#define RCC_R102SEMCR				0x364
#define RCC_R103CIDCFGR				0x368
#define RCC_R103SEMCR				0x36C
#define RCC_R104CIDCFGR				0x370
#define RCC_R104SEMCR				0x374
#define RCC_R105CIDCFGR				0x378
#define RCC_R105SEMCR				0x37C
#define RCC_R106CIDCFGR				0x380
#define RCC_R106SEMCR				0x384
#define RCC_R107CIDCFGR				0x388
#define RCC_R107SEMCR				0x38C
#define RCC_R108CIDCFGR				0x390
#define RCC_R108SEMCR				0x394
#define RCC_R109CIDCFGR				0x398
#define RCC_R109SEMCR				0x39C
#define RCC_R110CIDCFGR				0x3A0
#define RCC_R110SEMCR				0x3A4
#define RCC_R111CIDCFGR				0x3A8
#define RCC_R111SEMCR				0x3AC
#define RCC_R112CIDCFGR				0x3B0
#define RCC_R112SEMCR				0x3B4
#define RCC_R113CIDCFGR				0x3B8
#define RCC_R113SEMCR				0x3BC
#define RCC_GRSTCSETR				0x400
#define RCC_C1RSTCSETR				0x404
#define RCC_C1P1RSTCSETR			0x408
#define RCC_C2RSTCSETR				0x40C
#define RCC_HWRSTSCLRR				0x410
#define RCC_C1HWRSTSCLRR			0x414
#define RCC_C2HWRSTSCLRR			0x418
#define RCC_C1BOOTRSTSSETR			0x41C
#define RCC_C1BOOTRSTSCLRR			0x420
#define RCC_C2BOOTRSTSSETR			0x424
#define RCC_C2BOOTRSTSCLRR			0x428
#define RCC_C1SREQSETR				0x42C
#define RCC_C1SREQCLRR				0x430
#define RCC_CPUBOOTCR				0x434
#define RCC_STBYBOOTCR				0x438
#define RCC_LEGBOOTCR				0x43C
#define RCC_BDCR				0x440
#define RCC_D3DCR				0x444
#define RCC_D3DSR				0x448
#define RCC_RDCR				0x44C
#define RCC_C1MSRDCR				0x450
#define RCC_PWRLPDLYCR				0x454
#define RCC_C1CIESETR				0x458
#define RCC_C1CIFCLRR				0x45C
#define RCC_C2CIESETR				0x460
#define RCC_C2CIFCLRR				0x464
#define RCC_IWDGC1FZSETR			0x468
#define RCC_IWDGC1FZCLRR			0x46C
#define RCC_IWDGC1CFGSETR			0x470
#define RCC_IWDGC1CFGCLRR			0x474
#define RCC_IWDGC2FZSETR			0x478
#define RCC_IWDGC2FZCLRR			0x47C
#define RCC_IWDGC2CFGSETR			0x480
#define RCC_IWDGC2CFGCLRR			0x484
#define RCC_IWDGC3CFGSETR			0x488
#define RCC_IWDGC3CFGCLRR			0x48C
#define RCC_C3CFGR				0x490
#define RCC_MCO1CFGR				0x494
#define RCC_MCO2CFGR				0x498
#define RCC_OCENSETR				0x49C
#define RCC_OCENCLRR				0x4A0
#define RCC_OCRDYR				0x4A4
#define RCC_HSICFGR				0x4A8
#define RCC_MSICFGR				0x4AC
#define RCC_RTCDIVR				0x4B0
#define RCC_APB1DIVR				0x4B4
#define RCC_APB2DIVR				0x4B8
#define RCC_APB3DIVR				0x4BC
#define RCC_APB4DIVR				0x4C0
#define RCC_APBDBGDIVR				0x4C4
#define RCC_TIMG1PRER				0x4C8
#define RCC_TIMG2PRER				0x4CC
#define RCC_LSMCUDIVR				0x4D0
#define RCC_DDRCPCFGR				0x4D4
#define RCC_DDRCAPBCFGR				0x4D8
#define RCC_DDRPHYCAPBCFGR			0x4DC
#define RCC_DDRPHYCCFGR				0x4E0
#define RCC_DDRCFGR				0x4E4
#define RCC_DDRITFCFGR				0x4E8
#define RCC_SYSRAMCFGR				0x4F0
#define RCC_VDERAMCFGR				0x4F4
#define RCC_SRAM1CFGR				0x4F8
#define RCC_SRAM2CFGR				0x4FC
#define RCC_RETRAMCFGR				0x500
#define RCC_BKPSRAMCFGR				0x504
#define RCC_LPSRAM1CFGR				0x508
#define RCC_LPSRAM2CFGR				0x50C
#define RCC_LPSRAM3CFGR				0x510
#define RCC_OSPI1CFGR				0x514
#define RCC_OSPI2CFGR				0x518
#define RCC_FMCCFGR				0x51C
#define RCC_DBGCFGR				0x520
#define RCC_STM500CFGR				0x524
#define RCC_ETRCFGR				0x528
#define RCC_GPIOACFGR				0x52C
#define RCC_GPIOBCFGR				0x530
#define RCC_GPIOCCFGR				0x534
#define RCC_GPIODCFGR				0x538
#define RCC_GPIOECFGR				0x53C
#define RCC_GPIOFCFGR				0x540
#define RCC_GPIOGCFGR				0x544
#define RCC_GPIOHCFGR				0x548
#define RCC_GPIOICFGR				0x54C
#define RCC_GPIOJCFGR				0x550
#define RCC_GPIOKCFGR				0x554
#define RCC_GPIOZCFGR				0x558
#define RCC_HPDMA1CFGR				0x55C
#define RCC_HPDMA2CFGR				0x560
#define RCC_HPDMA3CFGR				0x564
#define RCC_LPDMACFGR				0x568
#define RCC_HSEMCFGR				0x56C
#define RCC_IPCC1CFGR				0x570
#define RCC_IPCC2CFGR				0x574
#define RCC_RTCCFGR				0x578
#define RCC_SYSCPU1CFGR				0x580
#define RCC_BSECCFGR				0x584
#define RCC_IS2MCFGR				0x58C
#define RCC_PLL2CFGR1				0x590
#define RCC_PLL2CFGR2				0x594
#define RCC_PLL2CFGR3				0x598
#define RCC_PLL2CFGR4				0x59C
#define RCC_PLL2CFGR5				0x5A0
#define RCC_PLL2CFGR6				0x5A8
#define RCC_PLL2CFGR7				0x5AC
#define RCC_PLL3CFGR1				0x5B8
#define RCC_PLL3CFGR2				0x5BC
#define RCC_PLL3CFGR3				0x5C0
#define RCC_PLL3CFGR4				0x5C4
#define RCC_PLL3CFGR5				0x5C8
#define RCC_PLL3CFGR6				0x5D0
#define RCC_PLL3CFGR7				0x5D4
#define RCC_HSIFMONCR				0x5E0
#define RCC_HSIFVALR				0x5E4
#define RCC_TIM1CFGR				0x700
#define RCC_TIM2CFGR				0x704
#define RCC_TIM3CFGR				0x708
#define RCC_TIM4CFGR				0x70C
#define RCC_TIM5CFGR				0x710
#define RCC_TIM6CFGR				0x714
#define RCC_TIM7CFGR				0x718
#define RCC_TIM8CFGR				0x71C
#define RCC_TIM10CFGR				0x720
#define RCC_TIM11CFGR				0x724
#define RCC_TIM12CFGR				0x728
#define RCC_TIM13CFGR				0x72C
#define RCC_TIM14CFGR				0x730
#define RCC_TIM15CFGR				0x734
#define RCC_TIM16CFGR				0x738
#define RCC_TIM17CFGR				0x73C
#define RCC_TIM20CFGR				0x740
#define RCC_LPTIM1CFGR				0x744
#define RCC_LPTIM2CFGR				0x748
#define RCC_LPTIM3CFGR				0x74C
#define RCC_LPTIM4CFGR				0x750
#define RCC_LPTIM5CFGR				0x754
#define RCC_SPI1CFGR				0x758
#define RCC_SPI2CFGR				0x75C
#define RCC_SPI3CFGR				0x760
#define RCC_SPI4CFGR				0x764
#define RCC_SPI5CFGR				0x768
#define RCC_SPI6CFGR				0x76C
#define RCC_SPI7CFGR				0x770
#define RCC_SPI8CFGR				0x774
#define RCC_SPDIFRXCFGR				0x778
#define RCC_USART1CFGR				0x77C
#define RCC_USART2CFGR				0x780
#define RCC_USART3CFGR				0x784
#define RCC_UART4CFGR				0x788
#define RCC_UART5CFGR				0x78C
#define RCC_USART6CFGR				0x790
#define RCC_UART7CFGR				0x794
#define RCC_UART8CFGR				0x798
#define RCC_UART9CFGR				0x79C
#define RCC_LPUART1CFGR				0x7A0
#define RCC_I2C1CFGR				0x7A4
#define RCC_I2C2CFGR				0x7A8
#define RCC_I2C3CFGR				0x7AC
#define RCC_I2C4CFGR				0x7B0
#define RCC_I2C5CFGR				0x7B4
#define RCC_I2C6CFGR				0x7B8
#define RCC_I2C7CFGR				0x7BC
#define RCC_I2C8CFGR				0x7C0
#define RCC_SAI1CFGR				0x7C4
#define RCC_SAI2CFGR				0x7C8
#define RCC_SAI3CFGR				0x7CC
#define RCC_SAI4CFGR				0x7D0
#define RCC_MDF1CFGR				0x7D8
#define RCC_ADF1CFGR				0x7DC
#define RCC_FDCANCFGR				0x7E0
#define RCC_HDPCFGR				0x7E4
#define RCC_ADC12CFGR				0x7E8
#define RCC_ADC3CFGR				0x7EC
#define RCC_ETH1CFGR				0x7F0
#define RCC_ETH2CFGR				0x7F4
#define RCC_USBHCFGR				0x7FC
#define RCC_USB2PHY1CFGR			0x800
#define RCC_USB2PHY2CFGR			0x804
#define RCC_USB3DRCFGR				0x808
#define RCC_USB3PCIEPHYCFGR			0x80C
#define RCC_PCIECFGR				0x810
#define RCC_USBTCCFGR				0x814
#define RCC_ETHSWCFGR				0x818
#define RCC_ETHSWACMCFGR			0x81C
#define RCC_ETHSWACMMSGCFGR			0x820
#define RCC_STGENCFGR				0x824
#define RCC_SDMMC1CFGR				0x830
#define RCC_SDMMC2CFGR				0x834
#define RCC_SDMMC3CFGR				0x838
#define RCC_GPUCFGR				0x83C
#define RCC_LTDCCFGR				0x840
#define RCC_DSICFGR				0x844
#define RCC_LVDSCFGR				0x850
#define RCC_CSICFGR				0x858
#define RCC_DCMIPPCFGR				0x85C
#define RCC_CCICFGR				0x860
#define RCC_VDECCFGR				0x864
#define RCC_VENCCFGR				0x868
#define RCC_RNGCFGR				0x870
#define RCC_PKACFGR				0x874
#define RCC_SAESCFGR				0x878
#define RCC_HASHCFGR				0x87C
#define RCC_CRYP1CFGR				0x880
#define RCC_CRYP2CFGR				0x884
#define RCC_IWDG1CFGR				0x888
#define RCC_IWDG2CFGR				0x88C
#define RCC_IWDG3CFGR				0x890
#define RCC_IWDG4CFGR				0x894
#define RCC_IWDG5CFGR				0x898
#define RCC_WWDG1CFGR				0x89C
#define RCC_WWDG2CFGR				0x8A0
#define RCC_VREFCFGR				0x8A8
#define RCC_DTSCFGR				0x8AC
#define RCC_CRCCFGR				0x8B4
#define RCC_SERCCFGR				0x8B8
#define RCC_OSPIIOMCFGR				0x8BC
#define RCC_GICV2MCFGR				0x8C0
#define RCC_I3C1CFGR				0x8C8
#define RCC_I3C2CFGR				0x8CC
#define RCC_I3C3CFGR				0x8D0
#define RCC_I3C4CFGR				0x8D4
#define RCC_MUXSELCFGR				0x1000
#define RCC_XBAR0CFGR				0x1018
#define RCC_XBAR1CFGR				0x101C
#define RCC_XBAR2CFGR				0x1020
#define RCC_XBAR3CFGR				0x1024
#define RCC_XBAR4CFGR				0x1028
#define RCC_XBAR5CFGR				0x102C
#define RCC_XBAR6CFGR				0x1030
#define RCC_XBAR7CFGR				0x1034
#define RCC_XBAR8CFGR				0x1038
#define RCC_XBAR9CFGR				0x103C
#define RCC_XBAR10CFGR				0x1040
#define RCC_XBAR11CFGR				0x1044
#define RCC_XBAR12CFGR				0x1048
#define RCC_XBAR13CFGR				0x104C
#define RCC_XBAR14CFGR				0x1050
#define RCC_XBAR15CFGR				0x1054
#define RCC_XBAR16CFGR				0x1058
#define RCC_XBAR17CFGR				0x105C
#define RCC_XBAR18CFGR				0x1060
#define RCC_XBAR19CFGR				0x1064
#define RCC_XBAR20CFGR				0x1068
#define RCC_XBAR21CFGR				0x106C
#define RCC_XBAR22CFGR				0x1070
#define RCC_XBAR23CFGR				0x1074
#define RCC_XBAR24CFGR				0x1078
#define RCC_XBAR25CFGR				0x107C
#define RCC_XBAR26CFGR				0x1080
#define RCC_XBAR27CFGR				0x1084
#define RCC_XBAR28CFGR				0x1088
#define RCC_XBAR29CFGR				0x108C
#define RCC_XBAR30CFGR				0x1090
#define RCC_XBAR31CFGR				0x1094
#define RCC_XBAR32CFGR				0x1098
#define RCC_XBAR33CFGR				0x109C
#define RCC_XBAR34CFGR				0x10A0
#define RCC_XBAR35CFGR				0x10A4
#define RCC_XBAR36CFGR				0x10A8
#define RCC_XBAR37CFGR				0x10AC
#define RCC_XBAR38CFGR				0x10B0
#define RCC_XBAR39CFGR				0x10B4
#define RCC_XBAR40CFGR				0x10B8
#define RCC_XBAR41CFGR				0x10BC
#define RCC_XBAR42CFGR				0x10C0
#define RCC_XBAR43CFGR				0x10C4
#define RCC_XBAR44CFGR				0x10C8
#define RCC_XBAR45CFGR				0x10CC
#define RCC_XBAR46CFGR				0x10D0
#define RCC_XBAR47CFGR				0x10D4
#define RCC_XBAR48CFGR				0x10D8
#define RCC_XBAR49CFGR				0x10DC
#define RCC_XBAR50CFGR				0x10E0
#define RCC_XBAR51CFGR				0x10E4
#define RCC_XBAR52CFGR				0x10E8
#define RCC_XBAR53CFGR				0x10EC
#define RCC_XBAR54CFGR				0x10F0
#define RCC_XBAR55CFGR				0x10F4
#define RCC_XBAR56CFGR				0x10F8
#define RCC_XBAR57CFGR				0x10FC
#define RCC_XBAR58CFGR				0x1100
#define RCC_XBAR59CFGR				0x1104
#define RCC_XBAR60CFGR				0x1108
#define RCC_XBAR61CFGR				0x110C
#define RCC_XBAR62CFGR				0x1110
#define RCC_XBAR63CFGR				0x1114
#define RCC_PREDIV0CFGR				0x1118
#define RCC_PREDIV1CFGR				0x111C
#define RCC_PREDIV2CFGR				0x1120
#define RCC_PREDIV3CFGR				0x1124
#define RCC_PREDIV4CFGR				0x1128
#define RCC_PREDIV5CFGR				0x112C
#define RCC_PREDIV6CFGR				0x1130
#define RCC_PREDIV7CFGR				0x1134
#define RCC_PREDIV8CFGR				0x1138
#define RCC_PREDIV9CFGR				0x113C
#define RCC_PREDIV10CFGR			0x1140
#define RCC_PREDIV11CFGR			0x1144
#define RCC_PREDIV12CFGR			0x1148
#define RCC_PREDIV13CFGR			0x114C
#define RCC_PREDIV14CFGR			0x1150
#define RCC_PREDIV15CFGR			0x1154
#define RCC_PREDIV16CFGR			0x1158
#define RCC_PREDIV17CFGR			0x115C
#define RCC_PREDIV18CFGR			0x1160
#define RCC_PREDIV19CFGR			0x1164
#define RCC_PREDIV20CFGR			0x1168
#define RCC_PREDIV21CFGR			0x116C
#define RCC_PREDIV22CFGR			0x1170
#define RCC_PREDIV23CFGR			0x1174
#define RCC_PREDIV24CFGR			0x1178
#define RCC_PREDIV25CFGR			0x117C
#define RCC_PREDIV26CFGR			0x1180
#define RCC_PREDIV27CFGR			0x1184
#define RCC_PREDIV28CFGR			0x1188
#define RCC_PREDIV29CFGR			0x118C
#define RCC_PREDIV30CFGR			0x1190
#define RCC_PREDIV31CFGR			0x1194
#define RCC_PREDIV32CFGR			0x1198
#define RCC_PREDIV33CFGR			0x119C
#define RCC_PREDIV34CFGR			0x11A0
#define RCC_PREDIV35CFGR			0x11A4
#define RCC_PREDIV36CFGR			0x11A8
#define RCC_PREDIV37CFGR			0x11AC
#define RCC_PREDIV38CFGR			0x11B0
#define RCC_PREDIV39CFGR			0x11B4
#define RCC_PREDIV40CFGR			0x11B8
#define RCC_PREDIV41CFGR			0x11BC
#define RCC_PREDIV42CFGR			0x11C0
#define RCC_PREDIV43CFGR			0x11C4
#define RCC_PREDIV44CFGR			0x11C8
#define RCC_PREDIV45CFGR			0x11CC
#define RCC_PREDIV46CFGR			0x11D0
#define RCC_PREDIV47CFGR			0x11D4
#define RCC_PREDIV48CFGR			0x11D8
#define RCC_PREDIV49CFGR			0x11DC
#define RCC_PREDIV50CFGR			0x11E0
#define RCC_PREDIV51CFGR			0x11E4
#define RCC_PREDIV52CFGR			0x11E8
#define RCC_PREDIV53CFGR			0x11EC
#define RCC_PREDIV54CFGR			0x11F0
#define RCC_PREDIV55CFGR			0x11F4
#define RCC_PREDIV56CFGR			0x11F8
#define RCC_PREDIV57CFGR			0x11FC
#define RCC_PREDIV58CFGR			0x1200
#define RCC_PREDIV59CFGR			0x1204
#define RCC_PREDIV60CFGR			0x1208
#define RCC_PREDIV61CFGR			0x120C
#define RCC_PREDIV62CFGR			0x1210
#define RCC_PREDIV63CFGR			0x1214
#define RCC_PREDIVSR1				0x1218
#define RCC_PREDIVSR2				0x121C
#define RCC_FINDIV0CFGR				0x1224
#define RCC_FINDIV1CFGR				0x1228
#define RCC_FINDIV2CFGR				0x122C
#define RCC_FINDIV3CFGR				0x1230
#define RCC_FINDIV4CFGR				0x1234
#define RCC_FINDIV5CFGR				0x1238
#define RCC_FINDIV6CFGR				0x123C
#define RCC_FINDIV7CFGR				0x1240
#define RCC_FINDIV8CFGR				0x1244
#define RCC_FINDIV9CFGR				0x1248
#define RCC_FINDIV10CFGR			0x124C
#define RCC_FINDIV11CFGR			0x1250
#define RCC_FINDIV12CFGR			0x1254
#define RCC_FINDIV13CFGR			0x1258
#define RCC_FINDIV14CFGR			0x125C
#define RCC_FINDIV15CFGR			0x1260
#define RCC_FINDIV16CFGR			0x1264
#define RCC_FINDIV17CFGR			0x1268
#define RCC_FINDIV18CFGR			0x126C
#define RCC_FINDIV19CFGR			0x1270
#define RCC_FINDIV20CFGR			0x1274
#define RCC_FINDIV21CFGR			0x1278
#define RCC_FINDIV22CFGR			0x127C
#define RCC_FINDIV23CFGR			0x1280
#define RCC_FINDIV24CFGR			0x1284
#define RCC_FINDIV25CFGR			0x1288
#define RCC_FINDIV26CFGR			0x128C
#define RCC_FINDIV27CFGR			0x1290
#define RCC_FINDIV28CFGR			0x1294
#define RCC_FINDIV29CFGR			0x1298
#define RCC_FINDIV30CFGR			0x129C
#define RCC_FINDIV31CFGR			0x12A0
#define RCC_FINDIV32CFGR			0x12A4
#define RCC_FINDIV33CFGR			0x12A8
#define RCC_FINDIV34CFGR			0x12AC
#define RCC_FINDIV35CFGR			0x12B0
#define RCC_FINDIV36CFGR			0x12B4
#define RCC_FINDIV37CFGR			0x12B8
#define RCC_FINDIV38CFGR			0x12BC
#define RCC_FINDIV39CFGR			0x12C0
#define RCC_FINDIV40CFGR			0x12C4
#define RCC_FINDIV41CFGR			0x12C8
#define RCC_FINDIV42CFGR			0x12CC
#define RCC_FINDIV43CFGR			0x12D0
#define RCC_FINDIV44CFGR			0x12D4
#define RCC_FINDIV45CFGR			0x12D8
#define RCC_FINDIV46CFGR			0x12DC
#define RCC_FINDIV47CFGR			0x12E0
#define RCC_FINDIV48CFGR			0x12E4
#define RCC_FINDIV49CFGR			0x12E8
#define RCC_FINDIV50CFGR			0x12EC
#define RCC_FINDIV51CFGR			0x12F0
#define RCC_FINDIV52CFGR			0x12F4
#define RCC_FINDIV53CFGR			0x12F8
#define RCC_FINDIV54CFGR			0x12FC
#define RCC_FINDIV55CFGR			0x1300
#define RCC_FINDIV56CFGR			0x1304
#define RCC_FINDIV57CFGR			0x1308
#define RCC_FINDIV58CFGR			0x130C
#define RCC_FINDIV59CFGR			0x1310
#define RCC_FINDIV60CFGR			0x1314
#define RCC_FINDIV61CFGR			0x1318
#define RCC_FINDIV62CFGR			0x131C
#define RCC_FINDIV63CFGR			0x1320
#define RCC_FINDIVSR1				0x1324
#define RCC_FINDIVSR2				0x1328
#define RCC_FCALCOBS0CFGR			0x1340
#define RCC_FCALCOBS1CFGR			0x1344
#define RCC_FCALCREFCFGR			0x1348
#define RCC_FCALCCR1				0x134C
#define RCC_FCALCCR2				0x1354
#define RCC_FCALCSR				0x1358
#define RCC_PLL4CFGR1				0x1360
#define RCC_PLL4CFGR2				0x1364
#define RCC_PLL4CFGR3				0x1368
#define RCC_PLL4CFGR4				0x136C
#define RCC_PLL4CFGR5				0x1370
#define RCC_PLL4CFGR6				0x1378
#define RCC_PLL4CFGR7				0x137C
#define RCC_PLL5CFGR1				0x1388
#define RCC_PLL5CFGR2				0x138C
#define RCC_PLL5CFGR3				0x1390
#define RCC_PLL5CFGR4				0x1394
#define RCC_PLL5CFGR5				0x1398
#define RCC_PLL5CFGR6				0x13A0
#define RCC_PLL5CFGR7				0x13A4
#define RCC_PLL6CFGR1				0x13B0
#define RCC_PLL6CFGR2				0x13B4
#define RCC_PLL6CFGR3				0x13B8
#define RCC_PLL6CFGR4				0x13BC
#define RCC_PLL6CFGR5				0x13C0
#define RCC_PLL6CFGR6				0x13C8
#define RCC_PLL6CFGR7				0x13CC
#define RCC_PLL7CFGR1				0x13D8
#define RCC_PLL7CFGR2				0x13DC
#define RCC_PLL7CFGR3				0x13E0
#define RCC_PLL7CFGR4				0x13E4
#define RCC_PLL7CFGR5				0x13E8
#define RCC_PLL7CFGR6				0x13F0
#define RCC_PLL7CFGR7				0x13F4
#define RCC_PLL8CFGR1				0x1400
#define RCC_PLL8CFGR2				0x1404
#define RCC_PLL8CFGR3				0x1408
#define RCC_PLL8CFGR4				0x140C
#define RCC_PLL8CFGR5				0x1410
#define RCC_PLL8CFGR6				0x1418
#define RCC_PLL8CFGR7				0x141C
#define RCC_VERR				0xFFF4
#define RCC_IDR					0xFFF8
#define RCC_SIDR				0xFFFC

#endif /* STM32MP25_RCC_H */
