/**
 * \file pappsomspp/processing/specpeptidoms/correctiontree.h
 * \date 24/03/2025
 * \author Aurélien Berthier
 * \brief save corrections to apply
 *
 * C++ implementation of the SpecPeptidOMS algorithm described in :
 * (1) Benoist, É.; Jean, G.; Rogniaux, H.; Fertin, G.; Tessier, D. SpecPeptidOMS Directly and
 * Rapidly Aligns Mass Spectra on Whole Proteomes and Identifies Peptides That Are Not Necessarily
 * Tryptic: Implications for Peptidomics. J. Proteome Res. 2025.
 * https://doi.org/10.1021/acs.jproteome.4c00870.
 */

/*
 * Copyright (c) 2025 Aurélien Berthier
 * <aurelien.berthier@ls2n.fr>
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include <vector>
#include <memory>

namespace pappso
{
namespace specpeptidoms
{
class CorrectionTree;
typedef std::shared_ptr<CorrectionTree> CorrectionTreeSp;

class CorrectionTree
{
  public:
  CorrectionTree();

  ~CorrectionTree();

  void addPeaks(std::size_t peak1, std::size_t peak2);
  std::vector<std::vector<std::size_t>> getPeaks() const;

  private:
  std::size_t peak;
  CorrectionTreeSp msp_left, msp_right;
  CorrectionTree(std::size_t peak);
};
} // namespace specpeptidoms
} // namespace pappso
