#!/bin/bash
#

if [ $# == 1 ]
then
  list=$(echo $1|awk -F'.' '{print $1}')
else
  list=$(ls *tex |awk -F'.' '{print $1}')
fi

for i in ${list}
do
  latexmk -dvi $i -C;
  latexmk -dvi $i;
  dvisvgm --no-fonts $i.dvi;
  mv $i.svg ../svg/
  latexmk -dvi $i -C;
done
