/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.deploy;

import com.sun.appserv.management.base.MapCapableBase;
import com.sun.appserv.management.deploy.DeploymentSource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.jar.JarInputStream;

public final class DeploymentSourceImpl
extends MapCapableBase
implements DeploymentSource {
    public static final String ARCHIVE_FILE_KEY = "Archive";
    public static final String IS_COMPLETE_ARCHIVE_KEY = "IsCompleteArchive";
    public static final String ENTRIES_ADDED_KEY = "EntriesAdded";
    public static final String ENTRIES_REMOVED_KEY = "EntriesRemoved";
    public static final String ENTRIES_DELETED_KEY = "EntriesDeleted";

    public DeploymentSourceImpl(DeploymentSource src) {
        this(src.asMap());
    }

    public <T extends Serializable> DeploymentSourceImpl(Map<String, T> m) {
        super(m, "com.sun.appserv.management.deploy.DeploymentSource");
        this.checkValidType(m, "com.sun.appserv.management.deploy.DeploymentSource");
        this.validateThrow();
    }

    public <T extends Serializable> DeploymentSourceImpl(String archiveFile, boolean isCompleteArchive, String[] entriesAdded, String[] entriesRemoved, String[] entriesDeleted, Map<String, T> other) {
        super(other, "com.sun.appserv.management.deploy.DeploymentSource");
        this.putField(ARCHIVE_FILE_KEY, (Serializable)((Object)archiveFile));
        this.putField(IS_COMPLETE_ARCHIVE_KEY, new Boolean(isCompleteArchive));
        this.putField(ENTRIES_ADDED_KEY, (Serializable)entriesAdded);
        this.putField(ENTRIES_REMOVED_KEY, (Serializable)entriesRemoved);
        this.putField(ENTRIES_DELETED_KEY, (Serializable)entriesDeleted);
        this.validateThrow();
    }

    @Override
    protected boolean validate() {
        boolean valid = this.validateNullOrOfType(ARCHIVE_FILE_KEY, String.class);
        if (valid) {
            valid = this.validateNullOrOfType(IS_COMPLETE_ARCHIVE_KEY, Boolean.class);
        }
        if (valid) {
            valid = this.validateNullOrOfType(ENTRIES_ADDED_KEY, String[].class) && this.validateNullOrOfType(ENTRIES_REMOVED_KEY, String[].class) && this.validateNullOrOfType(ENTRIES_DELETED_KEY, String[].class);
        }
        return valid;
    }

    @Override
    public String getMapClassName() {
        return "com.sun.appserv.management.deploy.DeploymentSource";
    }

    @Override
    public File getArchive() {
        return this.getFile(ARCHIVE_FILE_KEY);
    }

    @Override
    public JarInputStream getArchiveAsStream() throws IOException {
        return new JarInputStream(new FileInputStream(this.getArchive()));
    }

    @Override
    public boolean isCompleteArchive() {
        return this.getboolean(IS_COMPLETE_ARCHIVE_KEY);
    }

    @Override
    public String[] getEntriesAdded() {
        return this.getStringArray(ENTRIES_ADDED_KEY);
    }

    @Override
    public String[] getEntriesRemoved() {
        return this.getStringArray(ENTRIES_REMOVED_KEY);
    }

    @Override
    public String[] getEntriesDeleted() {
        return this.getStringArray(ENTRIES_DELETED_KEY);
    }
}

